/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.grelf.Statistics;
import net.grelf.Util;
import net.grelf.astro.Magnitude;
import net.grelf.astro.Star;
import net.grelf.astro.StarChart;
import net.grelf.grip.BlobFrame;
import net.grelf.grip.BlobMeas;
import net.grelf.grip.DefaultMeasurementHandler;
import net.grelf.grip.GRIP;
import net.grelf.grip.Measurement;
import net.grelf.grip.MeasurementHandler;
import net.grelf.grip.PointList;
import net.grelf.grip.Profile1D;
import net.grelf.image.Image;

public class BlobPanel
extends JPanel
implements ActionListener {
    private BlobFrame blobFrame;
    private BlobMeas meas;
    private static StarChart chart = null;
    private JLabel summaryLabel = new JLabel();
    private JButton xButton = new JButton("Profile in x");
    private JButton yButton = new JButton("Profile in y");
    private JButton idButton = new JButton("Identify as star");
    private JButton magButton = new JButton("Enter known magnitude");
    private JButton pasteButton = new JButton("Paste star from chart");
    private JButton clearButton = new JButton("Clear star data");
    private JButton adjustButton = new JButton("Adjust ring radii");
    private JButton closeButton = new JButton("Close window");

    public BlobPanel(BlobFrame blobFrame, BlobMeas blobMeas) {
        this.blobFrame = blobFrame;
        this.meas = blobMeas;
        Dimension dimension = new Dimension(220, 300);
        this.setPreferredSize(dimension);
        this.setSize(dimension);
        this.summaryLabel.setSize(dimension.width, this.summaryLabel.getHeight());
        this.add(this.summaryLabel);
        this.xButton.addActionListener(this);
        this.add(this.xButton);
        this.yButton.addActionListener(this);
        this.add(this.yButton);
        this.idButton.addActionListener(this);
        this.idButton.setToolTipText("Star to be estimated/positioned must have id but not magnitude/position");
        this.add(this.idButton);
        this.magButton.addActionListener(this);
        this.magButton.setEnabled(false);
        this.magButton.setToolTipText("If not getting magnitude(s) by pasting star data");
        this.add(this.magButton);
        this.clearButton.addActionListener(this);
        this.clearButton.setEnabled(false);
        this.add(this.clearButton);
        this.pasteButton.addActionListener(this);
        this.pasteButton.setEnabled(null != StarChart.getSelectedStar());
        this.pasteButton.setToolTipText("Must have created a GRIP star chart and clicked on a star");
        this.add(this.pasteButton);
        this.adjustButton.addActionListener(this);
        this.adjustButton.setToolTipText("Star must be entirely in inner disc. Outer ring pure background.");
        this.add(this.adjustButton);
        this.closeButton.addActionListener(this);
        this.add(this.closeButton);
    }

    public void updateSummary() {
        StringBuffer stringBuffer = new StringBuffer("<html>");
        stringBuffer.append(this.meas.toSummary("<br>"));
        if (this.meas.blob.isSaturated()) {
            stringBuffer.append("<br>SATURATED<br>");
        } else {
            stringBuffer.append("<br>Not saturated<br>");
        }
        this.summaryLabel.setText(stringBuffer.toString());
        this.pasteButton.setEnabled(null != StarChart.getSelectedStar());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.adjustButton) {
            float f = (float)Util.askDouble("Measuring circle radius factor? [1.0..10.0]", this.meas.blob.getMeasuringRingSizeFactor(), 1.0, 10.0);
            if (f >= 1.0f && f <= 10.0f) {
                this.meas.blob.setMeasuringRingSizeFactor(f);
                this.meas.blob.display(this.blobFrame.getParentFrame(), this.meas);
                this.blobFrame.dispose();
            }
        } else if (object == this.clearButton) {
            this.meas.setStar(null);
            this.magButton.setEnabled(false);
        } else if (object == this.closeButton) {
            this.blobFrame.dispose();
        } else if (object == this.idButton) {
            Star star = this.meas.getOrCreateStar();
            String string = Util.askString(this.idButton, "Identifier for this blob?", star.getId());
            if (null != string) {
                star.setOtherId(string);
                this.magButton.setEnabled(true);
            }
        } else if (object == this.magButton) {
            double d;
            Star star = this.meas.getOrCreateStar();
            double d2 = 0.0;
            if (null != star.getMagnitude()) {
                d2 = star.getMagnitude().getValue();
            }
            if (!Double.isNaN(d = Util.askDouble(this.magButton, "Known stellar magnitude of this blob?", d2, -30.0, 30.0))) {
                star.setMagnitude(new Magnitude((float)d));
            }
        } else if (object == this.pasteButton) {
            Star star = StarChart.getSelectedStar();
            if (null == star) {
                Util.logWarning("Pasted star is null");
            } else {
                chart = StarChart.getSourceOfSelectedStar();
                this.meas.setStar(star);
                this.clearButton.setEnabled(true);
            }
        } else if (object == this.xButton) {
            DefaultMeasurementHandler defaultMeasurementHandler = new DefaultMeasurementHandler();
            PointList pointList = new PointList(defaultMeasurementHandler);
            Image image = this.blobFrame.getImPane().getImage();
            int n = image.getWidth() - 1;
            int n2 = image.getHeight() / 2;
            pointList.add(new Point(0, n2));
            pointList.add(new Point(n, n2));
            this.showProfile(this.blobFrame, defaultMeasurementHandler, pointList);
        } else if (object == this.yButton) {
            DefaultMeasurementHandler defaultMeasurementHandler = new DefaultMeasurementHandler();
            PointList pointList = new PointList(defaultMeasurementHandler);
            Image image = this.blobFrame.getImPane().getImage();
            int n = image.getWidth() / 2;
            int n3 = image.getHeight() - 1;
            pointList.add(new Point(n, 0));
            pointList.add(new Point(n, n3));
            this.showProfile(this.blobFrame, defaultMeasurementHandler, pointList);
        }
        this.updateSummary();
        this.clearButton.setEnabled(null != this.meas.getStar());
        this.pasteButton.setEnabled(null != StarChart.getSelectedStar());
    }

    private void showProfile(BlobFrame blobFrame, MeasurementHandler measurementHandler, PointList pointList) {
        Profile1D profile1D = new Profile1D(blobFrame, pointList);
        Image image = blobFrame.getImPane().getImage();
        int n = image.getRange().high;
        Statistics[] statisticsArray = profile1D.getStatistics(0, n);
        blobFrame.getGP().setMeasured(true);
        blobFrame.getGP().repaint();
        ArrayList<Measurement> arrayList = new ArrayList<Measurement>();
        if (statisticsArray.length == 1) {
            arrayList.add(new Measurement("grey min", statisticsArray[0].min, ""));
            arrayList.add(new Measurement("grey mean ", statisticsArray[0].mean, ""));
            arrayList.add(new Measurement("grey std.dev.", statisticsArray[0].stdDev, ""));
            arrayList.add(new Measurement("grey mode", statisticsArray[0].mode, ""));
            arrayList.add(new Measurement("grey max", statisticsArray[0].max, ""));
        } else if (statisticsArray.length == 3) {
            arrayList.add(new Measurement("red min", statisticsArray[0].min, ""));
            arrayList.add(new Measurement("red mean ", statisticsArray[0].mean, ""));
            arrayList.add(new Measurement("red std.dev.", statisticsArray[0].stdDev, ""));
            arrayList.add(new Measurement("red mode", statisticsArray[0].mode, ""));
            arrayList.add(new Measurement("red max", statisticsArray[0].max, ""));
            arrayList.add(new Measurement("green min", statisticsArray[1].min, ""));
            arrayList.add(new Measurement("green mean ", statisticsArray[1].mean, ""));
            arrayList.add(new Measurement("green std.dev.", statisticsArray[1].stdDev, ""));
            arrayList.add(new Measurement("green mode", statisticsArray[1].mode, ""));
            arrayList.add(new Measurement("green max", statisticsArray[1].max, ""));
            arrayList.add(new Measurement("blue min", statisticsArray[2].min, ""));
            arrayList.add(new Measurement("blue mean ", statisticsArray[2].mean, ""));
            arrayList.add(new Measurement("blue std.dev.", statisticsArray[2].stdDev, ""));
            arrayList.add(new Measurement("blue mode", statisticsArray[2].mode, ""));
            arrayList.add(new Measurement("blue max", statisticsArray[2].max, ""));
        } else {
            for (int i = 0; i < statisticsArray.length; ++i) {
                arrayList.add(new Measurement("channel " + i + " min", statisticsArray[i].min, ""));
                arrayList.add(new Measurement("channel " + i + " mean ", statisticsArray[i].mean, ""));
                arrayList.add(new Measurement("channel " + i + " std.dev.", statisticsArray[i].stdDev, ""));
                arrayList.add(new Measurement("channel " + i + " mode", statisticsArray[i].mode, ""));
                arrayList.add(new Measurement("channel " + i + " max", statisticsArray[i].max, ""));
            }
        }
        arrayList.add(new Measurement("Profile", profile1D, ""));
        if (statisticsArray.length == 3) {
            arrayList.add(new Measurement("(black trace is square root of sum of squares of channels)", "", ""));
        }
        blobFrame.setCursor(GRIP.GRIP_DEFAULT_CURSOR);
        measurementHandler.process(blobFrame, pointList, arrayList);
    }
}

