/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.awt.Point;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import net.grelf.FileIO;
import net.grelf.Util;
import net.grelf.grip.ConfigDialogue;
import net.grelf.grip.Defect;

public class Config {
    private static final String CONFIG_PATH = "grip.properties";
    private static final double MS_PER_HOUR = 3600000.0;
    static Properties config = null;
    static List<Defect> defects = null;

    private Config() {
    }

    public static List<String> getKeys() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration<?> enumeration = config.propertyNames();
        while (enumeration.hasMoreElements()) {
            arrayList.add((String)enumeration.nextElement());
        }
        return arrayList;
    }

    public static String getValue(String string) {
        return config.getProperty(string);
    }

    public static void load() {
        config = new Properties();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(CONFIG_PATH);
            config.load(fileInputStream);
            fileInputStream.close();
        }
        catch (IOException iOException) {
            Util.logInfo("Creating new file grip.properties");
            Config.set("Camera.prompt", "Camera");
            Config.set("Camera.type", "string");
            Config.set("Camera.value", "");
            Config.set("Camera.default", "");
            Config.set("Lens.prompt", "Lens / telescope");
            Config.set("Lens.type", "string");
            Config.set("Lens.value", "");
            Config.set("Lens.default", "string");
            Config.set("Detector.width.mm.prompt", "Camera detector width (mm)");
            Config.set("Detector.width.mm.type", "double");
            Config.set("Detector.width.mm.value", "36");
            Config.set("Detector.width.mm.min", "1");
            Config.set("Detector.width.mm.max", "100");
            Config.set("Detector.width.mm.default", "36");
            Config.set("Detector.height.mm.prompt", "Camera detector height (mm)");
            Config.set("Detector.height.mm.type", "double");
            Config.set("Detector.height.mm.value", "24");
            Config.set("Detector.height.mm.min", "1");
            Config.set("Detector.height.mm.max", "100");
            Config.set("Detector.height.mm.default", "24");
            Config.set("RawBits.prompt", "RAW bits per channel");
            Config.set("RawBits.type", "int");
            Config.set("RawBits.value", "14");
            Config.set("RawBits.min", "8");
            Config.set("RawBits.max", "16");
            Config.set("RawBits.default", "14");
            Config.set("RawDefectLevel.prompt", "RAW defects, proportion of maximum level");
            Config.set("RawDefectLevel.type", "double");
            Config.set("RawDefectLevel.value", "0.8");
            Config.set("RawDefectLevel.min", "0.1");
            Config.set("RawDefectLevel.max", "1.0");
            Config.set("RawDefectLevel.default", "0.8");
            Config.set("RawMarginBottom.prompt", "RAW margin, bottom (px)");
            Config.set("RawMarginBottom.type", "int");
            Config.set("RawMarginBottom.value", "0");
            Config.set("RawMarginBottom.min", "0");
            Config.set("RawMarginBottom.max", "1000");
            Config.set("RawMarginBottom.default", "0");
            Config.set("RawMarginLeft.prompt", "RAW margin, left (px)");
            Config.set("RawMarginLeft.type", "int");
            Config.set("RawMarginLeft.value", "108");
            Config.set("RawMarginLeft.min", "0");
            Config.set("RawMarginLeft.max", "1000");
            Config.set("RawMarginLeft.default", "0");
            Config.set("RawMarginRight.prompt", "RAW margin, right (px)");
            Config.set("RawMarginRight.type", "int");
            Config.set("RawMarginRight.value", "0");
            Config.set("RawMarginRight.min", "0");
            Config.set("RawMarginRight.max", "1000");
            Config.set("RawMarginRight.default", "0");
            Config.set("RawMarginTop.prompt", "RAW margin, top (px)");
            Config.set("RawMarginTop.type", "int");
            Config.set("RawMarginTop.value", "42");
            Config.set("RawMarginTop.min", "0");
            Config.set("RawMarginTop.max", "1000");
            Config.set("RawMarginTop.default", "0");
            Config.set("Copyright.prompt", "Copyright");
            Config.set("Copyright.type", "string");
            Config.set("Copyright.value", "");
            Config.set("Copyright.default", "string");
            Config.set("Observer.prompt", "Observer");
            Config.set("Observer.type", "string");
            Config.set("Observer.value", "");
            Config.set("Observer.default", "string");
            Config.set("Magnifier.px.prompt", "Hover magnifier source width & height (pixels)");
            Config.set("Magnifier.px.type", "int");
            Config.set("Magnifier.px.value", "100");
            Config.set("Magnifier.px.min", "20");
            Config.set("Magnifier.px.max", "150");
            Config.set("Magnifier.px.default", "150");
            Config.set("NBrightest.prompt", "No. of brightest stars for matching images");
            Config.set("NBrightest.type", "int");
            Config.set("NBrightest.value", "24");
            Config.set("NBrightest.min", "8");
            Config.set("NBrightest.max", "256");
            Config.set("NBrightest.default", "24");
            Config.set("StarSegmentDifference.prompt", "Star segmenter: difference");
            Config.set("StarSegmentDifference.type", "int");
            Config.set("StarSegmentDifference.value", "38");
            Config.set("StarSegmentDifference.min", "10");
            Config.set("StarSegmentDifference.max", "100");
            Config.set("StarSegmentDifference.default", "38");
            Config.set("StarSegmentRadius.prompt", "Star segmenter: radius");
            Config.set("StarSegmentRadius.type", "int");
            Config.set("StarSegmentRadius.value", "16");
            Config.set("StarSegmentRadius.min", "10");
            Config.set("StarSegmentRadius.max", "100");
            Config.set("StarSegmentRadius.default", "16");
            Config.set("BackgroundCellFactor.prompt", "Background correction cell width & height factor");
            Config.set("BackgroundCellFactor.type", "int");
            Config.set("BackgroundCellFactor.value", "16");
            Config.set("BackgroundCellFactor.min", "4");
            Config.set("BackgroundCellFactor.max", "512");
            Config.set("BackgroundCellFactor.default", "16");
            Config.set("BackgroundFactor.prompt", "Background correction reduction factor");
            Config.set("BackgroundFactor.type", "double");
            Config.set("BackgroundFactor.value", "0.97");
            Config.set("BackgroundFactor.min", "0.5");
            Config.set("BackgroundFactor.max", "1.0");
            Config.set("BackgroundFactor.default", "0.97");
            Config.set("PathHipparcos.prompt", "Path to Hipparcos data file");
            Config.set("PathHipparcos.type", "path");
            Config.set("PathHipparcos.value", "hip_main.dat");
            Config.set("PathHipparcos.default", "hip_main.dat");
            Config.set("PathTycho.prompt", "Path to Tycho data file");
            Config.set("PathTycho.type", "path");
            Config.set("PathTycho.value", "tyc_main.dat");
            Config.set("PathTycho.default", "tyc_main.dat");
            Config.set("TimeZone.prompt", "Time zone offset hours");
            Config.set("TimeZone.type", "double");
            int n = TimeZone.getDefault().getRawOffset();
            double d = (double)n / 3600000.0;
            Config.set("TimeZone.value", "" + d);
            Config.set("TimeZone.min", "-12.0");
            Config.set("TimeZone.max", "+14.0");
            Config.set("TimeZone.default", "" + d);
            Config.save();
            new ConfigDialogue();
        }
    }

    public static void loadDefectsFromCSV() {
        String string = FileIO.selectInputFile("Open defects file");
        if (null != string) {
            int n = 0;
            try {
                String string2;
                ArrayList<Defect> arrayList = new ArrayList<Defect>();
                BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
                n = 1;
                while (null != (string2 = bufferedReader.readLine())) {
                    String[] stringArray = string2.split(",");
                    if (stringArray.length >= 2) {
                        int n2 = Integer.parseInt(stringArray[0]);
                        int n3 = Integer.parseInt(stringArray[1]);
                        Util.logInfo("Loaded defect {0} at ({1}, {2})", n, n2, n3);
                        Point point = new Point(n2, n3);
                        arrayList.add(new Defect(point, null));
                    }
                    ++n;
                }
                bufferedReader.close();
                defects = arrayList;
            }
            catch (IOException iOException) {
                Util.warning("Sorry", "Could not open\n{0}", string);
            }
            catch (NumberFormatException numberFormatException) {
                Util.warning("Error", "Error in parsing line " + n);
            }
        }
    }

    protected static void save() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(CONFIG_PATH);
            Util.logInfo("Updating file grip.properties");
            config.store(fileOutputStream, "Last modified " + new Date().toString());
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            Util.warning("Error", iOException);
        }
    }

    protected static void set(String string, String string2) {
        config.setProperty(string, string2);
    }
}

