/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.util.List;
import javax.swing.JComponent;
import net.grelf.FileIO;
import net.grelf.FileIOImageFilter;
import net.grelf.Util;
import net.grelf.grip.ImageSummary;
import net.grelf.image.Image;
import net.grelf.image.Image8or16Base;
import net.grelf.image.ImageBase;

public class DriveErrorsGraph
extends JComponent {
    private static final int GRAPH_WIDTH = 400;
    private static final int GRAPH_HEIGHT = 400;
    private List<ImageSummary> imData;
    private float minX = 0.0f;
    private float maxX = 0.0f;
    private float minY = 0.0f;
    private float maxY = 0.0f;
    private int minT = 0;
    private int maxT = 0;
    private boolean[] selected;
    private static final Color BACKGROUND = new Color(255, 255, 255);
    private static final Color RED = new Color(255, 0, 0);
    private static final Color GREY = new Color(192, 192, 192);
    private static final Color BLUE = new Color(0, 0, 255);
    private static final Color BLACK = new Color(0, 0, 0);
    private static final int CROSS_ARM = 3;

    public DriveErrorsGraph(List<ImageSummary> list) {
        this.imData = list;
        this.selected = new boolean[list.size()];
        for (int i = 0; i < this.selected.length; ++i) {
            this.selected[i] = true;
        }
        Dimension dimension = new Dimension(400, 400);
        this.setSize(dimension);
        this.setPreferredSize(dimension);
        float f = 0.0f;
        float f2 = 0.0f;
        for (ImageSummary imageSummary : this.imData) {
            if ((f += imageSummary.dx) > this.maxX) {
                this.maxX = f;
            } else if (f < this.minX) {
                this.minX = f;
            }
            f2 += imageSummary.dy;
            if (f2 > this.maxY) {
                this.maxY = f2;
                continue;
            }
            if (!(f2 < this.minY)) continue;
            this.minY = f2;
        }
        this.minT = (int)list.get((int)0).captureTimeMs;
        this.maxT = (int)list.get((int)(list.size() - 1)).captureTimeMs;
    }

    protected void draw(Graphics2D graphics2D, int n, int n2) {
        int n3 = n + 60;
        int n4 = n2 + 400 - 60;
        float f = StrictMath.min(this.minX, this.minY);
        float f2 = StrictMath.max(this.maxX, this.maxY);
        double d = 280.0 / (double)(this.maxT - this.minT);
        double d2 = 280.0 / (double)(f2 - f);
        graphics2D.setPaint(BACKGROUND);
        graphics2D.fillRect(n, n2, n + 400, n2 + 400);
        graphics2D.setPaint(BLACK);
        graphics2D.drawLine(n3, n4, n3 + 400 - 120, n4);
        graphics2D.drawString("time (s)", n3 + 140, n4 + 30);
        graphics2D.drawString("" + this.minT / 1000, n3, n4 + 25);
        graphics2D.drawString("" + this.maxT / 1000, n3 + 400 - 120, n4 + 25);
        graphics2D.drawLine(n3, n4, n3, n4 - 400 + 120);
        int n5 = n3 - 30;
        int n6 = n4 - 400 + 90;
        graphics2D.setPaint(RED);
        graphics2D.drawString("X (px)", n5, n6);
        graphics2D.setPaint(BLUE);
        graphics2D.drawString("Y (px)", n5, n6 + 20);
        graphics2D.setPaint(BLACK);
        n5 = n3 - 60 + 25;
        graphics2D.drawString("" + (int)f, n5, n4);
        graphics2D.drawString("" + (int)f2, n5, n4 - 400 + 120);
        float f3 = 0.0f;
        float f4 = 0.0f;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        for (ImageSummary imageSummary : this.imData) {
            f3 += imageSummary.dx;
            f4 += imageSummary.dy;
            if (this.selected[n7]) {
                graphics2D.setPaint(RED);
            } else {
                graphics2D.setPaint(GREY);
            }
            int n12 = n3 + (int)StrictMath.round(d * (double)(imageSummary.captureTimeMs - (long)this.minT));
            int n13 = n4 - (int)StrictMath.round(d2 * (double)(f3 - this.minX));
            this.drawCross(graphics2D, n12, n13);
            if (n7 > 0) {
                graphics2D.drawLine(n8, n9, n12, n13);
            }
            n8 = n12;
            n9 = n13;
            if (this.selected[n7]) {
                graphics2D.setPaint(BLUE);
            } else {
                graphics2D.setPaint(GREY);
            }
            n13 = n4 - (int)StrictMath.round(d2 * (double)(f4 - this.minY));
            this.drawCross(graphics2D, n12, n13);
            if (n7 > 0) {
                graphics2D.drawLine(n10, n11, n12, n13);
            }
            n10 = n12;
            n11 = n13;
            graphics2D.setPaint(BLACK);
            if (n7 % 5 == 0) {
                graphics2D.drawLine(n12, n4, n12, n4 + 10);
            } else {
                graphics2D.drawLine(n12, n4, n12, n4 + 5);
            }
            ++n7;
        }
    }

    private void drawCross(Graphics2D graphics2D, int n, int n2) {
        graphics2D.drawLine(n - 3, n2, n + 3, n2);
        graphics2D.drawLine(n, n2 - 3, n, n2 + 3);
    }

    public void repaint(boolean[] blArray) {
        for (int i = 0; i < this.selected.length; ++i) {
            this.selected[i] = blArray[i];
        }
        this.draw((Graphics2D)this.getGraphics(), 0, 0);
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        this.draw((Graphics2D)graphics, 0, 0);
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (n > 0) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        this.draw(graphics2D, 0, 0);
        return 0;
    }

    public void saveAsImage() {
        String string = FileIO.selectOutputFile("Save graph as image", null, new FileIOImageFilter[]{new FileIOImageFilter(3), new FileIOImageFilter(5), new FileIOImageFilter(4)}, "DriveErrors.png");
        if (string != null) {
            Image image = ImageBase.createImage(400, 400, 3, 8);
            BufferedImage bufferedImage = ((Image8or16Base)image).getBufferedImage();
            if (null != bufferedImage) {
                Graphics2D graphics2D = bufferedImage.createGraphics();
                this.draw(graphics2D, 0, 0);
                image.save(string);
            } else {
                Util.message(this, "Sorry", "Could not create image");
            }
        }
    }
}

