/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import net.grelf.grip.ImCurveDialogue;

public class ImCurve
extends JComponent
implements MouseListener,
MouseMotionListener,
KeyListener {
    private List<Point> points = new ArrayList<Point>();
    private int currentPointIndex = -1;
    private ImCurveDialogue caller;
    private static final int OX = 50;
    private static final int OY = 300;

    public List<Point> getPoints() {
        return this.points;
    }

    public ImCurve(ImCurveDialogue imCurveDialogue) {
        this.caller = imCurveDialogue;
        this.addPoint(0, 0);
        this.addPoint(255, 255);
        this.setFocusable(true);
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setPreferredSize(new Dimension(400, 400));
    }

    public void replacePoints(Point[] pointArray) {
        this.points = new ArrayList<Point>();
        for (int i = 0; i < pointArray.length; ++i) {
            this.addPoint(pointArray[i].x, pointArray[i].y);
        }
        this.repaint();
        this.caller.update(this.points);
    }

    protected void replacePoints(List<Point> list) {
        this.points = list;
        this.repaint();
        this.caller.update(list);
    }

    public void addPoint(int n, int n2) {
        this.points.add(new Point(n, n2));
    }

    public int getDistanceSquared(Point point, Point point2) {
        int n = point.x - point2.x;
        int n2 = point.y - point2.y;
        return n * n + n2 * n2;
    }

    public int getNearestPointIndex(Point point) {
        if (this.points.size() < 1) {
            return -1;
        }
        int n = this.getDistanceSquared(point, this.points.get(0));
        int n2 = 0;
        for (int i = 1; i < this.points.size(); ++i) {
            int n3 = this.getDistanceSquared(point, this.points.get(i));
            if (n3 >= n) continue;
            n = n3;
            n2 = i;
        }
        return n2;
    }

    public Point[] getPointsAsArray() {
        Point[] pointArray = new Point[this.points.size()];
        for (int i = 0; i < this.points.size(); ++i) {
            pointArray[i] = this.points.get(i);
        }
        return pointArray;
    }

    public int getSecondNearestPointIndex(Point point, int n) {
        int n2;
        int n3;
        if (this.points.size() < 2) {
            return -1;
        }
        if (0 == n) {
            n3 = this.getDistanceSquared(point, this.points.get(1));
            n2 = 1;
        } else {
            n3 = this.getDistanceSquared(point, this.points.get(0));
            n2 = 0;
        }
        for (int i = 0; i < this.points.size(); ++i) {
            int n4;
            if (i == n || (n4 = this.getDistanceSquared(point, this.points.get(i))) >= n3) continue;
            n3 = n4;
            n2 = i;
        }
        return n2;
    }

    @Override
    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (1 < this.points.size()) {
            int n;
            graphics2D.setPaint(Color.blue);
            for (n = 0; n < 256; n += 50) {
                graphics2D.drawLine(this.plotX(n), this.plotY(0), this.plotX(n), this.plotY(255));
            }
            for (n = 0; n < 256; n += 50) {
                graphics2D.drawLine(this.plotX(0), this.plotY(n), this.plotX(255), this.plotY(n));
            }
            graphics2D.setPaint(Color.black);
            Point point = this.plot(this.points.get(0));
            this.drawPoint(graphics2D, point, 0);
            for (int i = 1; i < this.points.size(); ++i) {
                Point point2 = this.plot(this.points.get(i));
                graphics2D.drawLine(point.x, point.y, point2.x, point2.y);
                this.drawPoint(graphics2D, point2, i);
                point = point2;
            }
        }
    }

    private Point plot(Point point) {
        return new Point(this.plotX(point.x), this.plotY(point.y));
    }

    private int plotX(int n) {
        return 50 + n;
    }

    private int plotY(int n) {
        return 300 - n;
    }

    private Point unplot(Point point) {
        return new Point(this.unplotX(point.x), this.unplotY(point.y));
    }

    private int unplotX(int n) {
        return n - 50;
    }

    private int unplotY(int n) {
        return 300 - n;
    }

    private void drawPoint(Graphics2D graphics2D, Point point, int n) {
        if (n == this.currentPointIndex) {
            graphics2D.fillRect(point.x - 3, point.y - 3, 7, 7);
        } else {
            graphics2D.drawRect(point.x - 3, point.y - 3, 7, 7);
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (127 == keyEvent.getKeyCode() && -1 != this.currentPointIndex && 0 != this.currentPointIndex && this.points.size() - 1 != this.currentPointIndex) {
            this.points.remove(this.currentPointIndex);
            this.currentPointIndex = -1;
            this.repaint();
            this.caller.update(this.points);
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (0 < this.currentPointIndex && this.points.size() - 1 > this.currentPointIndex) {
            int n = Math.min(255, Math.max(0, this.unplotX(mouseEvent.getX())));
            int n2 = Math.min(255, Math.max(0, this.unplotY(mouseEvent.getY())));
            this.points.set(this.currentPointIndex, new Point(n, n2));
            this.repaint();
            this.caller.update(this.points);
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        Point point = this.unplot(mouseEvent.getPoint());
        if (point.x >= 0 && point.x < 256 && point.y >= 0 && point.y < 256) {
            this.currentPointIndex = this.getNearestPointIndex(point);
            if (-1 == this.currentPointIndex) {
                this.points.add(point);
                this.currentPointIndex = this.points.size() - 1;
            } else {
                Point point2 = this.points.get(this.currentPointIndex);
                if (400 < this.getDistanceSquared(point, point2)) {
                    if (point.x > point2.x) {
                        ++this.currentPointIndex;
                    }
                    this.points.add(this.currentPointIndex, point);
                }
            }
            this.repaint();
            this.caller.update(this.points);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

