/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import net.grelf.AbstractDialogue;
import net.grelf.grip.ImFrame;
import net.grelf.grip.ImPreview;
import net.grelf.grip.ImPreviewActor;
import net.grelf.grip.RangeSlider;
import net.grelf.grip.RangeSliderUser;
import net.grelf.image.Image;
import net.grelf.image.RangeInt;
import net.grelf.image.Threshold;

public class ImThreshDialogue
extends AbstractDialogue
implements ActionListener,
ImPreviewActor,
RangeSliderUser {
    private Threshold thresh;
    private Image image;
    private int maxLevel;
    private RangeSlider slider;
    private JPanel sliderPanel = new JPanel();
    private JButton okButton = new JButton("OK");
    private JButton cancelButton = new JButton("Cancel");
    private JPanel buttonPanel = new JPanel();
    private ImPreview imPreview;
    private boolean accepted = false;

    public Threshold getThresh() {
        return this.thresh;
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    public ImThreshDialogue(ImFrame imFrame) {
        super((Frame)imFrame, "Adjust threshold");
        int n;
        Image image = imFrame.getImPane().getImage();
        this.maxLevel = image.getRange().high;
        int n2 = image.getNBands();
        this.thresh = new Threshold(n2);
        for (n = 0; n < n2; ++n) {
            this.thresh.th[n].low = this.maxLevel / 2;
            this.thresh.th[n].high = this.maxLevel;
        }
        n = (int)((double)this.maxLevel / 20.0);
        int n3 = n * 2;
        RangeInt rangeInt = new RangeInt(0, this.maxLevel);
        this.slider = new RangeSlider(rangeInt, this.thresh.th[0], 0, Color.gray, n3, n, "", Color.black, 1, this);
        this.sliderPanel.setLayout(new BorderLayout());
        this.sliderPanel.add((Component)this.slider, "Center");
        this.getContentPane().add((Component)this.sliderPanel, "Center");
        this.imPreview = new ImPreview(image, this);
        this.getContentPane().add((Component)this.imPreview, "North");
        this.buttonPanel.setLayout(new BorderLayout());
        this.okButton.addActionListener(this);
        this.buttonPanel.add((Component)this.okButton, "Center");
        this.cancelButton.addActionListener(this);
        this.buttonPanel.add((Component)this.cancelButton, "East");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.setDefaultCloseOperation(1);
        this.pack();
        this.setModal(true);
        this.setVisible(true);
    }

    @Override
    public void rangeChanged(RangeSlider rangeSlider, RangeInt rangeInt) {
        this.thresh.th[0].low = rangeInt.low;
        this.thresh.th[0].high = rangeInt.high;
        this.imPreview.refresh();
    }

    @Override
    public void previewAction(Image image, Image image2, Point point, int n, int n2) {
        int n3 = 1;
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        nArray2[0] = 0;
        double d = image.getRangeDouble().high;
        double d2 = image2.getRangeDouble().high;
        double d3 = d2 / d;
        int n4 = point.y - n2 / 2;
        for (int i = 0; i < n2; ++i) {
            int n5 = point.x - n / 2;
            for (int j = 0; j < n; ++j) {
                nArray = image.getPixel(n5, n4);
                if (nArray[0] >= this.thresh.th[0].low && nArray[0] <= this.thresh.th[0].high) {
                    image2.setPixel(j, i, nArray2);
                } else {
                    nArray[0] = (int)(d3 * (double)nArray[0]);
                    image2.setPixel(j, i, nArray);
                }
                ++n5;
            }
            ++n4;
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            this.accepted = true;
            this.setVisible(false);
        } else if (object == this.cancelButton) {
            this.accepted = false;
            this.setVisible(false);
        }
    }

    public static Threshold askThreshold(ImFrame imFrame) {
        Threshold threshold = new Threshold(imFrame.getImPane().getImage().getNBands());
        ImThreshDialogue imThreshDialogue = new ImThreshDialogue(imFrame);
        threshold = imThreshDialogue.isAccepted() ? imThreshDialogue.getThresh() : null;
        imThreshDialogue.setVisible(false);
        imThreshDialogue.dispose();
        return threshold;
    }
}

