/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.grelf.AbstractDialogue;
import net.grelf.Util;
import net.grelf.grip.ImageSizeAction;

public class ImageSizeDialogue
extends AbstractDialogue
implements ActionListener {
    private int width;
    private int height;
    private ImageSizeAction processor;
    private JLabel wdLabel;
    private JTextField wdTextField;
    private JPanel wdPanel;
    private JLabel htLabel;
    private JTextField htTextField;
    private JPanel htPanel;
    private JButton okButton;

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public ImageSizeDialogue(int n, int n2, String string, ImageSizeAction imageSizeAction) {
        this.setTitle(string);
        this.setModal(true);
        this.width = n;
        this.height = n2;
        this.processor = imageSizeAction;
        this.wdLabel = new JLabel("Image width (pixels) ");
        this.wdTextField = new JTextField("" + n, 40);
        this.wdPanel = new JPanel(new BorderLayout());
        this.wdPanel.add((Component)this.wdLabel, "West");
        this.wdPanel.add((Component)this.wdTextField, "East");
        this.htLabel = new JLabel("Image height (pixels) ");
        this.htTextField = new JTextField("" + n2, 40);
        this.htPanel = new JPanel(new BorderLayout());
        this.htPanel.add((Component)this.htLabel, "West");
        this.htPanel.add((Component)this.htTextField, "East");
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(this);
        this.getContentPane().add((Component)this.wdPanel, "North");
        this.getContentPane().add((Component)this.htPanel, "Center");
        this.getContentPane().add((Component)this.okButton, "South");
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.okButton)) {
            try {
                this.width = Integer.parseInt(this.wdTextField.getText());
                this.height = Integer.parseInt(this.htTextField.getText());
                this.setVisible(false);
                this.processor.process(this);
            }
            catch (NumberFormatException numberFormatException) {
                Util.warning(this, "Error", (Object)"Values must be numeric");
            }
        }
    }
}

