/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import net.grelf.PointFloat;
import net.grelf.Util;
import net.grelf.grip.BatchProcessor;
import net.grelf.grip.BlobMeas;
import net.grelf.grip.DefaultMeasurementHandler;
import net.grelf.grip.DrawingMode;
import net.grelf.grip.GRIP;
import net.grelf.grip.ImFrame;
import net.grelf.grip.ImPane;
import net.grelf.grip.MatchList;
import net.grelf.image.Image;
import net.grelf.image.Image8or16Base;
import net.grelf.image.ImageBase;

public class MatchPair {
    public int imNo1;
    public int blobNo1;
    public int imNo2;
    public int blobNo2;
    private static List<MatchList> listOfLists = null;
    private static BlobMeas[][] lookup = null;
    private static BatchProcessor batchProcessor;
    private static boolean someDeleted;
    private static final int SCALE = 5;

    public MatchPair(int n, int n2, int n3, int n4) {
        this.imNo1 = n;
        this.blobNo1 = n2;
        this.imNo2 = n3;
        this.blobNo2 = n4;
    }

    public static void resetStaticObjects() {
        listOfLists = null;
        lookup = null;
        batchProcessor = null;
        someDeleted = false;
    }

    public static void drawMatches(List<MatchList> list, List<MatchPair> list2, int n, int n2, BlobMeas[][] blobMeasArray, BatchProcessor batchProcessor) {
        listOfLists = list;
        lookup = blobMeasArray;
        MatchPair.batchProcessor = batchProcessor;
        ImFrame imFrame = new ImFrame(listOfLists.size() + " matches: draw rectangles to remove any. Close to proceed.", DrawingMode.DELETE_MATCHES, null, -1, (n /= 5) + 50, (n2 /= 5) + 50, new DefaultMeasurementHandler());
        imFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (someDeleted) {
                    for (int i = listOfLists.size() - 1; i >= 0; --i) {
                        if (null != listOfLists.get(i)) continue;
                        listOfLists.remove(i);
                    }
                }
                batchProcessor.astroPass2();
            }
        });
        MatchPair.draw(imFrame);
    }

    protected static void setListOfLists(List<MatchList> list) {
        listOfLists = list;
    }

    private static void draw(ImFrame imFrame) {
        ImPane imPane = imFrame.getImPane();
        int n = imPane.getIpWidth();
        int n2 = imPane.getIpHeight();
        Image image = ImageBase.createImage(n, n2, 3, 8);
        imPane.setImage(image);
        BufferedImage bufferedImage = ((Image8or16Base)image).getBufferedImage();
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setPaint(Color.white);
        graphics2D.fillRect(0, 0, n * 5, n2 * 5);
        for (int i = 0; i < listOfLists.size(); ++i) {
            MatchList matchList = listOfLists.get(i);
            if (null == matchList) continue;
            int n3 = 0;
            int n4 = 0;
            for (int j = 0; j < matchList.size(); ++j) {
                MatchPair matchPair = matchList.get(j);
                PointFloat pointFloat = MatchPair.lookup[matchPair.imNo1][matchPair.blobNo1].centre;
                PointFloat pointFloat2 = MatchPair.lookup[matchPair.imNo2][matchPair.blobNo2].centre;
                int n5 = (int)pointFloat.x / 5;
                int n6 = (int)pointFloat.y / 5;
                n3 = (int)pointFloat2.x / 5;
                n4 = (int)pointFloat2.y / 5;
                graphics2D.setPaint(Color.red);
                graphics2D.drawLine(n5, n6, n3, n4);
                graphics2D.setPaint(Color.black);
                graphics2D.drawRect(n5, n6, 1, 1);
                graphics2D.drawRect(n3, n4, 1, 1);
            }
            graphics2D.drawString("" + i, n3 + 5, n4 + 5);
        }
        imFrame.redisplay();
    }

    public static void deleteMatches(Point point, Point point2, ImFrame imFrame) {
        if (null == listOfLists) {
            Util.warning(imFrame, "Error", (Object)"The list of matches has been lost");
        } else {
            for (int i = 0; i < listOfLists.size(); ++i) {
                MatchList matchList = listOfLists.get(i);
                if (null == matchList) continue;
                boolean bl = false;
                for (int j = 0; j < matchList.size() && !bl; ++j) {
                    MatchPair matchPair = matchList.get(j);
                    PointFloat pointFloat = MatchPair.lookup[matchPair.imNo1][matchPair.blobNo1].centre;
                    PointFloat pointFloat2 = MatchPair.lookup[matchPair.imNo2][matchPair.blobNo2].centre;
                    if (!(pointFloat.x >= (float)(point.x * 5) && pointFloat.x <= (float)(point2.x * 5) && pointFloat.y >= (float)(point.y * 5) && pointFloat.y <= (float)(point2.y * 5)) && (!(pointFloat2.x >= (float)(point.x * 5)) || !(pointFloat2.x <= (float)(point2.x * 5)) || !(pointFloat2.y >= (float)(point.y * 5)) || !(pointFloat2.y <= (float)(point2.y * 5)))) continue;
                    bl = true;
                }
                if (!bl || !Util.confirm(imFrame, "Confirm", "Remove match set " + i + "?")) continue;
                listOfLists.set(i, null);
                someDeleted = true;
                MatchPair.draw(imFrame);
            }
        }
    }

    public static MatchPair findBlobInMiddleImage(int n, int n2, int n3) {
        if (n == n3) {
            return null;
        }
        if (null == listOfLists) {
            Util.warning("Error", "The list of matches has been lost");
        } else {
            for (MatchList matchList : listOfLists) {
                if (null == matchList || !matchList.containsImageAndBlob(n, n2)) continue;
                for (int i = 0; i < matchList.size(); ++i) {
                    MatchPair matchPair = matchList.get(i);
                    if (matchPair.imNo1 == n3) {
                        return new MatchPair(n3, matchPair.blobNo1, n, n2);
                    }
                    if (matchPair.imNo2 != n3) continue;
                    return new MatchPair(n3, matchPair.blobNo2, n, n2);
                }
                return null;
            }
        }
        return null;
    }

    public static void reportMatches(List<MatchPair> list, BlobMeas[][] blobMeasArray, int n, String string) {
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(string));
            printWriter.println("i1,b1,x1,y1,i2,b2,x2,y2");
            for (int i = 0; i < list.size(); ++i) {
                MatchPair matchPair = list.get(i);
                if (matchPair.blobNo1 >= n || matchPair.blobNo2 >= n) continue;
                PointFloat pointFloat = blobMeasArray[matchPair.imNo1][matchPair.blobNo1].centre;
                PointFloat pointFloat2 = blobMeasArray[matchPair.imNo2][matchPair.blobNo2].centre;
                printWriter.println(matchPair.imNo1 + "," + matchPair.blobNo1 + "," + (int)pointFloat.x + "," + (int)pointFloat.y + "," + matchPair.imNo2 + "," + matchPair.blobNo2 + "," + (int)pointFloat2.x + "," + (int)pointFloat2.y);
            }
            printWriter.close();
        }
        catch (IOException iOException) {
            Util.warning(GRIP.getInstance(), "Error", (Object)iOException.toString());
        }
    }

    static {
        someDeleted = false;
    }
}

