/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.List;
import javax.swing.JComponent;
import net.grelf.grip.MeasurementCurve;

public class MeasurementGraph
extends JComponent
implements Printable {
    private List<MeasurementCurve> curves;
    private List<String> xLabels;
    private static final Color[] colours = new Color[]{Color.blue, Color.green, Color.red, Color.cyan, Color.yellow, Color.magenta, Color.black, Color.white};
    private static final int MAX_COLOURS = colours.length;
    private static final Color BACKGROUND = new Color(212, 208, 200);

    public MeasurementGraph(List<MeasurementCurve> list, List<String> list2) {
        this.setSize(500, 500);
        this.setPreferredSize(new Dimension(500, 500));
        this.curves = list;
        this.xLabels = list2;
    }

    protected void draw(Graphics2D graphics2D, int n, int n2) {
        int n3 = n + 60;
        int n4 = n2 + 256;
        int n5 = this.curves.get(0).size();
        int n6 = 340 / n5;
        int n7 = this.curves.size();
        graphics2D.setPaint(BACKGROUND);
        graphics2D.fillRect(n, n2, this.getWidth(), this.getHeight());
        graphics2D.setPaint(Color.black);
        graphics2D.drawLine(n3, n4, n3 + 340, n4);
        graphics2D.drawLine(n3, n4, n3, n4 - 240);
        int n8 = 0;
        int n9 = n3;
        while (n8 < n5) {
            graphics2D.drawLine(n9, n4 - 240, n9, n4 + 5);
            graphics2D.drawString(this.xLabels.get(n8), n9, n4 + 18 * (n8 + 1));
            ++n8;
            n9 += n6;
        }
        for (n8 = 0; n8 < n7; ++n8) {
            graphics2D.setPaint(colours[n8 % MAX_COLOURS]);
            MeasurementCurve measurementCurve = this.curves.get(n8);
            if (measurementCurve.size() <= 0) continue;
            double d = measurementCurve.get(0);
            double d2 = Double.MAX_VALUE;
            for (int i = 0; i < measurementCurve.size(); ++i) {
                double d3 = measurementCurve.get(i);
                if (d3 > d) {
                    d = d3;
                    continue;
                }
                if (!(d3 < d2)) continue;
                d2 = d3;
            }
            graphics2D.drawString("" + d, n3 - 50, n4 - 240 + n8 * 18);
            graphics2D.drawString("" + d2, n3 - 50, n4 + n8 * 18);
            double d4 = 240.0 / (d - d2);
            int n10 = n4 - (int)((measurementCurve.get(0) - d2) * d4);
            int n11 = 1;
            int n12 = n3;
            while (n11 < n5) {
                int n13 = n4 - (int)((measurementCurve.get(n11) - d2) * d4);
                graphics2D.drawLine(n12, n10, n12 + n6, n13);
                n10 = n13;
                ++n11;
                n12 += n6;
            }
            n11 = n4 + n8 * 18 + 120;
            graphics2D.drawLine(n3, n11, n3 + 30, n11);
            graphics2D.setPaint(Color.black);
            graphics2D.drawString(measurementCurve.getLabel(), n3 + 40, n11);
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        this.draw((Graphics2D)graphics, 0, 0);
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (n > 0) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        this.draw(graphics2D, 0, 0);
        return 0;
    }
}

