/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import javax.swing.JComponent;
import net.grelf.FileIO;
import net.grelf.FileIO_CSVFilter;
import net.grelf.FileIO_XMLFilter;
import net.grelf.Statistics;
import net.grelf.Util;
import net.grelf.grip.ImFrame;
import net.grelf.grip.PointList;
import net.grelf.image.Calibration;

public class Profile1D
extends JComponent
implements Printable {
    private int[][] prof;
    private float[] profX;
    private float[] profY;
    private int nLevels;
    private int nBands;
    private int width;
    private int height;
    private Calibration calibration;
    private int[][] freq = null;
    private static final DecimalFormat FORMAT = new DecimalFormat("0.00");

    public Profile1D(ImFrame imFrame, PointList pointList) {
        Object object;
        Object object2;
        int n;
        int n2 = 0;
        for (n = 1; n < pointList.size(); ++n) {
            object2 = pointList.get(n - 1);
            object = pointList.get(n);
            double d = ((Point)object2).getX();
            double d2 = ((Point)object2).getY();
            double d3 = ((Point)object).getX() - d;
            double d4 = ((Point)object).getY() - d2;
            int n3 = (int)Math.round(Math.sqrt(d3 * d3 + d4 * d4));
            d3 /= (double)n3;
            d4 /= (double)n3;
            int n4 = 0;
            while (n4 < n3) {
                d += d3;
                d2 += d4;
                ++n4;
                ++n2;
            }
        }
        n = n2;
        object2 = imFrame.getImPane().getImage();
        this.calibration = object2.getCalibration();
        this.nLevels = object2.getRange().high + 1;
        this.nBands = object2.getNBands();
        this.freq = new int[this.nBands][this.nLevels];
        this.prof = new int[this.nBands][n];
        this.profX = new float[n];
        this.profY = new float[n];
        object = new int[this.nBands];
        n2 = 0;
        for (int i = 1; i < pointList.size(); ++i) {
            Point point = pointList.get(i - 1);
            Point point2 = pointList.get(i);
            double d = point.getX();
            double d5 = point.getY();
            double d6 = point2.getX() - d;
            double d7 = point2.getY() - d5;
            int n5 = (int)Math.round(Math.sqrt(d6 * d6 + d7 * d7));
            d6 /= (double)n5;
            d7 /= (double)n5;
            for (int j = 0; n2 < n && j < n5; ++j, ++n2) {
                object = object2.getPixelInterpolated(d, d5);
                for (int k = 0; k < this.nBands; ++k) {
                    this.prof[k][n2] = (int)object[k];
                    int[] nArray = this.freq[k];
                    Object object3 = object[k];
                    nArray[object3] = nArray[object3] + 1;
                }
                this.profX[n2] = (float)Math.floor(d * 100.0) / 100.0f;
                this.profY[n2] = (float)Math.floor(d5 * 100.0) / 100.0f;
                d += d6;
                d5 += d7;
            }
        }
        this.width = this.prof[0].length + 40;
        this.height = 360;
        this.setSize(this.width, this.height);
        this.setPreferredSize(new Dimension(this.width, this.height));
    }

    public Statistics[] getStatistics(int n, int n2) {
        Statistics[] statisticsArray = new Statistics[this.nBands];
        for (int i = 0; i < this.nBands; ++i) {
            statisticsArray[i] = new Statistics(this.freq[i], n, n2);
        }
        return statisticsArray;
    }

    public void draw(Graphics2D graphics2D, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6 = n + 10;
        int n7 = n2 + 330;
        int n8 = this.prof[0].length;
        float[] fArray = new float[n8];
        int[] nArray = new int[n8];
        float f = 255.0f / (float)this.nLevels;
        float f2 = 0.57735056f;
        for (n5 = 0; n5 < n8; ++n5) {
            fArray[n5] = 0.0f;
            for (n4 = 0; n4 < this.nBands; ++n4) {
                float f3 = this.prof[n4][n5];
                int n9 = n5;
                fArray[n9] = fArray[n9] + f3 * f3;
            }
            nArray[n5] = (int)Math.round(Math.sqrt(fArray[n5]));
        }
        graphics2D.setPaint(new Color(212, 208, 200));
        graphics2D.fillRect(n, n2, this.getWidth(), this.getHeight());
        graphics2D.setPaint(Color.LIGHT_GRAY);
        for (n5 = 0; n5 < 256; n5 += 10) {
            graphics2D.drawLine(n6 - 5, n7 - n5, n6 + n8, n7 - n5);
        }
        if (!this.calibration.isCalibrated()) {
            n5 = 0;
            int n10 = n6;
            while (n5 < n8) {
                graphics2D.drawLine(n10, n7 - 256, n10, n7 + 5);
                n5 += 10;
                n10 += 10;
            }
        }
        graphics2D.setPaint(Color.BLACK);
        for (n5 = 0; n5 < 256; n5 += 50) {
            graphics2D.drawLine(n6 - 5, n7 - n5, n6 + n8, n7 - n5);
        }
        String string = null;
        if (this.calibration.isCalibrated()) {
            double d = this.calibration.getScale();
            graphics2D.setPaint(Color.BLACK);
            n3 = 0;
            int n11 = n6;
            while (n3 < n8) {
                graphics2D.drawLine(n11, n7 - 256, n11, n7 + 5);
                graphics2D.drawString(FORMAT.format((double)n3 * d), n11, n7 + 20);
                n3 += 50;
                n11 += 50;
            }
            string = this.calibration.getUnits().getToUnits().getSymbol();
        } else {
            graphics2D.setPaint(Color.BLACK);
            int n12 = 0;
            n4 = n6;
            n3 = 0;
            while (n12 < n8) {
                graphics2D.drawLine(n4, n7 - 256, n4, n7 + 5);
                graphics2D.drawString("" + n3, n4, n7 + 20);
                n12 += 50;
                n4 += 50;
                n3 += 50;
            }
            string = "pixels";
        }
        graphics2D.setPaint(Color.BLACK);
        graphics2D.drawString(string, n6 + n8 + 50, n7 + 20);
        int n13 = 1;
        n4 = n6;
        while (n13 < n8) {
            graphics2D.setPaint(Color.BLACK);
            graphics2D.drawLine(n4 - 1, n7 - (int)((float)nArray[n13 - 1] * f * f2), n4, n7 - (int)((float)nArray[n13] * f * f2));
            if (this.nBands > 1) {
                graphics2D.setPaint(Color.RED);
                graphics2D.drawLine(n4 - 1, n7 - (int)((float)this.prof[0][n13 - 1] * f), n4, n7 - (int)((float)this.prof[0][n13] * f));
            }
            if (this.nBands > 2) {
                graphics2D.setPaint(Color.BLUE);
                graphics2D.drawLine(n4 - 1, n7 - (int)((float)this.prof[2][n13 - 1] * f), n4, n7 - (int)((float)this.prof[2][n13] * f));
            }
            if (this.nBands > 1) {
                graphics2D.setPaint(Color.GREEN);
                graphics2D.drawLine(n4 - 1, n7 - (int)((float)this.prof[1][n13 - 1] * f), n4, n7 - (int)((float)this.prof[1][n13] * f));
            }
            if (this.nBands == 3) {
                graphics2D.setPaint(new Color((int)((float)this.prof[0][n13] * f), (int)((float)this.prof[1][n13] * f), (int)((float)this.prof[2][n13] * f)));
            } else {
                n3 = (int)((float)this.prof[0][n13] * f);
                graphics2D.setPaint(new Color(n3, n3, n3));
            }
            graphics2D.drawLine(n4, n7 - 305, n4, n7 - 330);
            ++n13;
            ++n4;
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        this.draw((Graphics2D)graphics, 0, 0);
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (n > 0) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        this.draw(graphics2D, 0, 0);
        return 0;
    }

    public void saveCSV() {
        String string = FileIO.selectOutputFile("Create CSV file", null, new FileIO_CSVFilter[]{new FileIO_CSVFilter(1)}, "x.csv");
        if (string != null) {
            try {
                PrintWriter printWriter = new PrintWriter(new FileWriter(string));
                if (this.nBands == 3) {
                    printWriter.println("pixel,x,y,R,G,B,");
                    for (int i = 0; i < this.prof[0].length; ++i) {
                        printWriter.println(i + "," + this.profX[i] + "," + this.profY[i] + "," + this.prof[0][i] + "," + this.prof[1][i] + "," + this.prof[2][i] + ",");
                    }
                } else {
                    printWriter.println("pixel,x,y,level,");
                    for (int i = 0; i < this.prof[0].length; ++i) {
                        printWriter.println(i + "," + this.profX[i] + "," + this.profY[i] + "," + this.prof[0][i] + ",");
                    }
                }
                printWriter.close();
            }
            catch (IOException iOException) {
                Util.warning(this, "Error", (Object)iOException.toString());
            }
        }
    }

    public void saveXML() {
        String string = FileIO.selectOutputFile("Create XML file", null, new FileIO_XMLFilter[]{new FileIO_XMLFilter(1)}, "x.xml");
        if (string != null) {
            try {
                PrintWriter printWriter = new PrintWriter(new FileWriter(string));
                printWriter.println("<?xml version=\"1.0\"?>");
                printWriter.println("<Profile>");
                if (this.nBands == 3) {
                    for (int i = 0; i < this.prof[0].length; ++i) {
                        printWriter.println("\t<Entry><I>" + i + "</I><X>" + this.profX[i] + "</X><Y>" + this.profY[i] + "</Y><R>" + this.prof[0][i] + "</R><G>" + this.prof[1][i] + "</G><B>" + this.prof[2][i] + "</B></Entry>");
                    }
                } else {
                    for (int i = 0; i < this.prof[0].length; ++i) {
                        printWriter.println("\t<Entry><I>" + i + "</I><X>" + this.profX[i] + "</X><Y>" + this.profY[i] + "</Y><Level>" + this.prof[0][i] + "</Level></Entry>");
                    }
                }
                printWriter.println("</Profile>");
                printWriter.close();
            }
            catch (IOException iOException) {
                Util.warning(this, "Error", (Object)iOException.toString());
            }
        }
    }
}

