/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JWindow;
import net.grelf.Interpolator;
import net.grelf.Util;
import net.grelf.grip.GRIP;
import net.grelf.image.Image;
import net.grelf.image.Image8or16Base;
import net.grelf.image.ImageLoader;

public class SlideShow
extends JComponent
implements Runnable,
KeyListener {
    private File[] files;
    private int interval_ms;
    private JWindow win;
    private Dimension screen;
    private BufferedImage bim = null;
    private boolean stopped = false;
    private boolean paused = false;
    private boolean forward = true;
    private boolean stepping = false;
    private Rectangle background = null;
    private int dx = 0;
    private int dy = 0;

    private SlideShow() {
    }

    public SlideShow(File[] fileArray, int n) {
        this.files = fileArray;
        this.interval_ms = n;
        this.win = new JWindow(GRIP.getInstance());
        this.screen = this.win.getToolkit().getScreenSize();
        this.setPreferredSize(this.screen);
        GRIP.getInstance().addKeyListener(this);
        this.win.add(this);
        this.win.setLocation(0, 0);
        this.win.setSize(this.screen);
        this.win.setVisible(true);
        this.background = new Rectangle(this.screen);
        new Thread(this).start();
    }

    @Override
    public void run() {
        Util.message("Slide show", "These keys will be active during the slide show:\nLeft arrow reverses, to step backwards.\nRight arrow goes forward.\nUp arrow speeds up by 2 (halving the interval).\nDown arrow slows down by 2.\nThe space bar pauses and resumes the show.\nWhile paused, left/right arrow keys step to next or previous slide.\nAny other key ends the show and clears the window.");
        int n = 0;
        try {
            while (!this.stopped) {
                if (this.stepping || !this.paused) {
                    Image image;
                    if (this.forward) {
                        if (++n >= this.files.length) {
                            n = 0;
                        }
                    } else if (--n < 0) {
                        n = this.files.length - 1;
                    }
                    if (!((image = ImageLoader.load(this.files[n])) instanceof Image8or16Base)) {
                        Util.warning("Sorry", "Cannot show image having more that 16 bits per channel");
                    } else {
                        this.bim = this.convertForDisplay(((Image8or16Base)image).getBufferedImage());
                        this.repaint();
                    }
                    this.stepping = false;
                }
                Thread.sleep(this.interval_ms);
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception exception) {
            Util.warning("Error", "Could not load/display {0}. See log file.", this.files[n].getPath());
        }
        this.win.setVisible(false);
        this.win.dispose();
    }

    private BufferedImage convertForDisplay(BufferedImage bufferedImage) {
        float f;
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        int n3 = Image8or16Base.getNBands(bufferedImage);
        float f2 = (float)this.screen.height / (float)n2;
        float f3 = (float)this.screen.width / (float)n;
        if (f2 < f3) {
            f = f2;
            this.dx = (int)((double)((float)this.screen.width - (float)n * f) * 0.5);
            this.dy = 0;
        } else {
            f = f3;
            this.dy = (int)((double)((float)this.screen.height - (float)n2 * f) * 0.5);
            this.dx = 0;
        }
        int n4 = (int)((float)n * f);
        int n5 = (int)((float)n2 * f);
        BufferedImage bufferedImage2 = Image8or16Base.getGraphicsConfiguration().createCompatibleImage(n4, n5);
        int n6 = Image8or16Base.getNBands(bufferedImage2);
        WritableRaster writableRaster = bufferedImage.getRaster();
        WritableRaster writableRaster2 = bufferedImage2.getRaster();
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n6];
        int n7 = Image8or16Base.getBitsPerChannel(bufferedImage);
        int n8 = Image8or16Base.getBitsPerChannel(bufferedImage2);
        float f4 = 1.0f / f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        if (n7 == n8) {
            for (int i = 0; i < n5; ++i) {
                f5 = 0.0f;
                for (int j = 0; j < n4; ++j) {
                    nArray = Interpolator.getPixel(writableRaster, f5, f6);
                    if (n3 < n6) {
                        int n9;
                        for (n9 = 0; n9 < n3; ++n9) {
                            nArray2[n9] = nArray[n9];
                        }
                        for (n9 = n3; n9 < n6; ++n9) {
                            nArray2[n9] = nArray[0];
                        }
                        writableRaster2.setPixel(j, i, nArray2);
                    } else {
                        writableRaster2.setPixel(j, i, nArray);
                    }
                    f5 += f4;
                }
                f6 += f4;
            }
        } else if (n7 > n8) {
            int n10 = n7 - n8;
            for (int i = 0; i < n5; ++i) {
                f5 = 0.0f;
                for (int j = 0; j < n4; ++j) {
                    int n11;
                    nArray = Interpolator.getPixel(writableRaster, f5, f6);
                    for (n11 = 0; n11 < n3; ++n11) {
                        nArray[n11] = nArray[n11] >> n10;
                    }
                    if (n3 < n6) {
                        for (n11 = 0; n11 < n3; ++n11) {
                            nArray2[n11] = nArray[n11];
                        }
                        for (n11 = n3; n11 < n6; ++n11) {
                            nArray2[n11] = nArray[0];
                        }
                        writableRaster2.setPixel(j, i, nArray2);
                    } else {
                        writableRaster2.setPixel(j, i, nArray);
                    }
                    f5 += f4;
                }
                f6 += f4;
            }
        } else {
            int n12 = n8 - n7;
            for (int i = 0; i < n5; ++i) {
                f5 = 0.0f;
                for (int j = 0; j < n4; ++j) {
                    int n13;
                    nArray = Interpolator.getPixel(writableRaster, f5, f6);
                    for (n13 = 0; n13 < n3; ++n13) {
                        nArray[n13] = nArray[n13] << n12;
                    }
                    if (n3 < n6) {
                        for (n13 = 0; n13 < n3; ++n13) {
                            nArray2[n13] = nArray[n13];
                        }
                        for (n13 = n3; n13 < n6; ++n13) {
                            nArray2[n13] = nArray[0];
                        }
                        writableRaster2.setPixel(j, i, nArray2);
                    } else {
                        writableRaster2.setPixel(j, i, nArray);
                    }
                    f5 += f4;
                }
                f6 += f4;
            }
        }
        return bufferedImage2;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setPaint(Color.black);
        graphics2D.fill(this.background);
        if (null != this.bim) {
            graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
            graphics2D.drawImage(this.bim, this.dx, this.dy, this.bim.getWidth(), this.bim.getHeight(), this);
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 39: {
                this.forward = true;
                this.stepping = true;
                break;
            }
            case 38: {
                this.interval_ms = Math.max(1, this.interval_ms / 2);
                break;
            }
            case 40: {
                this.interval_ms = Math.min(60000, this.interval_ms * 2);
                break;
            }
            case 37: {
                this.forward = false;
                this.stepping = true;
                break;
            }
            case 32: {
                this.paused = !this.paused;
                break;
            }
            default: {
                this.stopped = true;
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }
}

