/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.image;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import net.grelf.Util;
import net.grelf.image.ExifFile;
import net.grelf.image.ExifTag;

public class Exif {
    private static ExifFile f;
    private static PrintWriter p;
    private static StringBuffer tabs;
    private static JFileChooser jfc;
    private static final Map<String, ExifTag> hash;
    private static String[] formatNames;
    private static final short TIFF_BYTE = 1;
    private static final short TIFF_ASCII = 2;
    private static final short TIFF_SHORT = 3;
    private static final short TIFF_LONG = 4;
    private static final short TIFF_RATIONAL = 5;

    public static void main(String[] stringArray) throws Exception {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        jfc = new JFileChooser();
        jfc.setCurrentDirectory(new File(System.getProperty("user.dir")));
        jfc.setFileSelectionMode(0);
        jfc.setApproveButtonText("Open image file");
        if (0 == jfc.showOpenDialog(null)) {
            String string = jfc.getSelectedFile().getPath();
            PrintWriter printWriter = new PrintWriter(new FileWriter(string + "_exif.xml"));
            Exif.processFile(string, printWriter);
            printWriter.close();
        }
        System.out.println("Done");
        System.exit(0);
    }

    public static void putMetadataInMap(String string, Map<String, String> map) {
        try {
            f = new ExifFile(string, "r");
            if (null != f) {
                if (65496 == f.tiffReadUnsigned2()) {
                    while (255 == f.readUnsignedByte()) {
                        int n = f.readUnsignedByte();
                        if (225 == n) {
                            f.tiffReadUnsigned2();
                            if (17784 != f.tiffReadUnsigned2() || 26982 != f.tiffReadUnsigned2() || 0 != f.tiffReadUnsigned2()) continue;
                            Exif.doTiff(f.getFilePointer(), map);
                            continue;
                        }
                        int n2 = f.tiffReadUnsigned2();
                        f.seek(f.getFilePointer() + (long)n2 - 2L);
                    }
                } else {
                    f.seek(0L);
                    Exif.doTiff(0L, map);
                }
                f.close();
            }
        }
        catch (IOException iOException) {
            Util.logWarning(iOException.toString());
        }
        catch (NullPointerException nullPointerException) {
            Util.logWarning("NullPointerException in Exif.putMetadataInMap");
        }
    }

    private static void doTiff(long l, Map<String, String> map) throws IOException {
        f.setIntelByteOrder(18761 == f.tiffReadUnsigned2());
        int n = f.tiffReadUnsigned2();
        if (10752 == n) {
            long l2 = f.tiffReadUnsigned4();
            while (0L != l2) {
                f.seek(l + l2);
                l2 = Exif.doIFD(l, map);
            }
        }
    }

    private static long doIFD(long l, Map<String, String> map) throws IOException {
        int n = f.tiffReadUnsigned2();
        for (int i = 0; i < n; ++i) {
            Exif.doIfdItem(l, map);
        }
        return f.tiffReadUnsigned4();
    }

    private static void doIfdItem(long l, Map<String, String> map) throws IOException {
        int n = f.tiffReadUnsigned2();
        int n2 = f.tiffReadUnsigned2();
        long l2 = f.tiffReadUnsigned4();
        long l3 = f.tiffReadUnsigned4();
        ExifTag exifTag = hash.get(Integer.toString(n));
        if (null == exifTag) {
            String string = Integer.toHexString(n);
            String string2 = Exif.getIfdItemData(new ExifTag(0, "", n2, l2), n2, l2, l3, l);
            if (null != string2 && string2.length() > 0) {
                map.put(string, string2);
            }
        } else {
            ExifTag exifTag2 = exifTag;
            if (exifTag2.tagName.equals("Exif")) {
                long l4 = f.getFilePointer();
                long l5 = l3;
                Exif.getIfdItemData(exifTag2, n2, l2, l3, l);
                f.seek(l + l5);
                f.seek(l4);
            } else if (exifTag2.tagName.equals("ExifOffset")) {
                long l6 = f.getFilePointer();
                long l7 = l3;
                while (0L != l7) {
                    f.seek(l + l7);
                    l7 = Exif.doIFD(l, map);
                }
                f.seek(l6);
            } else if (exifTag2.tagName.equals("ExifInteroperabilityOffset")) {
                long l8 = f.getFilePointer();
                long l9 = l3;
                while (0L != l9) {
                    f.seek(l + l9);
                    l9 = Exif.doIFD(l, map);
                }
                f.seek(l8);
            } else if (exifTag2.tagName.equals("MakerNote")) {
                long l10 = f.getFilePointer();
                long l11 = l3;
                while (0L != l11) {
                    f.seek(l + l11);
                    l11 = Exif.doIFD(l, map);
                }
                f.seek(l10);
            } else {
                String string = Exif.getIfdItemData(exifTag2, n2, l2, l3, l);
                if (null != string && string.length() > 0) {
                    map.put(exifTag2.tagName, string);
                }
            }
        }
    }

    private static String getIfdItemData(ExifTag exifTag, int n, long l, long l2, long l3) throws IOException {
        StringBuffer stringBuffer;
        block59: {
            block58: {
                stringBuffer = new StringBuffer();
                if (n >= ExifTag.bytesPerComponent.length || (long)ExifTag.bytesPerComponent[n] * l > 4L) break block58;
                switch (n) {
                    case 1: {
                        int n2 = 0;
                        while ((long)n2 < l) {
                            stringBuffer.append(l2 & 0xFFL);
                            l2 >>= 8;
                            if ((long)n2 != l - 1L) {
                                stringBuffer.append(",");
                            }
                            ++n2;
                        }
                        break block59;
                    }
                    case 3: {
                        int n3 = 0;
                        while ((long)n3 < l) {
                            stringBuffer.append(l2 & 0xFFFFL);
                            l2 >>= 16;
                            if ((long)n3 != l - 1L) {
                                stringBuffer.append(",");
                            }
                            ++n3;
                        }
                        break block59;
                    }
                    case 4: {
                        stringBuffer.append(l2);
                        break;
                    }
                    case 6: {
                        int n4 = 0;
                        while ((long)n4 < l) {
                            stringBuffer.append((byte)(l2 & 0xFFL));
                            l2 >>= 8;
                            if ((long)n4 != l - 1L) {
                                stringBuffer.append(",");
                            }
                            ++n4;
                        }
                        break block59;
                    }
                    case 8: {
                        int n5 = 0;
                        while ((long)n5 < l) {
                            stringBuffer.append((short)(l2 & 0xFFFFL));
                            l2 >>= 16;
                            if ((long)n5 != l - 1L) {
                                stringBuffer.append(",");
                            }
                            ++n5;
                        }
                        break block59;
                    }
                    case 9: {
                        stringBuffer.append((int)l2);
                        break;
                    }
                    case 5: 
                    case 10: 
                    case 11: 
                    case 12: {
                        stringBuffer.append("Unexpected data format");
                        break;
                    }
                    case 2: {
                        int n6 = 0;
                        while ((long)n6 < l) {
                            int n7 = (int)l2 & 0xFF;
                            l2 >>= 8;
                            if (n7 > 0) {
                                stringBuffer.append((char)n7);
                            }
                            ++n6;
                        }
                        break block59;
                    }
                    case 7: {
                        long l4 = l2;
                        stringBuffer.append("<Characters>");
                        int n8 = 0;
                        while ((long)n8 < l) {
                            int n9 = (int)l2 & 0xFF;
                            l2 >>= 8;
                            if (n9 > 0) {
                                stringBuffer.append((char)n9);
                            }
                            ++n8;
                        }
                        stringBuffer.append("</Characters><Bytes>");
                        n8 = 0;
                        while ((long)n8 < l) {
                            stringBuffer.append((byte)(l4 & 0xFFL));
                            l4 >>= 8;
                            if ((long)n8 != l - 1L) {
                                stringBuffer.append(",");
                            }
                            ++n8;
                        }
                        stringBuffer.append("</Bytes>");
                        break;
                    }
                    default: {
                        stringBuffer.append("Invalid format specifier in tag");
                    }
                }
                break block59;
            }
            long l5 = f.getFilePointer();
            f.seek(l3 + l2);
            switch (n) {
                case 1: {
                    if (exifTag.tagName.equals("XMP") || exifTag.tagName.equals("PhotoshopImageResourceBlocks")) {
                        StringBuffer stringBuffer2 = new StringBuffer();
                        stringBuffer.append("\n<Characters>");
                        int n10 = 0;
                        while ((long)n10 < l) {
                            int n11 = f.readUnsignedByte();
                            if (n11 > 0) {
                                stringBuffer.append((char)n11);
                            }
                            stringBuffer2.append(n11);
                            stringBuffer2.append(" ");
                            ++n10;
                        }
                        stringBuffer.append("</Characters>\n<Bytes>");
                        stringBuffer.append(stringBuffer2);
                        stringBuffer.append("</Bytes>");
                        break;
                    }
                    int n12 = 0;
                    while ((long)n12 < l) {
                        stringBuffer.append(f.readUnsignedByte());
                        if ((long)n12 != l - 1L) {
                            stringBuffer.append(",");
                        }
                        ++n12;
                    }
                    break;
                }
                case 3: {
                    int n13 = 0;
                    while ((long)n13 < l) {
                        stringBuffer.append(f.tiffReadUnsigned2());
                        if ((long)n13 != l - 1L) {
                            stringBuffer.append(",");
                        }
                        ++n13;
                    }
                    break;
                }
                case 4: {
                    int n14 = 0;
                    while ((long)n14 < l) {
                        stringBuffer.append(f.tiffReadUnsigned4());
                        if ((long)n14 != l - 1L) {
                            stringBuffer.append(",");
                        }
                        ++n14;
                    }
                    break;
                }
                case 6: {
                    int n15 = 0;
                    while ((long)n15 < l) {
                        stringBuffer.append(f.readByte());
                        if ((long)n15 != l - 1L) {
                            stringBuffer.append(",");
                        }
                        ++n15;
                    }
                    break;
                }
                case 8: {
                    int n16 = 0;
                    while ((long)n16 < l) {
                        stringBuffer.append(f.tiffRead2());
                        if ((long)n16 != l - 1L) {
                            stringBuffer.append(",");
                        }
                        ++n16;
                    }
                    break;
                }
                case 9: {
                    int n17 = 0;
                    while ((long)n17 < l) {
                        stringBuffer.append(f.tiffRead4());
                        if ((long)n17 != l - 1L) {
                            stringBuffer.append(",");
                        }
                        ++n17;
                    }
                    break;
                }
                case 5: {
                    long l6 = f.tiffReadUnsigned4();
                    long l7 = f.tiffReadUnsigned4();
                    stringBuffer.append(l6);
                    stringBuffer.append("/");
                    stringBuffer.append(l7);
                    break;
                }
                case 10: {
                    long l8 = f.tiffRead4();
                    long l9 = f.tiffRead4();
                    stringBuffer.append(l8);
                    stringBuffer.append("/");
                    stringBuffer.append(l9);
                    break;
                }
                case 11: 
                case 12: {
                    stringBuffer.append("unexpected data format");
                    break;
                }
                case 2: {
                    int n18 = 0;
                    while ((long)n18 < l) {
                        int n19 = f.readUnsignedByte();
                        if (n19 > 0) {
                            stringBuffer.append((char)n19);
                        }
                        ++n18;
                    }
                    break;
                }
                case 7: {
                    StringBuffer stringBuffer3 = new StringBuffer();
                    stringBuffer.append("\n<Characters>");
                    int n20 = 0;
                    while ((long)n20 < l) {
                        int n21 = f.readUnsignedByte();
                        if (n21 > 0) {
                            stringBuffer.append((char)n21);
                        }
                        stringBuffer3.append(n21);
                        stringBuffer3.append(" ");
                        ++n20;
                    }
                    stringBuffer.append("</Characters>\n<Bytes>");
                    stringBuffer.append(stringBuffer3);
                    stringBuffer.append("</Bytes>");
                    break;
                }
                default: {
                    p.print("Invalid format specifier in tag");
                }
            }
            if (exifTag.tagName.equals("FocalLength")) {
                stringBuffer.append("mm");
            }
            f.seek(l5);
        }
        return stringBuffer.toString();
    }

    public static void processFile(String string, PrintWriter printWriter) {
        p = printWriter;
        tabs = new StringBuffer("\t\t");
        try {
            f = new ExifFile(string, "r");
            if (65496 == f.readUnsignedShort()) {
                System.out.println("File is JPEG");
                p.println(tabs + "<jpeg>");
                Exif.incTabs();
                while (255 == f.readUnsignedByte()) {
                    int n = f.readUnsignedByte();
                    if (225 == n) {
                        Exif.processExif();
                        continue;
                    }
                    int n2 = f.readUnsignedShort();
                    f.seek(f.getFilePointer() + (long)n2 - 2L);
                    p.println(tabs + "<" + Integer.toHexString(65280 + n) + " size=" + n2 + "/>");
                }
                Exif.decTabs();
                p.println(tabs + "</jpeg>");
            } else {
                f.seek(0L);
                Exif.processTiff(0L);
            }
            f.close();
        }
        catch (IOException iOException) {
            Util.logWarning(iOException.toString());
        }
    }

    private static void processExif() throws IOException {
        int n = f.readUnsignedShort();
        if (17784 == f.readUnsignedShort() && 26982 == f.readUnsignedShort() && 0 == f.readUnsignedShort()) {
            p.println(tabs + "<exif size=" + n + ">");
            Exif.incTabs();
            Exif.processTiff(f.getFilePointer());
            Exif.decTabs();
            p.println(tabs + "</exif>");
        }
    }

    private static void processTiff(long l) throws IOException {
        f.setIntelByteOrder(18761 == f.tiffReadUnsigned2());
        int n = f.tiffReadUnsigned2();
        if (42 == n) {
            p.println(tabs + "<tiff order=" + (f.isIntelByteOrder() ? "intel" : "motorola") + ">");
            Exif.incTabs();
            long l2 = f.tiffReadUnsigned4();
            while (0L != l2) {
                f.seek(l + l2);
                l2 = Exif.processIFD(l);
            }
            Exif.decTabs();
            p.println(tabs + "</tiff>");
        } else {
            p.println("<TiffHeader>0x" + Integer.toHexString(n) + "</TiffHeader>");
        }
    }

    private static long processIFD(long l) throws IOException {
        int n = f.tiffReadUnsigned2();
        p.println(tabs + "<ifd items=\"" + n + "\">");
        Exif.incTabs();
        for (int i = 0; i < n; ++i) {
            Exif.processIfdItem(l);
        }
        Exif.decTabs();
        p.println(tabs + "</ifd>");
        return f.tiffReadUnsigned4();
    }

    private static String getFormatName(int n) {
        if (1 <= n && n <= 12) {
            return formatNames[n];
        }
        return Integer.toString(n);
    }

    private static void processIfdItem(long l) throws IOException {
        ExifTag exifTag;
        int n = f.tiffReadUnsigned2();
        int n2 = f.tiffReadUnsigned2();
        long l2 = f.tiffReadUnsigned4();
        long l3 = f.tiffReadUnsigned4();
        if (n2 == 3 && l2 == 1L) {
            l3 >>= 16;
        }
        if (null == (exifTag = hash.get(Integer.toString(n)))) {
            p.print(tabs + "<item tag=\"" + Integer.toHexString(n) + "\" format=\"" + Exif.getFormatName(n2) + "\" components=\"" + l2 + "\" data=\"" + l3 + "\">");
            p.print(Exif.getIfdItemData(new ExifTag(0, "", n2, l2), n2, l2, l3, l));
            p.println("</item>");
        } else {
            ExifTag exifTag2 = exifTag;
            p.print(tabs + "<" + exifTag2.tagName + " format=\"" + Exif.getFormatName(n2) + "\" components=\"" + l2 + "\" data=\"" + l3 + "\">");
            if (exifTag2.tagName.equals("Exif")) {
                p.println(tabs + "<exif size=" + l2 + ">");
                Exif.incTabs();
                long l4 = f.getFilePointer();
                long l5 = l3;
                p.print(Exif.getIfdItemData(exifTag2, n2, l2, l3, l));
                f.seek(l + l5);
                f.seek(l4);
                Exif.decTabs();
                p.println(tabs + "</exif>");
            } else if (exifTag2.tagName.equals("ExifOffset")) {
                p.println();
                Exif.incTabs();
                long l6 = f.getFilePointer();
                long l7 = l3;
                while (0L != l7) {
                    f.seek(l + l7);
                    l7 = Exif.processIFD(l);
                }
                f.seek(l6);
                Exif.decTabs();
                p.print(tabs);
            } else if (exifTag2.tagName.equals("MakerNote")) {
                p.println();
                Exif.incTabs();
                long l8 = f.getFilePointer();
                long l9 = l3;
                while (0L != l9) {
                    f.seek(l + l9);
                    l9 = Exif.processIFD(l);
                }
                f.seek(l8);
                Exif.decTabs();
                p.print(tabs);
            } else {
                p.print(Exif.getIfdItemData(exifTag2, n2, l2, l3, l));
            }
            p.println("</" + exifTag2.tagName + ">");
        }
    }

    private static void incTabs() {
        tabs.append('\t');
    }

    private static void decTabs() {
        tabs.delete(0, 1);
    }

    static {
        tabs = new StringBuffer("");
        hash = new HashMap<String, ExifTag>();
        for (int i = 0; i < ExifTag.exifTags.length; ++i) {
            hash.put(Integer.toString(ExifTag.exifTags[i].tagNo), ExifTag.exifTags[i]);
        }
        formatNames = new String[]{"0", "TIFF_U_BYTE", "TIFF_STRING", "TIFF_U_SHORT", "TIFF_U_LONG", "TIFF_U_RATIONAL", "TIFF_BYTE", "TIFF_UNDEFINED", "TIFF_SHORT", "TIFF_LONG", "TIFF_RATIONAL", "TIFF_FLOAT", "TIFF_DOUBLE"};
    }
}

