/*
 * Decompiled with CFR 0.152.
 */
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.RenderedImage;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Vector;
import javax.imageio.ImageIO;

public class FilterImage {
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$awt$Image;

    public FilterImage(String[] args) {
        int i;
        String filterName = null;
        Vector<String> images = new Vector<String>();
        for (i = 0; i < args.length; ++i) {
            String arg = args[i];
            try {
                if (arg.startsWith("-")) {
                    if (!arg.equals("-filter")) continue;
                    filterName = args[++i];
                    continue;
                }
                if (arg.startsWith("+")) continue;
                images.add(arg);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.usage("Missing argument after " + arg);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (filterName == null) {
            this.usage("No filter specified");
        }
        BufferedImageOp filter = null;
        try {
            try {
                filter = (BufferedImageOp)Class.forName(filterName).newInstance();
            }
            catch (Exception e) {
                filterName = "com.jhlabs.image." + filterName + "Filter";
                filter = (BufferedImageOp)Class.forName(filterName).newInstance();
            }
            BeanInfo info = null;
            if (filter != null) {
                try {
                    info = Introspector.getBeanInfo(filter.getClass());
                }
                catch (IntrospectionException ex) {
                    ex.printStackTrace();
                    this.usage("Filter '" + filterName + " cannot be used (not a JavaBean)");
                }
            }
            for (i = 0; i < args.length; ++i) {
                String arg = args[i];
                System.err.println(":" + arg);
                if (!arg.startsWith("+")) continue;
                System.err.println("/" + arg);
                int index = arg.indexOf(61);
                if (index == -1) {
                    this.usage("Missing '=' after " + arg);
                }
                String s = arg.substring(1, index);
                String v = arg.substring(index + 1);
                System.err.println(s + "=" + v);
                PropertyDescriptor[] pds = info.getPropertyDescriptors();
                boolean found = false;
                for (int j = 0; j < pds.length; ++j) {
                    PropertyDescriptor pd = pds[j];
                    if (!pd.getName().equals(s)) continue;
                    found = true;
                    Method method = pd.getWriteMethod();
                    try {
                        Class<?> type = pd.getPropertyType();
                        Object value = null;
                        System.err.println(type);
                        if (type.equals(Float.TYPE)) {
                            value = Float.valueOf(v);
                        } else if (type.equals(Integer.TYPE)) {
                            value = Integer.valueOf(v);
                        } else if (type.equals(Boolean.TYPE)) {
                            value = Boolean.valueOf(v);
                        } else if (type.equals(class$java$lang$String == null ? FilterImage.class$("java.lang.String") : class$java$lang$String)) {
                            value = v;
                        } else if (type.equals(class$java$awt$Image == null ? FilterImage.class$("java.awt.Image") : class$java$awt$Image)) {
                            value = ImageIO.read(new URL(v));
                        }
                        if (value != null) {
                            method.invoke((Object)filter, value);
                            break;
                        }
                        this.usage("Can't set property of type: " + type);
                    }
                    catch (Exception ex) {
                        System.err.println("Error setting value for property: " + s);
                        ex.printStackTrace();
                    }
                    break;
                }
                if (found) continue;
                System.err.println("No such property in object: " + s);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (filter != null) {
            for (i = 0; i < images.size(); ++i) {
                String arg = (String)images.get(i);
                if (arg.startsWith("-") || arg.startsWith("+")) continue;
                BufferedImage image = null;
                try {
                    image = ImageIO.read(new URL(arg));
                }
                catch (Exception e) {
                    System.err.println("Can't read input image: " + arg);
                    e.printStackTrace();
                    System.exit(1);
                }
                image = filter.filter(image, null);
                try {
                    ImageIO.write((RenderedImage)image, "png", System.out);
                    continue;
                }
                catch (Exception e) {
                    System.err.println("Can't write output image: " + arg);
                    System.exit(1);
                }
            }
        }
    }

    public void usage(String message) {
        System.err.println(message);
        System.exit(1);
    }

    public static void main(String[] args) {
        new FilterImage(args);
    }
}

