/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.QuaquaUtilities;
import ch.randelshofer.quaqua.ViewportPainter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class QuaquaTableUI
extends BasicTableUI
implements ViewportPainter {
    private PropertyChangeListener propertyChangeListener;
    private boolean isStriped = false;

    public static ComponentUI createUI(JComponent c) {
        return new QuaquaTableUI();
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    private Color getAlternateColor(int modulo) {
        if (modulo == 0) {
            return UIManager.getColor("Table.alternateBackground.0");
        }
        return UIManager.getColor("Table.alternateBackground.1");
    }

    protected void installListeners() {
        super.installListeners();
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.table.addPropertyChangeListener(this.propertyChangeListener);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.table.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
    }

    protected void installDefaults() {
        super.installDefaults();
        Object property = this.table.getClientProperty("Quaqua.Table.style");
        this.isStriped = property != null && property.equals("striped");
        this.updateStriped();
    }

    private void updateStriped() {
        if (this.isStriped) {
            this.table.setIntercellSpacing(new Dimension(1, 1));
            this.table.setShowHorizontalLines(false);
            this.table.setShowVerticalLines(true);
            Color gridColor = this.table.getGridColor();
            if (gridColor == null || gridColor instanceof UIResource) {
                this.table.setGridColor(new ColorUIResource(192, 192, 192));
            }
        } else {
            this.table.setIntercellSpacing(new Dimension(1, 1));
            this.table.setShowHorizontalLines(false);
            this.table.setShowVerticalLines(false);
            Color gridColor = this.table.getGridColor();
            if (gridColor == null || gridColor instanceof UIResource) {
                this.table.setGridColor(new ColorUIResource(255, 255, 255));
            }
        }
    }

    public void paint(Graphics g, JComponent c) {
        boolean ltr;
        if (this.table.getRowCount() <= 0 || this.table.getColumnCount() <= 0) {
            return;
        }
        Rectangle clip = g.getClipBounds();
        Point upperLeft = clip.getLocation();
        Point lowerRight = new Point(clip.x + clip.width - 1, clip.y + clip.height - 1);
        int rMin = this.table.rowAtPoint(upperLeft);
        int rMax = this.table.rowAtPoint(lowerRight);
        if (rMin == -1) {
            rMin = 0;
        }
        if (rMax == -1) {
            rMax = this.table.getRowCount() - 1;
        }
        int cMin = this.table.columnAtPoint((ltr = this.table.getComponentOrientation().isLeftToRight()) ? upperLeft : lowerRight);
        int cMax = this.table.columnAtPoint(ltr ? lowerRight : upperLeft);
        if (cMin == -1) {
            cMin = 0;
        }
        if (cMax == -1) {
            cMax = this.table.getColumnCount() - 1;
        }
        this.paintGrid(g, rMin, rMax, cMin, cMax);
        this.paintCells(g, rMin, rMax, cMin, cMax);
    }

    public void paintViewport(Graphics g, JViewport c) {
        if (this.isStriped) {
            int y;
            g.setColor(this.getAlternateColor(1));
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
            Dimension vs = c.getSize();
            Dimension ts = this.table.getSize();
            Point p = this.table.getLocation();
            int rh = this.table.getRowHeight();
            int n = this.table.getRowCount();
            int row = Math.abs(p.y / rh);
            int th = n * rh - row * rh;
            g.setColor(this.getAlternateColor(0));
            if (ts.width < vs.width) {
                y = p.y + row * rh;
                while (y < th) {
                    if (row % 2 == 0) {
                        g.fillRect(0, y, vs.width, rh);
                    }
                    y += rh;
                    ++row;
                }
            }
            if (th < vs.height) {
                row = n;
                y = th;
                while (y < vs.height) {
                    if (row % 2 == 0) {
                        g.fillRect(0, y, vs.width, rh);
                    }
                    y += rh;
                    ++row;
                }
                g.setColor(Color.lightGray);
                TableColumnModel cm = this.table.getColumnModel();
                n = cm.getColumnCount();
                y = th;
                int x = this.table.getX() - 1;
                for (int i = 0; i < n; ++i) {
                    TableColumn col = cm.getColumn(i);
                    g.drawLine(x += col.getWidth(), y, x, vs.height);
                }
            }
        } else {
            g.setColor(this.table.getBackground());
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
    }

    private void paintGrid(Graphics g, int rMin, int rMax, int cMin, int cMax) {
        g.setColor(this.table.getGridColor());
        Rectangle minCell = this.table.getCellRect(rMin, cMin, true);
        Rectangle maxCell = this.table.getCellRect(rMax, cMax, true);
        Rectangle damagedArea = minCell.union(maxCell);
        if (this.table.getShowHorizontalLines()) {
            int tableWidth = damagedArea.x + damagedArea.width;
            int y = damagedArea.y;
            for (int row = rMin; row <= rMax; ++row) {
                g.drawLine(damagedArea.x, (y += this.table.getRowHeight(row)) - 1, tableWidth - 1, y - 1);
            }
        }
        if (this.table.getShowVerticalLines()) {
            int x;
            TableColumnModel cm = this.table.getColumnModel();
            int tableHeight = damagedArea.y + damagedArea.height;
            if (this.table.getComponentOrientation().isLeftToRight()) {
                x = damagedArea.x;
                for (int column = cMin; column <= cMax; ++column) {
                    int w = cm.getColumn(column).getWidth();
                    g.drawLine((x += w) - 1, 0, x - 1, tableHeight - 1);
                }
            } else {
                x = damagedArea.x + damagedArea.width;
                for (int column = cMin; column < cMax; ++column) {
                    int w = cm.getColumn(column).getWidth();
                    g.drawLine((x -= w) - 1, 0, x - 1, tableHeight - 1);
                }
                g.drawLine(x -= cm.getColumn(cMax).getWidth(), 0, x, tableHeight - 1);
            }
        }
    }

    private void paintDraggedArea(Graphics g, int rMin, int rMax, TableColumn draggedColumn, int distance) {
        int draggedColumnIndex = this.viewIndexForColumn(draggedColumn);
        Rectangle minCell = this.table.getCellRect(rMin, draggedColumnIndex, true);
        Rectangle maxCell = this.table.getCellRect(rMax, draggedColumnIndex, true);
        Rectangle vacatedColumnRect = minCell.union(maxCell);
        g.setColor(this.table.getParent().getBackground());
        g.fillRect(vacatedColumnRect.x, vacatedColumnRect.y, vacatedColumnRect.width, vacatedColumnRect.height);
        vacatedColumnRect.x += distance;
        g.setColor(this.table.getBackground());
        g.fillRect(vacatedColumnRect.x, vacatedColumnRect.y, vacatedColumnRect.width, vacatedColumnRect.height);
        if (this.table.getShowVerticalLines()) {
            g.setColor(this.table.getGridColor());
            int x1 = vacatedColumnRect.x;
            int y1 = vacatedColumnRect.y;
            int x2 = x1 + vacatedColumnRect.width - 1;
            int y2 = y1 + vacatedColumnRect.height - 1;
            g.drawLine(x1 - 1, y1, x1 - 1, y2);
            g.drawLine(x2, y1, x2, y2);
        }
        for (int row = rMin; row <= rMax; ++row) {
            Rectangle r = this.table.getCellRect(row, draggedColumnIndex, false);
            r.x += distance;
            this.paintCell(g, r, row, draggedColumnIndex);
            if (!this.table.getShowHorizontalLines()) continue;
            g.setColor(this.table.getGridColor());
            Rectangle rcr = this.table.getCellRect(row, draggedColumnIndex, true);
            rcr.x += distance;
            int x1 = rcr.x;
            int y1 = rcr.y;
            int x2 = x1 + rcr.width - 1;
            int y2 = y1 + rcr.height - 1;
            g.drawLine(x1, y2, x2, y2);
        }
    }

    private int viewIndexForColumn(TableColumn aColumn) {
        TableColumnModel cm = this.table.getColumnModel();
        for (int column = 0; column < cm.getColumnCount(); ++column) {
            if (cm.getColumn(column) != aColumn) continue;
            return column;
        }
        return -1;
    }

    private void paintCells(Graphics g, int rMin, int rMax, int cMin, int cMax) {
        JTableHeader header = this.table.getTableHeader();
        TableColumn draggedColumn = header == null ? null : header.getDraggedColumn();
        TableColumnModel cm = this.table.getColumnModel();
        int columnMargin = cm.getColumnMargin();
        if (this.table.getComponentOrientation().isLeftToRight()) {
            for (int row = rMin; row <= rMax; ++row) {
                Rectangle cellRect = this.table.getCellRect(row, cMin, false);
                for (int column = cMin; column <= cMax; ++column) {
                    TableColumn aColumn = cm.getColumn(column);
                    int columnWidth = aColumn.getWidth();
                    cellRect.width = columnWidth - columnMargin;
                    if (aColumn != draggedColumn) {
                        this.paintCell(g, cellRect, row, column);
                    }
                    cellRect.x += columnWidth;
                }
            }
        } else {
            for (int row = rMin; row <= rMax; ++row) {
                int columnWidth;
                Rectangle cellRect = this.table.getCellRect(row, cMin, false);
                TableColumn aColumn = cm.getColumn(cMin);
                if (aColumn != draggedColumn) {
                    columnWidth = aColumn.getWidth();
                    cellRect.width = columnWidth - columnMargin;
                    this.paintCell(g, cellRect, row, cMin);
                }
                for (int column = cMin + 1; column <= cMax; ++column) {
                    aColumn = cm.getColumn(column);
                    columnWidth = aColumn.getWidth();
                    cellRect.width = columnWidth - columnMargin;
                    cellRect.x -= columnWidth;
                    if (aColumn == draggedColumn) continue;
                    this.paintCell(g, cellRect, row, column);
                }
            }
        }
        if (draggedColumn != null) {
            this.paintDraggedArea(g, rMin, rMax, draggedColumn, header.getDraggedDistance());
        }
        this.rendererPane.removeAll();
    }

    private void paintCell(Graphics g, Rectangle cellRect, int row, int column) {
        if (this.table.isEditing() && this.table.getEditingRow() == row && this.table.getEditingColumn() == column) {
            Component component = this.table.getEditorComponent();
            component.setBounds(cellRect);
            component.setBackground(this.isStriped ? this.getAlternateColor(row % 2) : this.table.getBackground());
            if (row % 2 == 0) {
                g.setColor(this.getAlternateColor(0));
                g.fillRect(cellRect.x, cellRect.y, cellRect.width, cellRect.height);
            }
            component.setFont(this.table.getFont());
            component.validate();
        } else {
            TableCellRenderer renderer = this.table.getCellRenderer(row, column);
            Component component = this.table.prepareRenderer(renderer, row, column);
            if (this.table.isRowSelected(row)) {
                g.setColor(UIManager.getColor("Table.selectionBackground"));
                g.fillRect(cellRect.x, cellRect.y, cellRect.width, cellRect.height);
            } else if (this.isStriped) {
                component.setBackground(this.getAlternateColor(row % 2));
                if (row % 2 == 0) {
                    g.setColor(this.getAlternateColor(0));
                    g.fillRect(cellRect.x, cellRect.y, cellRect.width, cellRect.height);
                }
            }
            this.rendererPane.paintComponent(g, component, this.table, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
        }
    }

    protected MouseInputListener createMouseInputListener() {
        return new MouseHandler();
    }

    private PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    public class MouseHandler
    implements MouseInputListener {
        private Component dispatchComponent;
        private boolean selectedOnPress;

        public void mouseClicked(MouseEvent e) {
        }

        private void setDispatchComponent(MouseEvent e) {
            Component editorComponent = QuaquaTableUI.this.table.getEditorComponent();
            Point p = e.getPoint();
            Point p2 = SwingUtilities.convertPoint(QuaquaTableUI.this.table, p, editorComponent);
            this.dispatchComponent = SwingUtilities.getDeepestComponentAt(editorComponent, p2.x, p2.y);
        }

        private boolean repostEvent(MouseEvent e) {
            if (this.dispatchComponent == null || !QuaquaTableUI.this.table.isEditing()) {
                return false;
            }
            MouseEvent e2 = SwingUtilities.convertMouseEvent(QuaquaTableUI.this.table, e, this.dispatchComponent);
            this.dispatchComponent.dispatchEvent(e2);
            return true;
        }

        private void setValueIsAdjusting(boolean flag) {
            QuaquaTableUI.this.table.getSelectionModel().setValueIsAdjusting(flag);
            QuaquaTableUI.this.table.getColumnModel().getSelectionModel().setValueIsAdjusting(flag);
        }

        private boolean shouldIgnore(MouseEvent e) {
            return e.isConsumed() || !SwingUtilities.isLeftMouseButton(e) || !QuaquaTableUI.this.table.isEnabled() || e.isPopupTrigger();
        }

        public void mousePressed(MouseEvent e) {
            if (e.isConsumed()) {
                this.selectedOnPress = false;
                return;
            }
            this.selectedOnPress = true;
            this.adjustFocusAndSelection(e);
        }

        void adjustFocusAndSelection(MouseEvent e) {
            if (this.shouldIgnore(e)) {
                return;
            }
            Point p = e.getPoint();
            int row = QuaquaTableUI.this.table.rowAtPoint(p);
            int column = QuaquaTableUI.this.table.columnAtPoint(p);
            if (column == -1 || row == -1) {
                return;
            }
            if (QuaquaTableUI.this.table.editCellAt(row, column, e)) {
                this.setDispatchComponent(e);
                this.repostEvent(e);
            } else if (QuaquaTableUI.this.table.isRequestFocusEnabled()) {
                QuaquaTableUI.this.table.requestFocus();
            }
            TableCellEditor editor = QuaquaTableUI.this.table.getCellEditor();
            if (editor == null || editor.shouldSelectCell(e)) {
                boolean adjusting = e.getID() == 501;
                this.setValueIsAdjusting(adjusting);
                QuaquaTableUI.this.table.changeSelection(row, column, e.isMetaDown(), e.isShiftDown());
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (this.selectedOnPress) {
                if (this.shouldIgnore(e)) {
                    return;
                }
                this.repostEvent(e);
                this.dispatchComponent = null;
                this.setValueIsAdjusting(false);
            } else {
                this.adjustFocusAndSelection(e);
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
            if (this.shouldIgnore(e)) {
                return;
            }
            this.repostEvent(e);
            TableCellEditor editor = QuaquaTableUI.this.table.getCellEditor();
            if (editor == null || editor.shouldSelectCell(e)) {
                Point p = e.getPoint();
                int row = QuaquaTableUI.this.table.rowAtPoint(p);
                int column = QuaquaTableUI.this.table.columnAtPoint(p);
                if (column == -1 || row == -1) {
                    return;
                }
                Object bySize = QuaquaTableUI.this.table.getClientProperty("Table.isFileList");
                if (bySize instanceof Boolean && ((Boolean)bySize).booleanValue()) {
                    return;
                }
                QuaquaTableUI.this.table.changeSelection(row, column, false, true);
            }
        }
    }

    public class FocusHandler
    extends BasicTableUI.FocusHandler {
        public FocusHandler() {
            super(QuaquaTableUI.this);
        }

        public void focusGained(FocusEvent event) {
            super.focusGained(event);
            QuaquaUtilities.repaintBorder((JComponent)event.getComponent());
        }

        public void focusLost(FocusEvent event) {
            super.focusLost(event);
            QuaquaUtilities.repaintBorder((JComponent)event.getComponent());
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            String changeName = event.getPropertyName();
            if (changeName.equals("Quaqua.Table.style")) {
                Object value = event.getNewValue();
                QuaquaTableUI.this.isStriped = value != null && value.equals("striped");
                QuaquaTableUI.this.updateStriped();
            }
        }
    }
}

