/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.app;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.peer.LightweightPeer;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class AppInternalFrame
extends JInternalFrame {
    public AppInternalFrame(String t) {
        super(t);
        this.setGlassPane(new AppGlassPane());
    }

    public AppInternalFrame(String t, boolean resizable) {
        super(t, resizable);
        this.setGlassPane(new AppGlassPane());
    }

    public AppInternalFrame(String t, boolean resizable, boolean closable) {
        super(t, resizable, closable);
        this.setGlassPane(new AppGlassPane());
    }

    public AppInternalFrame(String t, boolean resizable, boolean closable, boolean maximizable) {
        super(t, resizable, closable, maximizable);
        this.setGlassPane(new AppGlassPane());
    }

    public AppInternalFrame(String t, boolean resizable, boolean closable, boolean maximizable, boolean iconifiable) {
        super(t, resizable, closable, maximizable, iconifiable);
        this.setGlassPane(new AppGlassPane());
    }

    class AppGlassPane
    extends JPanel
    implements MouseListener,
    MouseMotionListener {
        private Component mouseEventTarget = null;

        public AppGlassPane() {
            this.setName(this.getName() + ".glassPane");
            this.setVisible(false);
            this.setOpaque(false);
            this.addMouseListener(this);
        }

        public synchronized void removeMouseListener(MouseListener l) {
            if (l == this) {
                super.addMouseListener(l);
            }
        }

        public synchronized void removeMouseMotionListener(MouseMotionListener l) {
            if (l == this) {
                super.removeMouseMotionListener(l);
            }
        }

        public synchronized void addMouseListener(MouseListener l) {
            if (l == this) {
                super.addMouseListener(l);
            }
        }

        public synchronized void addMouseMotionListener(MouseMotionListener l) {
            if (l == this) {
                super.addMouseMotionListener(l);
            }
        }

        public void mouseClicked(MouseEvent e) {
            this.forwardMouseEvent(e);
        }

        public void mousePressed(MouseEvent e) {
            try {
                AppInternalFrame.this.setSelected(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.addMouseMotionListener(this);
            this.forwardMouseEvent(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.removeMouseMotionListener(this);
            this.forwardMouseEvent(e);
        }

        public void mouseExited(MouseEvent e) {
            this.forwardMouseEvent(e);
        }

        public void mouseEntered(MouseEvent e) {
            this.forwardMouseEvent(e);
        }

        public void mouseMoved(MouseEvent e) {
            this.forwardMouseEvent(e);
        }

        public void mouseDragged(MouseEvent e) {
            this.forwardMouseEvent(e);
        }

        private void forwardMouseEvent(MouseEvent e) {
            Component target = this.findComponentAt(AppInternalFrame.this.getContentPane(), e.getX(), e.getY());
            if (target != this.mouseEventTarget) {
                this.setMouseTarget(target, e);
            }
            this.retargetMouseEvent(e.getID(), e);
        }

        private Component findComponentAt(Container c, int x, int y) {
            if (!c.contains(x, y)) {
                return c;
            }
            int ncomponents = c.getComponentCount();
            Component[] component = c.getComponents();
            for (int i = 0; i < ncomponents; ++i) {
                Component comp = component[i];
                Point loc = comp.getLocation();
                if (comp == null || !comp.contains(x - loc.x, y - loc.y) || !(comp.getPeer() instanceof LightweightPeer) || !comp.isVisible()) continue;
                if (comp instanceof Container) {
                    Container child = (Container)comp;
                    Point childLoc = child.getLocation();
                    Component deeper = this.findComponentAt(child, x - childLoc.x, y - childLoc.y);
                    if (deeper == null) continue;
                    return deeper;
                }
                return comp;
            }
            return c;
        }

        private void setMouseTarget(Component target, MouseEvent e) {
            if (this.mouseEventTarget != null) {
                this.retargetMouseEvent(505, e);
            }
            this.mouseEventTarget = target;
            if (this.mouseEventTarget != null) {
                this.retargetMouseEvent(504, e);
            }
        }

        private void retargetMouseEvent(int id, MouseEvent e) {
            Point p = SwingUtilities.convertPoint(AppInternalFrame.this.getContentPane(), e.getX(), e.getY(), this.mouseEventTarget);
            MouseEvent retargeted = new MouseEvent(this.mouseEventTarget, id, e.getWhen(), e.getModifiers(), p.x, p.y, e.getClickCount(), e.isPopupTrigger());
            this.mouseEventTarget.dispatchEvent(retargeted);
        }
    }
}

