/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.app;

import com.jhlabs.app.AppInternalFrame;
import com.jhlabs.app.Application;
import com.jhlabs.app.Document;
import com.jhlabs.app.DocumentController;
import com.jhlabs.app.StatusBar;
import com.jhlabs.app.StatusDisplay;
import com.jhlabs.app.WindowMenuItem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class DocumentWindow
implements PropertyChangeListener,
StatusDisplay {
    private DocumentController controller;
    private Document document;
    protected Application application;
    private int viewNumber;
    private AppInternalFrame internalFrame;
    private JFrame jFrame;
    private DocIFrameListener iFrameListener;
    private DocJFrameListener jFrameListener;
    protected StatusBar statusBar;
    protected JLabel statusLabel;
    protected JToolBar toolBar;
    private boolean closed = false;
    private JMenu windowsMenu;
    private int uniqueID = uniqueIDCount++;
    private static int uniqueIDCount = 0;

    public DocumentWindow(Document document, DocumentController controller) {
        this.document = document;
        this.controller = controller;
        this.application = document.getApplication();
        if (this.application.isMDI) {
            this.internalFrame = new AppInternalFrame("", true, true, true, true);
            this.internalFrame.setDefaultCloseOperation(0);
        } else {
            this.jFrame = new JFrame();
            this.jFrame.setDefaultCloseOperation(0);
        }
        document.addPropertyChangeListener(this);
        document.addView(this);
        this.viewNumber = document.getViewNumber();
        this.setWindowTitle();
        this.getContentPane().setLayout(new BorderLayout());
        String iconName = this.application.getDocumentWindowImage();
        if (this.internalFrame != null) {
            if (iconName != null) {
                this.internalFrame.setFrameIcon(new ImageIcon(this.getClass().getResource(iconName)));
            }
            this.iFrameListener = new DocIFrameListener();
            this.internalFrame.addInternalFrameListener(this.iFrameListener);
        } else {
            if (iconName != null) {
                this.jFrame.setIconImage(new ImageIcon(this.getClass().getResource(iconName)).getImage());
            }
            this.jFrameListener = new DocJFrameListener();
            this.jFrame.addWindowListener(this.jFrameListener);
            this.jFrame.setJMenuBar(controller.makeMenubar(this));
            this.toolBar = controller.makeToolbar();
            this.jFrame.getContentPane().add((Component)this.toolBar, "North");
            this.statusBar = new StatusBar();
            this.jFrame.getContentPane().add((Component)this.statusBar, "South");
            this.statusLabel = new JLabel(){

                public void revalidate() {
                }
            };
            this.statusBar.add(this.statusLabel);
            this.statusLabel.setOpaque(true);
        }
    }

    public AppInternalFrame getInternalFrame() {
        return this.internalFrame;
    }

    public JFrame getJFrame() {
        return this.jFrame;
    }

    public Container getContentPane() {
        if (this.internalFrame != null) {
            return this.internalFrame.getContentPane();
        }
        return this.jFrame.getContentPane();
    }

    public void setWindowsMenu(JMenu windowsMenu) {
        this.windowsMenu = windowsMenu;
    }

    public JMenu getWindowsMenu() {
        return this.windowsMenu;
    }

    public int getUniqueID() {
        return this.uniqueID;
    }

    public boolean isVisible() {
        if (this.internalFrame != null) {
            return this.internalFrame.isVisible();
        }
        return this.jFrame != null;
    }

    public void setVisible(boolean b) {
        if (this.internalFrame != null) {
            this.internalFrame.setVisible(b);
        } else {
            this.jFrame.setVisible(b);
        }
    }

    public void toFront() {
        if (this.internalFrame != null) {
            this.internalFrame.toFront();
        } else {
            this.jFrame.toFront();
        }
    }

    public void validate() {
        if (this.internalFrame != null) {
            this.internalFrame.validate();
        } else {
            this.jFrame.validate();
        }
    }

    public void setSize(int w, int h) {
        if (this.internalFrame != null) {
            this.internalFrame.setSize(w, h);
        } else {
            this.jFrame.setSize(w, h);
        }
    }

    public void setBounds(int x, int y, int w, int h) {
        if (this.internalFrame != null) {
            this.internalFrame.setBounds(x, y, w, h);
        } else {
            this.jFrame.setBounds(x, y, w, h);
        }
    }

    public Rectangle getBounds() {
        if (this.internalFrame != null) {
            return this.internalFrame.getBounds();
        }
        return this.jFrame.getBounds();
    }

    public void pack() {
        if (this.internalFrame != null) {
            this.internalFrame.pack();
        } else {
            this.jFrame.pack();
        }
    }

    public int getViewNumber() {
        return this.viewNumber;
    }

    public void setDocument(Document doc) {
        if (this.document != null) {
            this.document.removePropertyChangeListener(this);
            this.document.removeView(this);
        }
        this.document = doc;
        this.document.addPropertyChangeListener(this);
        this.document.addView(this);
        this.viewNumber = this.document.getViewNumber();
        this.setWindowTitle();
    }

    public Document getDocument() {
        return this.document;
    }

    public DocumentController getDocumentController() {
        return this.controller;
    }

    public JMenuBar getFrameMenuBar() {
        return this.getDocumentController().menuBar;
    }

    public JToolBar getFrameToolBar() {
        return this.getDocumentController().toolBar;
    }

    public JToolBar getToolBar() {
        return this.toolBar;
    }

    public JMenuBar getMenuBar() {
        return this.jFrame != null ? this.jFrame.getJMenuBar() : null;
    }

    public void propertyChange(PropertyChangeEvent e) {
        Object source = e.getSource();
        String p = e.getPropertyName();
        if (source == this.document && (p.equals("file") || p.equals("changed") || p.equals("views"))) {
            this.setWindowTitle();
        }
    }

    public void enableCommands() {
        this.getDocumentController().enableCommands();
    }

    protected String getWindowTitle() {
        String title = this.document.getTitle();
        if (this.document.numViews() > 1) {
            title = title + "[" + this.viewNumber + "]";
        }
        if (this.document.isChanged()) {
            title = "* " + title;
        }
        return title;
    }

    public void setWindowTitle() {
        String title = this.getWindowTitle();
        if (this.internalFrame != null) {
            this.internalFrame.setTitle(title);
        } else {
            this.jFrame.setTitle(title);
        }
    }

    public StatusBar getStatusBar() {
        return this.statusBar;
    }

    public ResourceBundle getCommonResources() {
        return ResourceBundle.getBundle("com.jhlabs.app.CommonResourceBundle");
    }

    public boolean confirmClose(boolean quitting) {
        if (this.document.numViews() == 1 && this.document.isChanged()) {
            Object[] arguments = new Object[]{this.document.getTitle()};
            String message = "<html>" + UIManager.get("OptionPane.css") + MessageFormat.format(this.getCommonResources().getString(quitting ? "saveBeforeQuit" : "saveBeforeClose"), arguments);
            Object[] saveOptionNames = new String[]{"Save", "Cancel", "Don't Save"};
            JOptionPane pane = new JOptionPane(message, 2, -1, null);
            pane.setOptions(saveOptionNames);
            pane.setInitialValue(saveOptionNames[0]);
            pane.putClientProperty("Quaqua.OptionPane.destructiveOption", new Integer(2));
            JDialog dialog = pane.createDialog(null, "Save Changes");
            dialog.setVisible(true);
            dialog.dispose();
            Object result = pane.getValue();
            if (((String)saveOptionNames[0]).equals(result)) {
                if (this.document.getController().doSave(this.document)) {
                    return true;
                }
            } else if (((String)saveOptionNames[2]).equals(result)) {
                this.document.setChanged(false);
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    public void closeWindow(boolean quitting) {
        this.document.removePropertyChangeListener(this);
        if (this.internalFrame != null) {
            try {
                this.internalFrame.removeInternalFrameListener(this.iFrameListener);
                this.internalFrame.setClosed(true);
                this.document.removeView(this);
            }
            catch (PropertyVetoException propertyVetoException) {}
        } else {
            this.document.removeView(this);
        }
        this.application.closeWindow(this, quitting);
    }

    public void doClose(boolean quitting) {
        if (this.confirmClose(quitting)) {
            this.closeWindow(quitting);
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void dispose() {
        if (this.internalFrame != null) {
            this.internalFrame.removeInternalFrameListener(this.iFrameListener);
            this.internalFrame.dispose();
        } else {
            this.jFrame.removeWindowListener(this.jFrameListener);
            this.jFrame.dispose();
        }
        if (this.windowsMenu != null) {
            for (int i = this.windowsMenu.getItemCount() - 1; i >= 0; --i) {
                JMenuItem item = this.windowsMenu.getItem(i);
                if (!(item instanceof WindowMenuItem)) continue;
                ((WindowMenuItem)item).dispose();
            }
        }
        this.closed = true;
    }

    public void showMessage(String message) {
    }

    public void showProgress(int percentage) {
        this.showMessage(percentage + "%");
    }

    public void busyCursor(boolean busy) {
        if (this.jFrame != null) {
            this.jFrame.setCursor(Cursor.getPredefinedCursor(busy ? 3 : 0));
        }
    }

    public String toString() {
        if (this.internalFrame != null) {
            return this.internalFrame.getTitle();
        }
        return this.jFrame.getTitle();
    }

    public void finalize() {
        if (Application.debugLevel > 0) {
            System.out.println("DocumentWindow.finalize()");
        }
    }

    class DocJFrameListener
    extends WindowAdapter {
        DocJFrameListener() {
        }

        public void windowActivated(WindowEvent e) {
            DocumentWindow.this.application.activateWindow(DocumentWindow.this);
        }

        public void windowClosing(WindowEvent e) {
            DocumentWindow.this.doClose(false);
        }
    }

    class DocIFrameListener
    extends InternalFrameAdapter {
        DocIFrameListener() {
        }

        public void internalFrameActivated(InternalFrameEvent e) {
            DocumentWindow.this.application.activateWindow(DocumentWindow.this);
        }

        public void internalFrameClosing(InternalFrameEvent e) {
            DocumentWindow.this.doClose(false);
        }
    }
}

