/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.ie;

import com.jhlabs.app.Application;
import com.jhlabs.app.VectorListModel;
import com.jhlabs.ie.CompositionEvent;
import com.jhlabs.ie.CompositionListener;
import com.jhlabs.ie.layer.ImageLayer;
import com.jhlabs.ie.layer.Layer;
import com.jhlabs.image.ImageUtils;
import com.jhlabs.image.OffsetFilter;
import com.jhlabs.image.PointFilter;
import com.jhlabs.util.Memento;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.RasterOp;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.imageio.ImageIO;

public class Composition {
    public static final int SELECTED = -16777216;
    public static final int UNSELECTED = 0;
    private Vector layers = new Vector();
    private BufferedImage compositeImage;
    private Layer documentSelection;
    private Layer floatingLayer;
    private Layer floatingLayerParent;
    private Layer previewLayer;
    private BufferedImageOp previewFilter;
    private float previewOriginX;
    private float previewOriginY;
    private Layer activeLayer;
    private Rectangle dirtyRegion;
    private Rectangle dirtySelectionRegion;
    private Rectangle selectionBounds;
    private boolean drawSelectionOnly;
    private transient Vector listeners = null;
    private transient VectorListModel layersModel;
    private int oldWidth;
    private int oldHeight;
    private int layerIndex = 0;
    private int width;
    private int height;

    public Composition() {
        this(32, 32);
    }

    public Composition(int width, int height) {
        this.width = width;
        this.height = height;
        this.layersModel = new VectorListModel(this.layers);
        this.compositeImage = new BufferedImage(width, height, 2);
        BufferedImage p = new BufferedImage(width, height, 2);
        this.documentSelection = new ImageLayer(p);
    }

    public Composition(int width, int height, int color) {
        this(new BufferedImage(width, height, 2), color);
    }

    public Composition(BufferedImage image, int color) {
        this(image);
        if (color != 0) {
            Graphics2D g = image.createGraphics();
            g.setColor(new Color(color));
            g.fillRect(0, 0, image.getWidth(), image.getHeight());
            g.dispose();
        }
    }

    public Composition(BufferedImage image) {
        this.width = image.getWidth();
        this.height = image.getHeight();
        this.layersModel = new VectorListModel(this.layers);
        this.compositeImage = new BufferedImage(this.width, this.height, 2);
        BufferedImage p = new BufferedImage(this.width, this.height, 2);
        this.documentSelection = new ImageLayer(p);
        this.addLayer(image);
    }

    public Rectangle getBounds() {
        return new Rectangle(this.width, this.height);
    }

    public void startUpdate() {
        this.dirtyRegion = null;
        this.dirtySelectionRegion = null;
        this.oldWidth = this.getWidth();
        this.oldHeight = this.getHeight();
    }

    public void endUpdate() {
        this.endUpdate(true);
    }

    public void endUpdate(boolean changed) {
        if (this.oldWidth != this.getWidth() || this.oldHeight != this.getHeight()) {
            this.compositeImage = new BufferedImage(this.getWidth(), this.getHeight(), 2);
            this.notifyListeners(new CompositionEvent(this, 3));
            this.updateAll();
        }
        if (this.dirtyRegion != null || this.dirtySelectionRegion != null) {
            Rectangle r = this.dirtyRegion;
            if (r == null) {
                r = this.dirtySelectionRegion;
            }
            if (this.dirtySelectionRegion != null) {
                r = r.union(this.dirtySelectionRegion);
                this.selectionBounds = ImageUtils.getSelectedBounds(this.documentSelection.getImage());
            }
            r = r.intersection(new Rectangle(0, 0, this.width, this.height));
            if (this.dirtyRegion != null) {
                this.updateCompositeImage(this.dirtyRegion);
            }
            this.notifyListeners(new CompositionEvent(this, changed ? 1 : 0, r));
            this.dirtyRegion = null;
            this.dirtySelectionRegion = null;
        }
    }

    public void update(Rectangle r) {
        if (r != null) {
            this.dirtyRegion = this.dirtyRegion != null ? this.dirtyRegion.union(r) : r;
        }
    }

    public void update(Layer l) {
        if (l != null) {
            Rectangle r = l.getBounds();
            AffineTransform at = l.getTransform();
            if (at != null) {
                r.translate((int)at.getTranslateX(), (int)at.getTranslateY());
            }
            this.update(r);
        }
    }

    public void updateAll() {
        this.update(new Rectangle(0, 0, this.getWidth(), this.getHeight()));
    }

    public void updateSelection(Rectangle r) {
        if (r != null) {
            this.dirtySelectionRegion = this.dirtySelectionRegion != null ? this.dirtySelectionRegion.union(r) : r;
        }
    }

    public void updateAllSelection() {
        if (this.getSelection() != null) {
            this.updateSelection(this.getSelectionLayer().getBounds());
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public ColorModel getColorModel() {
        return ColorModel.getRGBdefault();
    }

    public void setDrawSelectionOnly(boolean drawSelectionOnly) {
        this.drawSelectionOnly = drawSelectionOnly;
        this.startUpdate();
        this.updateAll();
        this.endUpdate();
    }

    public boolean getDrawSelectionOnly() {
        return this.drawSelectionOnly;
    }

    public BufferedImage getCompositeImage() {
        return this.compositeImage;
    }

    public void setImage(BufferedImage p) {
        this.layerIndex = 0;
        this.width = p.getWidth();
        this.height = p.getHeight();
        this.layersModel.removeAllElements();
        this.addLayer(p);
        this.compositeImage = new BufferedImage(this.width, this.height, 2);
        BufferedImage selection = new BufferedImage(this.width, this.height, 2);
        this.documentSelection = new ImageLayer(selection);
        this.updateAll();
    }

    public Layer getSelectionLayer() {
        return this.documentSelection;
    }

    public void setSelection(Layer l) {
        this.documentSelection = l;
        this.selectionBounds = ImageUtils.getSelectedBounds(l.getImage());
    }

    public BufferedImage getSelection() {
        return this.getSelectionLayer().getImage();
    }

    public void setSelection(BufferedImage p) {
        this.setSelection(new ImageLayer(p));
    }

    public void selectAllRGB(int value) {
        BufferedImage image = this.documentSelection.getImage();
        Graphics2D g = image.createGraphics();
        g.setColor(new Color(value));
        g.fillRect(0, 0, image.getWidth(), image.getHeight());
        g.dispose();
        this.updateAllSelection();
    }

    public void selectAll() {
        BufferedImage selection = this.getSelection();
        Graphics2D g = selection.createGraphics();
        g.setColor(new Color(-16777216));
        g.fillRect(0, 0, selection.getWidth(), selection.getHeight());
        g.dispose();
        this.updateAllSelection();
    }

    public void selectNone() {
        BufferedImage selection = this.getSelection();
        Graphics2D g = selection.createGraphics();
        g.setComposite(AlphaComposite.Clear);
        g.fillRect(0, 0, selection.getWidth(), selection.getHeight());
        g.dispose();
        this.updateAllSelection();
    }

    public Layer addNewImageLayer(String name) {
        if (name == null) {
            name = "Layer " + ++this.layerIndex;
        }
        ImageLayer layer = new ImageLayer(name, new BufferedImage(this.width, this.height, 2));
        this.addLayer(layer);
        return layer;
    }

    public void addLayer(Layer layer) {
        this.layersModel.addElement(layer);
        this.update(layer);
    }

    public Layer addLayer(BufferedImage image) {
        ++this.layerIndex;
        ImageLayer layer = new ImageLayer("Layer " + this.layerIndex, image);
        this.layersModel.addElement(layer);
        return layer;
    }

    public void removeLayer(Layer layer) {
        if (layer == this.activeLayer) {
            this.activeLayer = null;
        }
        if (layer == this.floatingLayer || layer == this.floatingLayerParent) {
            this.floatingLayerParent = null;
            this.floatingLayer = null;
        }
        if (layer == this.previewLayer) {
            this.previewLayer = null;
            this.previewFilter = null;
        }
        this.layersModel.removeElement(layer);
        this.updateAll();
    }

    public void moveLayerUp(Layer layer) {
        int index = this.layersModel.indexOf(layer);
        if (index != -1 && index < this.layersModel.size() - 1) {
            this.layersModel.removeElementAt(index);
            this.layersModel.insertElementAt(layer, index + 1);
        }
    }

    public void moveLayerDown(Layer layer) {
        int index = this.layersModel.indexOf(layer);
        if (index > 0) {
            this.layersModel.removeElementAt(index);
            this.layersModel.insertElementAt(layer, index - 1);
        }
    }

    public void moveLayer(Layer layer, int newIndex) {
        int index = this.layersModel.indexOf(layer);
        if (index >= 0 && newIndex != index) {
            this.layersModel.removeElementAt(index);
            if (newIndex > index) {
                --newIndex;
            }
            this.layersModel.insertElementAt(layer, newIndex);
        }
    }

    public Layer getTopLayer() {
        return this.layers.size() > 0 ? (Layer)this.layers.lastElement() : null;
    }

    public Layer getActiveLayer() {
        return this.activeLayer != null ? this.activeLayer : (this.activeLayer = this.getTopLayer());
    }

    public void setActiveLayer(Layer layer) {
        if (layer != this.activeLayer) {
            this.activeLayer = layer;
            if (layer != this.floatingLayerParent) {
                this.dropFloatingSelection();
            }
            this.notifyListeners(new CompositionEvent(this, 4));
        }
    }

    public void layerHasChanged(Layer layer) {
        this.notifyListeners(new CompositionEvent(this, 4));
    }

    public Enumeration getLayerEnumeration() {
        return this.layers.elements();
    }

    public void setLayers(Vector layers) {
        this.layers = layers;
        this.layersModel.setDelegate(layers);
    }

    public Vector getLayers() {
        return this.layers;
    }

    public VectorListModel getLayersModel() {
        return this.layersModel;
    }

    public int getNumLayers() {
        return this.layersModel.size();
    }

    public Layer getDocumentSelectionLayer() {
        return this.documentSelection;
    }

    public Layer getFloatingLayer() {
        return this.floatingLayer;
    }

    public void setFloatingLayer(Layer layer) {
        this.setFloatingLayer(layer, null);
    }

    public void setFloatingLayer(Layer layer, Layer parent) {
        Layer oldLayer = this.getFloatingLayer();
        if (oldLayer != null) {
            this.update(oldLayer);
        }
        if (layer != null) {
            if (parent == null) {
                parent = this.getActiveLayer();
            }
            this.floatingLayer = layer;
            this.floatingLayerParent = parent;
            this.update(layer);
            this.setActiveLayer(parent);
        } else {
            this.floatingLayer = null;
            this.floatingLayerParent = null;
        }
        this.selectNone();
    }

    public void addFloatingLayer(BufferedImage image, int x, int y) {
        ImageLayer l = new ImageLayer("Floating Selection", image);
        l.setLocation(x, y);
        this.setFloatingLayer(l, this.getActiveLayer());
    }

    public void setPreviewFilter(Layer layer, BufferedImageOp filter, float previewOriginX, float previewOriginY) {
        this.previewLayer = layer;
        this.previewFilter = filter;
        this.previewOriginX = previewOriginX;
        this.previewOriginY = previewOriginY;
    }

    public BufferedImageOp getPreviewFilter() {
        return this.previewFilter;
    }

    public Dimension getSize() {
        Layer layer = this.getBottomLayer();
        return layer.getSize();
    }

    public Layer getBottomLayer() {
        if (this.layers.size() > 0) {
            return (Layer)this.layers.firstElement();
        }
        return null;
    }

    public BufferedImage getActiveImage() {
        Layer layer = this.getActiveLayer();
        return layer != null ? layer.getImage() : null;
    }

    public boolean hasSelection() {
        return true;
    }

    public boolean hasFloatingSelection() {
        return this.floatingLayer != null && this.floatingLayerParent != null;
    }

    public void sizeChanged(int width, int height) {
        this.startUpdate();
        this.dropFloatingSelection();
        this.updateAll();
        this.width = width;
        this.height = height;
        this.updateAll();
        this.setSelection(new BufferedImage(width, height, 2));
        this.endUpdate();
    }

    public void resize(int width, int height, BufferedImageOp scaleFilter) {
        this.startUpdate();
        this.dropFloatingSelection();
        this.updateAll();
        Iterator it = this.layers.iterator();
        while (it.hasNext()) {
            ((Layer)it.next()).resize(width, height, scaleFilter);
        }
        this.width = width;
        this.height = height;
        this.updateAll();
        this.setSelection(new BufferedImage(width, height, 2));
        this.endUpdate();
    }

    public void crop(Rectangle r) {
        Iterator it = this.layers.iterator();
        while (it.hasNext()) {
            ((Layer)it.next()).crop(r);
        }
        this.width = r.width;
        this.height = r.height;
        this.setSelection(new BufferedImage(this.width, this.height, 2));
    }

    public Rectangle getSelectedBounds() {
        return this.selectionBounds;
    }

    public Rectangle getSelectedOrActiveBounds() {
        if (this.selectionBounds != null) {
            return this.selectionBounds;
        }
        return ImageUtils.getSelectedBounds(this.getActiveLayer().getImage());
    }

    public Rectangle getSelectedOrCompositionBounds() {
        if (this.selectionBounds != null) {
            return this.selectionBounds;
        }
        return this.getBounds();
    }

    public void offsetSelection(int dx, int dy, boolean wrap) {
        this.startUpdate();
        this.dropFloatingSelection();
        BufferedImage image = this.documentSelection.getImage();
        this.documentSelection.setImage(new OffsetFilter(dx, dy, wrap).filter(image, null));
        this.updateAllSelection();
        this.endUpdate();
    }

    public Layer floatSelection() {
        return this.floatSelection(false);
    }

    public Layer floatSelection(boolean copy) {
        if (this.floatingLayer == null) {
            Graphics2D g;
            boolean hasSelection;
            Layer activeLayer = this.getActiveLayer();
            BufferedImage selection = this.getSelection();
            Rectangle r = this.getSelectedBounds();
            boolean bl = hasSelection = r != null;
            if (!hasSelection) {
                r = ImageUtils.getSelectedBounds(activeLayer.getImage());
            }
            if (r == null) {
                return null;
            }
            BufferedImage image = this.getActiveImage();
            ImageLayer layer = new ImageLayer("Floating Selection", ImageUtils.getSubimage(image, r.x, r.y, r.width, r.height));
            layer.setTransform(AffineTransform.getTranslateInstance(r.x, r.y));
            if (hasSelection) {
                g = layer.getImage().createGraphics();
                g.setComposite(AlphaComposite.DstIn);
                g.drawRenderedImage(selection, AffineTransform.getTranslateInstance(-r.x, -r.y));
                g.dispose();
            }
            if (!copy) {
                g = image.createGraphics();
                if (hasSelection) {
                    g.setComposite(AlphaComposite.DstOut);
                    g.drawRenderedImage(selection, null);
                } else {
                    g.setComposite(AlphaComposite.Clear);
                    g.fillRect(r.x, r.y, r.width, r.height);
                }
                g.dispose();
            }
            this.setFloatingLayer(layer, activeLayer);
            this.updateAll();
        }
        return this.floatingLayer;
    }

    public void dropFloatingSelection() {
        Layer layer = this.getFloatingLayer();
        if (layer != null) {
            Layer under = this.floatingLayerParent;
            BufferedImage image = under.getImage();
            Graphics2D g = image.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            AffineTransform transform = layer.getTransform();
            if (transform != null) {
                g.transform(transform);
            }
            if (layer == this.previewLayer && this.previewFilter != null) {
                g.translate(this.previewOriginX, this.previewOriginY);
                g.drawImage(layer.getImage(), this.previewFilter, layer.getX(), layer.getY());
            } else {
                g.drawImage(layer.getImage(), null, layer.getX(), layer.getY());
            }
            g.dispose();
            this.update(layer);
            this.setFloatingLayer(null);
            BufferedImage selection = this.getSelection();
            g = selection.createGraphics();
            g.setComposite(AlphaComposite.Clear);
            g.fillRect(0, 0, selection.getWidth(), selection.getHeight());
            g.dispose();
            this.updateAllSelection();
            this.selectionBounds = ImageUtils.getSelectedBounds(this.documentSelection.getImage());
        }
    }

    public BufferedImage getSelectedArea(boolean merged) {
        BufferedImage image = merged ? this.getCompositeImage() : this.getActiveImage();
        BufferedImage copyImage = null;
        if (this.hasFloatingSelection()) {
            Layer layer = this.getFloatingLayer();
            Rectangle r = layer.getBounds();
            Rectangle bounds = new Rectangle();
            bounds.setRect(layer.getTransform().createTransformedShape(r).getBounds());
            copyImage = new BufferedImage(bounds.width, bounds.height, 2);
            Graphics2D g = copyImage.createGraphics();
            g.translate(-bounds.x, -bounds.y);
            g.drawRenderedImage(layer.getImage(), layer.getTransform());
            g.dispose();
        } else {
            Rectangle bounds = this.getSelectedBounds();
            if (bounds == null) {
                bounds = this.getBounds();
            }
            copyImage = ImageUtils.getSubimage(image, bounds.x, bounds.y, bounds.width, bounds.height);
            BufferedImage selection = this.getSelection();
            Graphics2D g = copyImage.createGraphics();
            g.setComposite(AlphaComposite.DstIn);
            g.drawRenderedImage(selection, AffineTransform.getTranslateInstance(-bounds.x, -bounds.y));
            g.dispose();
        }
        return copyImage;
    }

    public void clearSelection() {
        this.simplifyActiveLayer();
        if (this.hasFloatingSelection()) {
            this.update(this.getFloatingLayer());
            this.setFloatingLayer(null);
        } else {
            BufferedImage image = this.getActiveImage();
            BufferedImage selection = this.getSelection();
            Rectangle bounds = this.getSelectedBounds();
            if (bounds != null) {
                Graphics2D g = image.createGraphics();
                g.setComposite(AlphaComposite.DstOut);
                g.drawImage(selection, null, 0, 0);
                g.dispose();
                this.update(bounds);
            }
        }
    }

    public Layer pasteIntoSelection(BufferedImage image) {
        ImageLayer newLayer = new ImageLayer("Floating Selection", image);
        Rectangle bounds = this.getSelectedBounds();
        if (bounds == null) {
            bounds = this.getBounds();
        }
        newLayer.setTransform(AffineTransform.getTranslateInstance(bounds.x + (bounds.width - image.getWidth()) / 2, bounds.y + (bounds.height - image.getHeight()) / 2));
        this.dropFloatingSelection();
        this.setFloatingLayer(newLayer, this.addNewImageLayer(null));
        return newLayer;
    }

    public Layer simplifyActiveLayer() {
        return this.simplifyLayer(this.getActiveLayer());
    }

    public Layer simplifyLayer(Layer layer) {
        if (layer == null) {
            return null;
        }
        Layer newLayer = layer.simplify();
        if (layer != newLayer) {
            int index = this.layersModel.indexOf(layer);
            if (index > 0) {
                this.layersModel.setElementAt(newLayer, index);
            }
            if (layer == this.activeLayer) {
                this.activeLayer = newLayer;
            }
            if (layer == this.floatingLayer) {
                this.floatingLayer = newLayer;
            }
            if (layer == this.floatingLayerParent) {
                this.floatingLayerParent = newLayer;
            }
        }
        return newLayer;
    }

    public void filterSelection(ImageFilter filter) {
        this.startUpdate();
        this.dropFloatingSelection();
        BufferedImage selection = this.getSelection();
        this.setSelection(ImageUtils.createImage(new FilteredImageSource(selection.getSource(), filter)));
        this.updateAllSelection();
        this.endUpdate();
    }

    public void filterSelection(BufferedImageOp filter) {
        this.startUpdate();
        this.dropFloatingSelection();
        BufferedImage selection = this.getSelection();
        this.setSelection(filter.filter(selection, null));
        this.updateAllSelection();
        this.endUpdate();
    }

    public void selectionFromAlpha(Layer layer) {
        BufferedImage image = layer.getImage();
        BufferedImage selection = this.getSelection();
        this.startUpdate();
        this.dropFloatingSelection();
        new PointFilter(){

            public int filterRGB(int x, int y, int rgb) {
                return rgb & 0xFF000000;
            }
        }.filter(image, selection);
        this.updateAllSelection();
        this.endUpdate();
    }

    public void newLayerFromSelection() {
        Layer layer = this.addNewImageLayer("Selection");
        BufferedImage image = layer.getImage();
        BufferedImage selection = this.getSelection();
        this.startUpdate();
        this.dropFloatingSelection();
        new PointFilter(){

            public int filterRGB(int x, int y, int rgb) {
                return rgb & 0xFF000000;
            }
        }.filter(selection, image);
        this.updateAllSelection();
        this.updateAll();
        this.endUpdate();
    }

    public Layer layerUnder(Layer layer) {
        int index = this.layersModel.indexOf(layer);
        if (index > 0) {
            return (Layer)this.layersModel.elementAt(index - 1);
        }
        return null;
    }

    public void dropLayer(Layer layer) {
        Layer under;
        if (layer != this.floatingLayer) {
            this.dropFloatingSelection();
        }
        if (layer != null && (under = this.layerUnder(layer)) != null) {
            this.simplifyLayer(under);
            BufferedImage image = under.getImage();
            Graphics2D g = image.createGraphics();
            AffineTransform transform = layer.getTransform();
            if (transform != null) {
                g.transform(transform);
            }
            g.setComposite(layer.getComposite());
            g.drawImage(layer.getImage(), null, layer.getX(), layer.getY());
            g.dispose();
            this.removeLayer(layer);
            this.setFloatingLayer(null);
            this.updateAllSelection();
        }
    }

    public void addCompositionListener(CompositionListener l) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(l);
    }

    public void removeCompositionListener(CompositionListener l) {
        if (this.listeners != null) {
            this.listeners.removeElement(l);
        }
    }

    public void notifyListeners(CompositionEvent event) {
        if (this.listeners != null) {
            Enumeration e = this.listeners.elements();
            while (e.hasMoreElements()) {
                CompositionListener l = (CompositionListener)e.nextElement();
                l.imageChanged(event);
            }
        }
    }

    public void setCompositionListeners(Vector listeners) {
        this.listeners = listeners;
    }

    public Vector getCompositionListeners() {
        return this.listeners;
    }

    public void updateCompositeImage(Rectangle r) {
        this.updateCompositeImage(r.x, r.y, r.width, r.height);
    }

    protected void updateCompositeImage(int x, int y, int w, int h) {
        if (this.compositeImage == null) {
            this.compositeImage = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        }
        Graphics2D g = this.compositeImage.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.clipRect(x, y, w, h);
        g.setComposite(AlphaComposite.Clear);
        g.fillRect(x, y, w, h);
        if (this.documentSelection.getWidth() != this.getWidth() || this.documentSelection.getHeight() != this.getHeight()) {
            System.out.println("Selection size incorrect");
            this.documentSelection.setSize(this.getWidth(), this.getHeight());
        }
        if (this.floatingLayer != null != (this.floatingLayerParent != null)) {
            System.out.println("Bad floating layer");
        }
        if (this.drawSelectionOnly) {
            g.drawImage(this.documentSelection.getImage(), null, this.documentSelection.getX(), this.documentSelection.getY());
            return;
        }
        boolean first = true;
        Enumeration e = this.layers.elements();
        while (e.hasMoreElements()) {
            Layer layer = (Layer)e.nextElement();
            if (!layer.isVisible()) continue;
            Rectangle r = layer.getBounds();
            int operation = first ? 1 : layer.getOperation();
            AffineTransform transform = layer.getTransform();
            AffineTransform savedTransform = g.getTransform();
            if (transform != null) {
                g.transform(transform);
            }
            g.setComposite(layer.getComposite());
            if (layer == this.floatingLayerParent && this.floatingLayer != null) {
                BufferedImage tmp = new BufferedImage(w, h, 2);
                Graphics2D tg = tmp.createGraphics();
                tg.translate(-x, -y);
                tg.drawImage(this.floatingLayerParent.getImage(), null, 0, 0);
                if (this.floatingLayer.isVisible()) {
                    if (this.floatingLayer == this.previewLayer && this.previewFilter != null) {
                        tg.translate(this.previewOriginX, this.previewOriginY);
                        tg.drawRenderedImage(this.filteredLayer(this.floatingLayer, this.previewFilter, true), this.floatingLayer.getTransform());
                        tg.translate(-this.previewOriginX, -this.previewOriginY);
                    } else {
                        tg.drawRenderedImage(this.floatingLayer.getImage(), this.floatingLayer.getTransform());
                    }
                }
                tg.dispose();
                g.drawImage((Image)tmp, r.x + x, r.y + y, Application.getInstance().getFrame());
            } else if (layer == this.previewLayer && this.previewFilter != null) {
                g.drawImage(this.filteredLayer(this.previewLayer, this.previewFilter, false), null, r.x, r.y);
            } else {
                g.drawImage(layer.getImage(), null, r.x, r.y);
            }
            g.setTransform(savedTransform);
            first = false;
        }
        g.dispose();
    }

    public BufferedImage filteredLayer(Layer sourceLayer, Object filter, boolean wholeImage) {
        BufferedImage newImage;
        BufferedImage sourceImage = null;
        BufferedImage selection = this.getSelection();
        Rectangle bounds = sourceLayer.getBounds();
        sourceImage = sourceLayer.getImage();
        if (!wholeImage && (bounds = this.getSelectedBounds()) == null) {
            bounds = sourceLayer.getBounds();
            wholeImage = true;
        }
        BufferedImage imageToFilter = wholeImage ? sourceImage : ImageUtils.getSubimage(sourceImage, bounds.x, bounds.y, bounds.width, bounds.height);
        if (filter instanceof BufferedImageOp) {
            newImage = ((BufferedImageOp)filter).filter(imageToFilter, null);
        } else if (filter instanceof RasterOp) {
            newImage = new BufferedImage(imageToFilter.getWidth(), imageToFilter.getHeight(), imageToFilter.getType());
            ((RasterOp)filter).filter(imageToFilter.getRaster(), newImage.getRaster());
        } else {
            FilteredImageSource producer = new FilteredImageSource(imageToFilter.getSource(), (ImageFilter)filter);
            newImage = ImageUtils.createImage(producer);
        }
        Rectangle newBounds = new Rectangle(newImage.getWidth(), newImage.getHeight());
        if (wholeImage) {
            return newImage;
        }
        BufferedImage result = ImageUtils.cloneImage(sourceImage);
        WritableRaster dstRaster = result.getSubimage(bounds.x, bounds.y, bounds.width, bounds.height).getRaster();
        WritableRaster selRaster = selection.getSubimage(bounds.x, bounds.y, bounds.width, bounds.height).getRaster();
        ImageUtils.composeThroughMask(newImage.getRaster(), dstRaster, selRaster);
        return result;
    }

    public void dump() {
        System.out.println();
        System.out.println("Width: " + this.getWidth());
        System.out.println("Height: " + this.getHeight());
        System.out.println("Layers: ");
        Enumeration e = this.layers.elements();
        while (e.hasMoreElements()) {
            Layer l = (Layer)e.nextElement();
            System.out.println(" " + l);
            try {
                ImageIO.write((RenderedImage)l.getImage(), "png", new File("_" + l.getName() + ".png"));
            }
            catch (Exception exception) {}
        }
        System.out.println("Floating selection: " + this.getFloatingLayer());
        System.out.println("Floating parent: " + this.floatingLayerParent);
        System.out.println("Selection: " + this.documentSelection);
        System.out.println("Composite: " + this.compositeImage);
        try {
            if (this.floatingLayer != null) {
                ImageIO.write((RenderedImage)this.floatingLayer.getImage(), "png", new File("_floating.png"));
            }
            ImageIO.write((RenderedImage)this.documentSelection.getImage(), "png", new File("_selection.png"));
            ImageIO.write((RenderedImage)this.compositeImage, "png", new File("_composite.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.startUpdate();
        this.updateAll();
        this.endUpdate();
    }

    public Memento getLayersMemento() {
        return new LayersMemento();
    }

    public class LayersMemento
    implements Memento {
        private Vector layers;
        private Layer savedFloatingLayer;
        private Layer savedFloatingParent;
        private Layer savedDocumentSelection;
        private Layer savedActiveLayer;

        public LayersMemento() {
            this.layers = (Vector)Composition.this.getLayers().clone();
            this.savedFloatingLayer = Composition.this.floatingLayer;
            this.savedFloatingParent = Composition.this.floatingLayerParent;
            this.savedDocumentSelection = Composition.this.documentSelection;
            this.savedActiveLayer = Composition.this.activeLayer;
        }

        public void restore() {
            Vector tv = Composition.this.getLayers();
            Composition.this.setLayers(this.layers);
            this.layers = tv;
            Layer t = this.savedFloatingLayer;
            this.savedFloatingLayer = Composition.this.floatingLayer;
            Composition.this.floatingLayer = t;
            t = this.savedFloatingParent;
            this.savedFloatingParent = Composition.this.floatingLayerParent;
            Composition.this.floatingLayerParent = t;
            t = this.savedDocumentSelection;
            this.savedDocumentSelection = Composition.this.documentSelection;
            Composition.this.documentSelection = t;
            t = this.savedActiveLayer;
            this.savedActiveLayer = Composition.this.activeLayer;
            Composition.this.activeLayer = t;
            Composition.this.updateAll();
        }
    }
}

