/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.ie;

import com.jhlabs.app.GeometryUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class GrabHandle {
    public static final int NONE = 0;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int TOP = 4;
    public static final int BOTTOM = 8;
    public static final int ALL = 15;
    public static final int ROTATE = 16;
    public static final int CENTER = 32;
    public static final int SHEAR = 64;
    public static final int SQUARE = 0;
    public static final int ROUND = 1;
    public static final int HANDLE_SIZE = 7;
    public static final int HANDLE_SIZE2 = 3;
    public static final float HANDLE_SIZE25 = 4.0f;
    private static final Stroke handleStroke = new BasicStroke();
    public static final int[] EIGHT_HANDLES = new int[]{5, 6, 9, 10, 1, 2, 4, 8};
    private static final int[] CORNERS = new int[]{0, 1, 3, 2, 0};
    private static final int[] SHEAR_HANDLES = new int[]{4, 2, 8, 1};

    public static int oppositeHandle(int handle) {
        return ~handle & 0xF;
    }

    public static void drawHandle(int x, int y, Graphics g) {
        g.setColor(Color.black);
        g.fillRect(x - 3, y - 3, 7, 7);
        g.setColor(Color.white);
        g.drawRect(x - 3, y - 3, 6, 6);
    }

    public static void drawHandle(int x, int y, Graphics2D g, int style, boolean selected) {
        g.setStroke(handleStroke);
        switch (style) {
            case 0: {
                if (selected) {
                    g.drawRect(x - 3, y - 3, 6, 6);
                    break;
                }
                g.setColor(Color.black);
                g.fillRect(x - 3, y - 3, 7, 7);
                g.setColor(Color.white);
                g.drawRect(x - 3, y - 3, 6, 6);
                break;
            }
            case 1: {
                if (selected) {
                    g.drawOval(x - 3, y - 3, 6, 6);
                    break;
                }
                g.fillOval(x - 3, y - 3, 6, 6);
            }
        }
    }

    public static void drawHandles(Graphics2D g, Rectangle2D r, AffineTransform objectTransform, AffineTransform viewTransform, int numHandles) {
        Point2D.Double in = new Point2D.Double(0.0, 0.0);
        Point2D.Double out = new Point2D.Double(0.0, 0.0);
        for (int ix = 0; ix < 3; ++ix) {
            double x = r.getX() + r.getWidth() * (double)ix / 2.0;
            for (int iy = 0; iy < 3; ++iy) {
                if (ix == 1 && iy == 1) continue;
                in.x = x;
                in.y = r.getY() + r.getHeight() * (double)iy / 2.0;
                if (objectTransform != null) {
                    objectTransform.transform(in, out);
                    in.x = out.x;
                    in.y = out.y;
                }
                viewTransform.transform(in, out);
                GrabHandle.drawHandle((int)out.x, (int)out.y, g);
            }
        }
    }

    public static boolean inHandle(float x, float y, float handleX, float handleY) {
        return -4.0f <= (x -= handleX) && x <= 4.0f && -4.0f <= (y -= handleY) && y <= 4.0f;
    }

    public static int findHandle(int mx, int my, Rectangle2D r, AffineTransform objectTransform, AffineTransform viewTransform, int numHandles) {
        Point2D.Float in = new Point2D.Float(0.0f, 0.0f);
        Point2D.Float out = new Point2D.Float(0.0f, 0.0f);
        for (int ix = 0; ix < 3; ++ix) {
            float x = (float)(r.getX() + r.getWidth() * (double)ix / 2.0);
            for (int iy = 0; iy < 3; ++iy) {
                if (ix == 1 && iy == 1) continue;
                in.x = x;
                in.y = (float)(r.getY() + r.getHeight() * (double)iy / 2.0);
                if (objectTransform != null) {
                    objectTransform.transform(in, out);
                    in.x = out.x;
                    in.y = out.y;
                }
                viewTransform.transform(in, out);
                if (!GrabHandle.inHandle(mx, my, out.x, out.y)) continue;
                int h = 0;
                if (ix == 0) {
                    h |= 1;
                } else if (ix == 2) {
                    h |= 2;
                }
                if (iy == 0) {
                    h |= 4;
                } else if (iy == 2) {
                    h |= 8;
                }
                return h;
            }
        }
        in.x = mx;
        in.y = my;
        try {
            viewTransform.inverseTransform(in, out);
        }
        catch (NoninvertibleTransformException e) {
            // empty catch block
        }
        if (objectTransform != null) {
            try {
                objectTransform.inverseTransform(out, out);
            }
            catch (NoninvertibleTransformException e) {
                // empty catch block
            }
        }
        Point2D.Double p1 = new Point2D.Double();
        Point2D.Double p2 = new Point2D.Double();
        for (int i = 0; i < 4; ++i) {
            int corner1 = CORNERS[i];
            int corner2 = CORNERS[i + 1];
            p1.x = (corner1 & 1) != 0 ? r.getMaxX() : r.getMinX();
            p1.y = (corner1 & 2) != 0 ? r.getMaxY() : r.getMinY();
            p2.x = (corner2 & 1) != 0 ? r.getMaxX() : r.getMinX();
            double d = p2.y = (corner2 & 2) != 0 ? r.getMaxY() : r.getMinY();
            if (objectTransform != null) {
                objectTransform.transform(p1, p1);
                objectTransform.transform(p2, p2);
            }
            viewTransform.transform(p1, p1);
            viewTransform.transform(p2, p2);
            if (!GeometryUtils.pointNearLine(mx, my, p1.x, p1.y, p2.x, p2.y, 4.0)) continue;
            return SHEAR_HANDLES[i] | 0x40;
        }
        if (r.contains(out.x, out.y)) {
            return 15;
        }
        return 0;
    }

    public static void moveHandle(int handle, double dx, double dy, Rectangle2D r) {
        double minX = r.getMinX();
        double minY = r.getMinY();
        double maxX = r.getMaxX();
        double maxY = r.getMaxY();
        if ((handle & 1) != 0) {
            minX += dx;
        }
        if ((handle & 2) != 0) {
            maxX += dx;
        }
        if ((handle & 4) != 0) {
            minY += dy;
        }
        if ((handle & 8) != 0) {
            maxY += dy;
        }
        r.setFrame(minX, minY, maxX - minX, maxY - minY);
    }

    public static Point2D getHandle(int handle, Rectangle2D r) {
        double x = 0.0;
        double y = 0.0;
        x = (handle & 1) != 0 ? r.getMinX() : ((handle & 2) != 0 ? r.getMaxX() : (r.getMinX() + r.getMaxX()) / 2.0);
        y = (handle & 4) != 0 ? r.getMinY() : ((handle & 8) != 0 ? r.getMaxY() : (r.getMinY() + r.getMaxY()) / 2.0);
        return new Point2D.Double(x, y);
    }

    public static void setHandle(int handle, double x, double y, Rectangle2D r) {
        double x1 = r.getMinX();
        double y1 = r.getMinY();
        double x2 = r.getMaxX();
        double y2 = r.getMaxY();
        if ((handle & 1) != 0) {
            x1 = x;
        } else if ((handle & 2) != 0) {
            x2 = x;
        }
        if ((handle & 4) != 0) {
            y1 = y;
        } else if ((handle & 8) != 0) {
            y2 = y;
        }
        r.setFrameFromDiagonal(x1, y1, x2, y2);
    }
}

