/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.ie.tool;

import com.jhlabs.composite.MiscComposite;
import com.jhlabs.ie.Composition;
import com.jhlabs.ie.CompositionApplication;
import com.jhlabs.ie.CompositionDocument;
import com.jhlabs.ie.DrawingTask;
import com.jhlabs.ie.ImageTool;
import com.jhlabs.ie.tool.GradientToolCustomizer;
import com.jhlabs.paint.ExtendedGradientPaint;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;

public class GradientTool
extends ImageTool {
    private boolean useColormap;
    private boolean repeat;
    private int type;
    private int interpolation = 0;
    private int composite = 0;

    public void setUseColormap(boolean useColormap) {
        this.useColormap = useColormap;
    }

    public boolean getUseColormap() {
        return this.useColormap;
    }

    public void setRepeat(boolean repeat) {
        this.repeat = repeat;
    }

    public boolean getRepeat() {
        return this.repeat;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public void setInterpolation(int interpolation) {
        this.interpolation = interpolation;
    }

    public int getInterpolation() {
        return this.interpolation;
    }

    public void setComposite(int composite) {
        this.composite = composite;
    }

    public int getComposite() {
        return this.composite;
    }

    public void doDrag(boolean erase) {
        this.graphics.drawLine(this.startX, this.startY, this.currX, this.currY);
    }

    public void doEndDrag() {
        CompositionDocument document = this.view.getDocument();
        Composition composition = this.view.getComposition();
        Rectangle r = composition.getSelectedOrCompositionBounds();
        if (r == null) {
            r = composition.getBounds();
        }
        ExtendedGradientPaint paint = new ExtendedGradientPaint(new Point(this.view.XTox(this.startX) - r.x, this.view.YToy(this.startY) - r.y), new Point(this.view.XTox(this.currX) - r.x, this.view.YToy(this.currY) - r.y), this.view.getFgColor(), this.view.getBgColor(), this.repeat ^ this.event.isShiftDown(), this.type, this.interpolation);
        if (this.useColormap) {
            paint.setColormap(((CompositionApplication)document.getApplication()).getColormap());
        }
        this.view.doTask(new Task(this.view.getComposition(), paint, MiscComposite.getInstance(this.composite, 1.0f)));
    }

    public boolean hasCustomizer() {
        return true;
    }

    public Component getCustomizer() {
        return new GradientToolCustomizer();
    }

    public char getShortcutKey() {
        return 'g';
    }

    public String getToolTipText() {
        return "Gradient Tool";
    }

    public String getHelpText() {
        return "Gradient Tool: Shift cycles gradient";
    }

    class Task
    extends DrawingTask {
        private Paint paint;
        private Composite composite;

        public Task(Composition composition, Paint paint, Composite composite) {
            super(composition);
            this.paint = paint;
            this.composite = composite;
        }

        public void doDrawing(Graphics2D g) {
            Rectangle r = this.composition.getSelectedOrCompositionBounds();
            if (r == null) {
                r = this.composition.getBounds();
            }
            g.setPaint(this.paint);
            g.fill(r);
        }

        public void doTask() {
            Rectangle r = this.composition.getSelectedOrCompositionBounds();
            if (r == null) {
                r = this.composition.getBounds();
            }
            this.doTask(r, this.composite);
        }
    }
}

