/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.ie.tool;

import com.jhlabs.ie.tool.DrawShapeTool;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;

public class OvalTool
extends DrawShapeTool {
    private boolean fill;
    private boolean ellipse;

    public OvalTool() {
        this(true);
    }

    public OvalTool(boolean fill) {
        this.fill = fill;
    }

    public boolean doStartDrag() {
        this.ellipse = !this.event.isMetaDown();
        return super.doStartDrag();
    }

    public void doDrag(boolean erase) {
        if (!erase) {
            boolean bl = this.ellipse = !this.event.isMetaDown();
        }
        if (this.ellipse) {
            this.graphics.drawOval(Math.min(this.startX, this.currX), Math.min(this.startY, this.currY), Math.abs(this.startX - this.currX), Math.abs(this.startY - this.currY));
        } else {
            double dx = this.startX - this.currX;
            double dy = this.startY - this.currY;
            int r = (int)Math.sqrt(dx * dx + dy * dy);
            this.graphics.drawOval(this.startX - r, this.startY - r, 2 * r, 2 * r);
        }
    }

    public Shape makeShape() {
        int cy;
        int cx;
        int b;
        int a;
        boolean bl = this.ellipse = !this.event.isMetaDown();
        if (this.ellipse) {
            Rectangle r = this.getRectangle();
            a = r.width / 2;
            b = r.height / 2;
            cx = r.x + a;
            cy = r.y + b;
        } else {
            int radius;
            cx = this.view.XTox(this.startX);
            cy = this.view.YToy(this.startY);
            int x1 = this.view.XTox(this.currX);
            int y1 = this.view.YToy(this.currY);
            double dx = x1 - cx;
            double dy = y1 - cy;
            a = b = (radius = (int)Math.sqrt(dx * dx + dy * dy));
        }
        return new Ellipse2D.Float(cx - a, cy - b, 2 * a + 1, 2 * b + 1);
    }

    public String getToolTipText() {
        return "Circle Tool";
    }

    public String getHelpText() {
        return "Circle Tool: Meta key picks color, Shift key fills, Control key draws an ellipse, Meta key draws a Circle";
    }
}

