/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.ie.ui;

import com.jhlabs.app.Application;
import com.jhlabs.app.NumericDocument;
import com.jhlabs.app.NumericTextField;
import com.jhlabs.ie.Palette;
import com.jhlabs.image.PaintingContext;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class RGBColorChooser
extends JPanel
implements Palette,
DocumentListener,
ActionListener,
PropertyChangeListener {
    public static final int DECIMAL255 = 0;
    public static final int HEX255 = 1;
    public static final int FLOAT1 = 2;
    private JTextField red;
    private JTextField green;
    private JTextField blue;
    private boolean updating;
    private int mode = 0;
    private JPopupMenu menu;
    private JMenuItem decimalItem;
    private JMenuItem hexItem;
    private JMenuItem floatItem;
    private static final Font SMALL_FONT = new Font("dialog", 0, 9);

    public RGBColorChooser() {
        this.setLayout(new FlowLayout(1, 0, 0));
        this.add(new JLabel("R:"));
        this.red = new NumericTextField(3, 0, false, false, false);
        this.add(this.red);
        this.add(new JLabel("G:"));
        this.green = new NumericTextField(3, 0, false, false, false);
        this.add(this.green);
        this.add(new JLabel("B:"));
        this.blue = new NumericTextField(3, 0, false, false, false);
        this.add(this.blue);
        this.red.getDocument().addDocumentListener(this);
        this.green.getDocument().addDocumentListener(this);
        this.blue.getDocument().addDocumentListener(this);
        int count = this.getComponentCount();
        for (int i = 0; i < count; ++i) {
            this.getComponent(i).setFont(SMALL_FONT);
        }
        this.menu = new JPopupMenu("Mode");
        this.decimalItem = new JMenuItem("Decimal 0-255");
        this.menu.add(this.decimalItem);
        this.decimalItem.addActionListener(this);
        this.hexItem = new JMenuItem("Hex 0-FF");
        this.menu.add(this.hexItem);
        this.hexItem.addActionListener(this);
        this.floatItem = new JMenuItem("0.0-1.0");
        this.menu.add(this.floatItem);
        this.floatItem.addActionListener(this);
        this.addMouseListener(new MousePopupListener());
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.decimalItem) {
            this.setMode(0);
        } else if (source == this.hexItem) {
            this.setMode(1);
        } else if (source == this.floatItem) {
            this.setMode(2);
        }
    }

    public void setMode(int mode) {
        if (mode != this.mode) {
            this.mode = mode;
            this.setupDocument(this.red, mode);
            this.setupDocument(this.green, mode);
            this.setupDocument(this.blue, mode);
            this.setColor(PaintingContext.getInstance().getFgColor());
        }
    }

    public void setupDocument(JTextField text, int mode) {
        NumericDocument document = (NumericDocument)text.getDocument();
        switch (mode) {
            default: {
                document.setup(3, false, false, false, false);
                break;
            }
            case 1: {
                document.setup(2, false, false, false, true);
                break;
            }
            case 2: {
                document.setup(4, false, true, false, false);
            }
        }
    }

    public void setColor(int rgb) {
        if (!this.updating) {
            String bText;
            String gText;
            String rText;
            int r = rgb >> 16 & 0xFF;
            int g = rgb >> 8 & 0xFF;
            int b = rgb & 0xFF;
            switch (this.mode) {
                default: {
                    rText = Integer.toString(r);
                    gText = Integer.toString(g);
                    bText = Integer.toString(b);
                    break;
                }
                case 1: {
                    rText = Integer.toHexString(r);
                    gText = Integer.toHexString(g);
                    bText = Integer.toHexString(b);
                    break;
                }
                case 2: {
                    rText = Float.toString((float)r / 255.0f);
                    gText = Float.toString((float)g / 255.0f);
                    bText = Float.toString((float)b / 255.0f);
                }
            }
            this.red.setText(rText);
            this.green.setText(gText);
            this.blue.setText(bText);
        }
    }

    public void insertUpdate(DocumentEvent e) {
        this.textValueChanged(e);
    }

    public void removeUpdate(DocumentEvent e) {
        this.textValueChanged(e);
    }

    public void changedUpdate(DocumentEvent e) {
        this.textValueChanged(e);
    }

    public void textValueChanged(DocumentEvent event) {
        int r = this.getValue(this.red);
        int g = this.getValue(this.green);
        int b = this.getValue(this.blue);
        this.updating = true;
        PaintingContext.getInstance().setFgColor(0xFF000000 | r << 16 | g << 8 | b);
        this.updating = false;
    }

    public int getValue(JTextField f) {
        try {
            int v;
            String text = f.getText();
            switch (this.mode) {
                default: {
                    v = Integer.parseInt(text);
                    break;
                }
                case 1: {
                    v = Integer.parseInt(text, 16);
                    break;
                }
                case 2: {
                    v = (int)(Float.parseFloat(text) * 255.0f);
                }
            }
            if (v < 0) {
                v = 0;
            } else if (v > 255) {
                v = 255;
            }
            return v;
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public void startup(Application application) {
        PaintingContext.getInstance().addPropertyChangeListener(this);
    }

    public void shutdown() {
    }

    public void propertyChange(PropertyChangeEvent event) {
        String name = event.getPropertyName();
        if ("fgColor".equals(name)) {
            Color c = (Color)event.getNewValue();
            this.setColor(c.getRGB());
        }
    }

    public String getName() {
        return "showRGBColors";
    }

    class MousePopupListener
    extends MouseAdapter {
        MousePopupListener() {
        }

        public void mousePressed(MouseEvent e) {
            this.checkPopup(e);
        }

        public void mouseClicked(MouseEvent e) {
            this.checkPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.checkPopup(e);
        }

        private void checkPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                RGBColorChooser.this.menu.show(RGBColorChooser.this, e.getX(), e.getY());
            }
        }
    }
}

