/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.AbstractBufferedImageOp;
import com.jhlabs.image.BoxBlurFilter;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class BlurTransition
extends AbstractBufferedImageOp {
    private float transition = 0.0f;
    private int hRadius = 100;
    private int vRadius = 100;
    private BufferedImage destination;

    public void setTransition(float transition) {
        this.transition = transition;
    }

    public float getTransition() {
        return this.transition;
    }

    public void setDestination(BufferedImage destination) {
        this.destination = destination;
    }

    public BufferedImage getDestination() {
        return this.destination;
    }

    public void setHRadius(int hRadius) {
        this.hRadius = hRadius;
    }

    public int getHRadius() {
        return this.hRadius;
    }

    public void setVRadius(int vRadius) {
        this.vRadius = vRadius;
    }

    public int getVRadius() {
        return this.vRadius;
    }

    public void setRadius(int radius) {
        this.hRadius = this.vRadius = radius;
    }

    public int getRadius() {
        return this.hRadius;
    }

    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        if (dst == null) {
            dst = this.createCompatibleDestImage(src, null);
        }
        if (this.destination == null) {
            return dst;
        }
        float itransition = 1.0f - this.transition;
        Graphics2D g = dst.createGraphics();
        if (this.transition != 1.0f) {
            g.drawImage(src, new BoxBlurFilter((int)(this.transition * (float)this.hRadius), (int)(this.transition * (float)this.vRadius), 2), 0, 0);
        }
        g.setComposite(AlphaComposite.getInstance(3, this.transition));
        g.drawImage(this.destination, new BoxBlurFilter((int)(itransition * (float)this.hRadius), (int)(itransition * (float)this.vRadius), 2), 0, 0);
        g.dispose();
        return dst;
    }

    public String toString() {
        return "Transitions/Blur...";
    }
}

