/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.beans.PropertySheet;
import com.jhlabs.image.FilterCustomizer;
import com.jhlabs.image.ImageSample;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PreviewFilterCustomizer
extends FilterCustomizer
implements ChangeListener {
    protected Object filter;
    protected ImageSample after;
    protected BufferedImage previewImage;
    protected PropertySheet propertySheet;
    public static boolean showPreviews = true;
    public static boolean previewWholeImage = false;

    public PreviewFilterCustomizer() {
        this((PropertySheet)null, false);
    }

    public PreviewFilterCustomizer(PropertySheet propertySheet, boolean hasPreview) {
        this.setLayout(new BorderLayout(8, 8));
        if (showPreviews) {
            JPanel p = new JPanel();
            this.add((Component)p, "North");
            this.addBefore(p);
            this.addCenter(p);
            if (hasPreview) {
                this.addAfter(p);
            }
        }
        this.propertySheet = propertySheet;
        if (propertySheet != null) {
            propertySheet.addChangeListener(this);
            JScrollPane scrollPane = new JScrollPane(propertySheet);
            scrollPane.setHorizontalScrollBarPolicy(31);
            scrollPane.setVerticalScrollBarPolicy(20);
            scrollPane.setBorder(null);
            this.add((Component)scrollPane, "Center");
        }
    }

    public PropertySheet getPropertySheet() {
        return this.propertySheet;
    }

    protected void addBefore(Container c) {
    }

    protected void addCenter(Container c) {
    }

    protected void addAfter(Container c) {
        this.after = new ImageSample();
        c.add(this.after);
    }

    public void setObject(Object o) {
        super.setObject(o);
        this.filter = o;
        if (this.propertySheet != null) {
            this.propertySheet.setObject(o);
        }
        if (this.propertySheet == null) {
            this.preview();
        }
    }

    public boolean previewWholeImage() {
        return previewWholeImage;
    }

    public Dimension getPreviewSize() {
        if (previewWholeImage && this.previewImage != null) {
            return new Dimension(this.previewImage.getWidth(this), this.previewImage.getHeight(this));
        }
        return new Dimension(256, 128);
    }

    public void setPreviewImage(BufferedImage image) {
        this.previewImage = image;
    }

    public void setBackgroundImage(Image image) {
        if (this.after != null) {
            this.after.setBackgroundImage(image);
        }
    }

    public void busyCursor(boolean busy) {
        Graphics g;
        if (busy && this.after != null && (g = this.after.getGraphics()) != null) {
            g.setColor(Color.red);
            g.drawLine(0, 0, 1000, 1000);
            g.dispose();
        }
    }

    public void stateChanged(ChangeEvent e) {
        this.preview();
    }

    public void preview() {
        if (this.support != null) {
            this.support.firePropertyChange("Image", null, null);
        }
        if (showPreviews && this.previewImage != null) {
            this.busyCursor(true);
            if (this.after != null && this.filter != null) {
                if (this.filter instanceof ImageFilter) {
                    Image image = this.createImage(new FilteredImageSource(this.previewImage.getSource(), (ImageFilter)this.filter));
                    MediaTracker tracker = new MediaTracker(this);
                    tracker.addImage(image, 0);
                    try {
                        tracker.waitForID(0);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    tracker.removeImage(image, 0);
                    this.after.setImage(image);
                } else if (this.filter instanceof BufferedImageOp) {
                    this.after.setImage(((BufferedImageOp)this.filter).filter(this.previewImage, null));
                }
            }
            this.busyCursor(false);
        }
    }
}

