/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.dcr;

import it.tidalwave.imageio.dcr.DCRMetadata;
import it.tidalwave.imageio.dcr.DCRRasterReader;
import it.tidalwave.imageio.dcr.KodakMakerNote;
import it.tidalwave.imageio.raw.RasterReader;
import it.tidalwave.imageio.tiff.IFD;
import it.tidalwave.imageio.tiff.TIFFImageReaderSupport;
import it.tidalwave.imageio.tiff.TIFFMetadataSupport;
import it.tidalwave.imageio.util.Logger;
import java.awt.image.WritableRaster;
import java.io.IOException;
import javax.imageio.spi.ImageReaderSpi;

public class DCRImageReader
extends TIFFImageReaderSupport {
    private static final Logger logger = Logger.getLogger("it.tidalwave.imageio.dcr.DCRImageReader");

    protected DCRImageReader(ImageReaderSpi originatingProvider, Object extension) {
        super(originatingProvider, KodakMakerNote.class, DCRMetadata.class);
    }

    protected WritableRaster loadRAWRaster() throws IOException {
        logger.fine("loadRAWRaster() - iis: %s", this.iis);
        long time = System.currentTimeMillis();
        DCRRasterReader rasterReader = new DCRRasterReader();
        this.initializeRasterReader(rasterReader);
        logger.finest(">>>> using rasterReader: %s", rasterReader);
        IFD primaryIFD = (IFD)this.primaryDirectory;
        this.iis.seek(primaryIFD.getStripOffsets());
        WritableRaster raster = rasterReader.loadRaster(this.iis, this);
        logger.finer(">>>> loadRAWRaster() completed ok in %d msec", System.currentTimeMillis() - time);
        return raster;
    }

    protected void initializeRasterReader(RasterReader rasterReader) {
        IFD primaryIFD = (IFD)this.primaryDirectory;
        IFD exifIFD = (IFD)primaryIFD.getNamedDirectory("EXIF");
        IFD rasterIFD = ((TIFFMetadataSupport)this.metadata).getRasterIFD();
        int bitsPerSample = primaryIFD.getBitsPerSample()[0];
        int width = rasterIFD.getImageWidth();
        int height = rasterIFD.getImageLength();
        rasterReader.setWidth(width);
        rasterReader.setHeight(height);
        rasterReader.setBitsPerSample(bitsPerSample);
        rasterReader.setCFAPattern(((DCRMetadata)this.metadata).getRasterIFD().getCFAPattern());
        rasterReader.setCompression(primaryIFD.getCompression().intValue());
        if (primaryIFD.isStripByteCountsAvailable()) {
            rasterReader.setStripByteCount(primaryIFD.getStripByteCounts());
        }
        if (primaryIFD.isTileWidthAvailable()) {
            int tileWidth = primaryIFD.getTileWidth();
            int tileLength = primaryIFD.getTileLength();
            rasterReader.setTileWidth(tileWidth);
            rasterReader.setTileHeight(tileLength);
            rasterReader.setTilesAcross((width + tileWidth - 1) / tileWidth);
            rasterReader.setTilesDown((height + tileLength - 1) / tileLength);
            rasterReader.setTileOffsets(primaryIFD.getTileOffsets());
        }
        if (primaryIFD.isLinearizationTableAvailable()) {
            rasterReader.setLinearizationTable(primaryIFD.getLinearizationTable());
        }
    }
}

