/*
 * Decompiled with CFR 0.152.
 */
package quicktime;

import quicktime.QTException;
import quicktime.QTRuntimeHandler;
import quicktime.QTSession;
import quicktime.util.QTBuild;

public class QTRuntimeException
extends RuntimeException {
    private static QTRuntimeHandler handler;
    private int eCode = 0;
    private Exception exception = null;

    public static void handleOrThrow(QTRuntimeException qTRuntimeException, Object object, String string) {
        if (handler == null) {
            throw qTRuntimeException;
        }
        boolean bl = qTRuntimeException.errorCode() == -108;
        handler.exceptionOccurred(qTRuntimeException, object, string, bl);
    }

    public static void registerHandler(QTRuntimeHandler qTRuntimeHandler) {
        handler = qTRuntimeHandler;
    }

    public QTRuntimeException(QTException qTException) {
        this(qTException.errorCode());
        this.exception = qTException;
    }

    public QTRuntimeException(Exception exception) {
        this(exception.toString());
        this.exception = exception;
    }

    public QTRuntimeException(int n) {
        this(new Integer(n).toString());
        this.eCode = n;
    }

    public QTRuntimeException(String string) {
        super(string);
    }

    public final int errorCode() {
        return this.eCode;
    }

    public final Exception getException() {
        return this.exception;
    }

    public String errorCodeToString() {
        return QTException.errorCodeToString(this.eCode);
    }

    public String toString() {
        String string = this.eCode == 0 ? this.getMessage() : Integer.toString(this.eCode) + "=" + this.errorCodeToString();
        return this.getClass().getName() + QTBuild.info() + string + ",QT.vers:" + Integer.toHexString(QTSession.getQTVersion());
    }
}

