/*
 * Decompiled with CFR 0.152.
 */
package quicktime.app.event;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.app.event.EventDispatcher;
import quicktime.app.event.QTMouseController;
import quicktime.app.event.QTMouseEvent;
import quicktime.app.event.QTMouseTargetController;
import quicktime.app.spaces.Space;

public class AWTMouseEventDispatcher
extends EventDispatcher
implements MouseListener,
MouseMotionListener {
    private QTMouseEvent theEvent;
    private boolean addedButtonForEE;
    private boolean addedMouseMoveForEE;
    private boolean addedMouseMoveForTarget;
    private boolean addedButtonForTarget;
    protected Space space;
    protected QTMouseController cont;
    protected Component comp;
    private boolean hasMouseListener = false;
    private boolean hasMMotionListener = false;

    public AWTMouseEventDispatcher(QTMouseController qTMouseController, Space space, Object object) {
        this.comp = (Component)object;
        this.cont = qTMouseController;
        this.space = space;
    }

    protected void addedTo() {
        if (this.theEvent == null) {
            this.theEvent = new QTMouseEvent(this.space);
        }
    }

    protected void removedFrom() {
        this.comp.removeMouseListener(this);
        this.comp.removeMouseMotionListener(this);
        this.comp = null;
        this.theEvent = null;
        this.hasMouseListener = false;
        this.hasMMotionListener = false;
    }

    private void addAWTMouseListener() {
        if (!this.hasMouseListener) {
            this.comp.addMouseListener(this);
            this.hasMouseListener = true;
        }
    }

    private void addAllAWTMouseListeners() {
        this.addAWTMouseListener();
        if (!this.hasMMotionListener) {
            this.comp.addMouseMotionListener(this);
            this.hasMMotionListener = true;
        }
    }

    private void removeAWTMouseListener() {
        if (this.cont.hasMouseButtonListener()) {
            return;
        }
        if (this.cont.hasMouseMoveListener()) {
            return;
        }
        if (this.cont.hasMouseEnterExitListener()) {
            return;
        }
        if (this.cont instanceof QTMouseTargetController && ((QTMouseTargetController)this.cont).hasMouseTargetListener()) {
            return;
        }
        this.comp.removeMouseListener(this);
        this.hasMouseListener = false;
    }

    private void removeAWTMouseMotionListener() {
        if (this.cont.hasMouseMoveListener()) {
            return;
        }
        if (this.cont.hasMouseEnterExitListener()) {
            return;
        }
        if (this.cont instanceof QTMouseTargetController && ((QTMouseTargetController)this.cont).hasMouseTargetListener()) {
            return;
        }
        this.comp.removeMouseMotionListener(this);
        this.hasMMotionListener = false;
    }

    void addMouseButtonListener() {
        this.addAWTMouseListener();
    }

    void removeMouseButtonListener() {
        this.removeAWTMouseListener();
    }

    void addMouseMoveListener() {
        this.addAllAWTMouseListeners();
    }

    void removeMouseMoveListener() {
        this.removeAWTMouseListener();
        this.removeAWTMouseMotionListener();
    }

    void addMouseEnterExitListener() {
        this.addAllAWTMouseListeners();
    }

    void removeMouseEnterExitListener() {
        this.removeAWTMouseListener();
        this.removeAWTMouseMotionListener();
    }

    void addMouseTargetListener() {
        this.addAllAWTMouseListeners();
    }

    void removeMouseTargetListener() {
        this.removeAWTMouseListener();
        this.removeAWTMouseMotionListener();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.theEvent.initialiseEventProfile(500, mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getClickCount());
        this.cont.mouseClicked(this.theEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.theEvent.initialiseEventProfile(501, mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getClickCount());
        this.cont.mousePressed(this.theEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.theEvent.initialiseEventProfile(502, mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getClickCount());
        this.cont.mouseReleased(this.theEvent);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.theEvent.initialiseEventProfile(504, mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getClickCount());
        this.cont.mouseEntered(this.theEvent);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.theEvent.initialiseEventProfile(505, mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getClickCount());
        this.cont.mouseExited(this.theEvent);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.theEvent.initialiseEventProfile(506, mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getClickCount());
        this.cont.mouseDragged(this.theEvent);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.theEvent.initialiseEventProfile(503, mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getClickCount());
        this.cont.mouseMoved(this.theEvent);
    }

    static {
        if (QTSession.isCurrentOS(4) && QTSession.getJavaVersion() >= 65540) {
            throw new QTRuntimeException("Unsupported on Mac OS X and Java 1.4 and higher.");
        }
    }
}

