/*
 * Decompiled with CFR 0.152.
 */
package quicktime.app.sg;

import java.awt.Dimension;
import quicktime.QTException;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.app.display.QTDrawable;
import quicktime.app.sg.SGCaptureCallback;
import quicktime.app.time.TaskThread;
import quicktime.app.time.Tasking;
import quicktime.jdirect.QTNative;
import quicktime.qd.QDDimension;
import quicktime.qd.QDGraphics;
import quicktime.qd.QDRect;
import quicktime.qd.Region;
import quicktime.std.StdQTException;
import quicktime.std.image.Matrix;
import quicktime.std.sg.SGVideoChannel;
import quicktime.std.sg.SequenceGrabber;

public class SGDrawer
extends Tasking
implements QTDrawable {
    private static TaskThread sgTasker;
    private SGVideoChannel chan;
    private boolean deferTasking = false;
    private SGCaptureCallback stopTimeCallback;

    public SGDrawer(SGVideoChannel sGVideoChannel) throws QTException {
        this.chan = sGVideoChannel;
        this.setDefaultTasker(sgTasker);
    }

    public SGVideoChannel getSGChannel() {
        return this.chan;
    }

    public SequenceGrabber getSequenceGrabber() {
        return this.chan.getSequenceGrabber();
    }

    public void addedTo(Object object) {
    }

    public void removedFrom(Object object) {
    }

    public QDGraphics getGWorld() throws StdQTException {
        return this.chan.getSequenceGrabber().getGWorld();
    }

    public synchronized void setGWorld(QDGraphics qDGraphics) throws QTException {
        this.chan.getSequenceGrabber().setGWorld(qDGraphics, null);
        if (!QDGraphics.scratch.equals(qDGraphics)) {
            this.deferTasking = true;
        } else {
            this.stopTasking();
            this.chan.getSequenceGrabber().stop();
        }
    }

    public Dimension getInitialSize() throws QTException {
        QDRect qDRect = this.chan.getBounds();
        Matrix matrix = this.chan.getMatrix();
        return new Dimension((int)((float)qDRect.getWidth() / matrix.getSx()), (int)((float)qDRect.getHeight() / matrix.getSy()));
    }

    public QDDimension getOriginalSize() throws QTException {
        QDRect qDRect = this.chan.getBounds();
        Matrix matrix = this.chan.getMatrix();
        return new QDDimension((float)qDRect.getWidth() / matrix.getSx(), (float)qDRect.getHeight() / matrix.getSy());
    }

    public Matrix getMatrix() throws StdQTException {
        return this.chan.getMatrix();
    }

    public void setMatrix(Matrix matrix) throws QTException {
        this.chan.setMatrix(matrix);
    }

    public synchronized void setDisplayBounds(QDRect qDRect) throws StdQTException {
        this.chan.setBounds(qDRect);
        if (this.deferTasking) {
            this.deferTasking = false;
            this.startTasking();
        }
    }

    public void setLocation(int n, int n2) throws QTException {
        QDRect qDRect = this.getDisplayBounds();
        qDRect.setX(n);
        qDRect.setY(n2);
        this.setDisplayBounds(qDRect);
    }

    public QDRect getDisplayBounds() throws StdQTException {
        return this.chan.getBounds();
    }

    public final synchronized void redraw(Region region) throws StdQTException {
        this.chan.getSequenceGrabber().update(region);
    }

    public Region getClip() throws QTException {
        return this.chan.getClip();
    }

    public void setClip(Region region) throws StdQTException {
        this.chan.setClip(region);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void task() throws StdQTException {
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (!this.chan.getSequenceGrabber().idleMore()) {
                this.stopTasking();
                this.chan.getSequenceGrabber().stop();
                if (this.stopTimeCallback != null) {
                    new Thread(new Runnable(){

                        public void run() {
                            SGDrawer.this.stopTimeCallback.finish(SGDrawer.this);
                        }
                    }).start();
                }
            }
        }
    }

    public void setSGCaptureCallback(SGCaptureCallback sGCaptureCallback) {
        this.stopTimeCallback = sGCaptureCallback;
    }

    public SGCaptureCallback getSGCaptureCallback() {
        return this.stopTimeCallback;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.chan + "]";
    }

    static {
        if (QTSession.isCurrentOS(4) && QTSession.getJavaVersion() >= 65540) {
            throw new QTRuntimeException("Unsupported on Mac OS X and Java 1.4 and higher.");
        }
        sgTasker = new TaskThread("Default SG Tasker", 20);
    }
}

