/*
 * Decompiled with CFR 0.152.
 */
package quicktime.streaming;

import quicktime.QTException;
import quicktime.QTObject;
import quicktime.QTSession;
import quicktime.streaming.EditList;
import quicktime.streaming.MediaParams;
import quicktime.streaming.StreamDispatcher;
import quicktime.streaming.StreamNotifyProc;
import quicktime.util.QTPointerRef;

public final class PresParams
extends QTPointerRef {
    public static final int kNativeSize = 28;
    private MediaParams myMediaParams = null;
    private EditList editList = null;
    private StreamDispatcher notifyUPP;

    PresParams() throws QTException {
        super(28, true);
    }

    public PresParams(int n, int n2, MediaParams mediaParams) throws QTException {
        super(28, true);
        this.setVersion(1);
        this.setEditList(null);
        this.setFlags(n2);
        this.setTimeScale(n);
        this.setMediaParams(mediaParams);
    }

    public int getVersion() {
        return this.getIntAt(0);
    }

    public int getFlags() {
        return this.getIntAt(8);
    }

    public int getTimeScale() {
        return this.getIntAt(12);
    }

    public void setVersion(int n) {
        this.setIntAt(0, n);
    }

    public void setFlags(int n) {
        this.setIntAt(8, n);
    }

    public void setTimeScale(int n) {
        this.setIntAt(12, n);
    }

    public void setMediaParams(MediaParams mediaParams) {
        this.setIntAt(16, QTObject.ID(mediaParams));
        this.myMediaParams = mediaParams;
    }

    public MediaParams getMediaParams() {
        return this.myMediaParams;
    }

    public void setEditList(EditList editList) {
        this.setIntAt(4, QTObject.ID(editList));
        this.editList = editList;
    }

    public EditList getEditList() {
        return this.editList;
    }

    public void setNotificationProc(StreamNotifyProc streamNotifyProc) {
        if (streamNotifyProc == null) {
            this.removeNotificationProc();
        } else {
            this.notifyUPP = new StreamDispatcher(streamNotifyProc);
            this.setIntAt(20, this.notifyUPP.ID());
        }
    }

    public void removeNotificationProc() {
        this.setIntAt(20, 0);
        this.notifyUPP.cleanup();
        this.notifyUPP = null;
    }

    public String toString() {
        return this.getClass().getName() + "[version=" + this.getVersion() + ",editList=" + this.getEditList() + ",flags=" + this.getFlags() + ",timeScale" + this.getTimeScale() + ",mediaParams=" + this.getMediaParams() + "]";
    }

    static {
        if (QTSession.hasSecurityRestrictions()) {
            throw new SecurityException("Only able to broadcast with security settings when class is signed");
        }
        if (QTSession.isCurrentOS(2)) {
            throw new RuntimeException("The broadcaster API is not supported on windows");
        }
    }
}

