/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.ImageExtensionFileFilter;
import GUI.ImageNumericTextField;
import WaterMarker.RescaleImage;
import WatermarkHelper.ImagePreviewPanel;
import WatermarkHelper.WaterMarkHelper;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ImageGUI
extends JFrame {
    WaterMarkHelper imageHelper;
    File watermarkImage = null;
    boolean isUpdate = false;
    int updateIndex;
    private JLabel ImagePanel;
    private JButton jButton1;
    private JButton jButton3;
    private JButton jButton4;
    private JComboBox jComboBox1;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel HspaceLabel;
    private JLabel VspaceLabel;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel7;
    private JSlider jSlider1;
    private JSlider jSlider2;
    private JTextField jTextField1;
    private JTextField jTextField2;
    private JTextField jTextField3;
    private JTextField jTextField4;
    private JTextField jTextField5;
    private JTextField HSpaceTextField;
    private JTextField VSpaceTextField;
    private JTextField jTextField8;
    private JFileChooser jFileChooser1;

    public ImageGUI(WaterMarkHelper helper, boolean Update, int Index) {
        this.imageHelper = helper;
        this.imageHelper.getMainStatus().setText(this.imageHelper.getProperty("message.image.open"));
        this.isUpdate = Update;
        this.updateIndex = Index;
        this.initComponents();
    }

    public ImageGUI(WaterMarkHelper helper) {
        this.imageHelper = helper;
        this.imageHelper.getMainStatus().setText(this.imageHelper.getProperty("message.image.open"));
        this.initComponents();
    }

    private void initComponents() {
        this.jTextField2 = new ImageNumericTextField();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jPanel7 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jButton1 = new JButton();
        this.jTextField1 = new JTextField();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jSlider1 = new JSlider();
        this.jSlider2 = new JSlider();
        this.jTextField3 = new JTextField();
        this.jTextField8 = new JTextField();
        this.jPanel3 = new JPanel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.HspaceLabel = new JLabel();
        this.VspaceLabel = new JLabel();
        this.jTextField4 = new ImageNumericTextField();
        this.jTextField5 = new ImageNumericTextField();
        this.HSpaceTextField = new ImageNumericTextField();
        this.VSpaceTextField = new ImageNumericTextField();
        this.jButton4 = new JButton();
        this.jButton3 = new JButton();
        this.ImagePanel = new JLabel();
        this.setDefaultCloseOperation(0);
        this.setTitle(this.imageHelper.getProperty("title.image.gui"));
        this.setBackground(new Color(51, 51, 51));
        this.setResizable(false);
        this.setAlwaysOnTop(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                Frame frame = (Frame)evt.getSource();
                frame.dispose();
                ImageGUI.this.imageHelper.setEnable(ImageGUI.this.imageHelper.getMainFrame());
                ImageGUI.this.imageHelper.getMainStatus().setText(ImageGUI.this.imageHelper.getProperty("message.image.close"));
            }
        });
        this.jPanel1.setBackground(new Color(51, 51, 51));
        this.jLabel1.setFont(new Font("Palatino Linotype", 0, 18));
        this.jLabel1.setForeground(new Color(204, 204, 204));
        this.jLabel1.setText("Image Watermarker");
        this.jLabel2.setBackground(new Color(204, 204, 204));
        this.jLabel2.setFont(new Font("Palatino Linotype", 0, 11));
        this.jLabel2.setForeground(new Color(255, 102, 0));
        this.jLabel2.setText("[?]");
        this.jLabel2.setToolTipText(this.imageHelper.getProperty("help.image"));
        this.jPanel2.setBackground(new Color(51, 51, 51));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(new LineBorder(new Color(0, 153, 255), 1, true), "Select Image & Set Details", 0, 0, new Font("Palatino Linotype", 0, 11), new Color(0, 153, 255)));
        this.jPanel7.setBackground(new Color(51, 51, 51));
        this.jPanel7.setBorder(BorderFactory.createLineBorder(new Color(0, 153, 255)));
        this.jPanel7.setForeground(new Color(51, 51, 51));
        this.ImagePanel.setHorizontalAlignment(0);
        GroupLayout jPanel7Layout = new GroupLayout(this.jPanel7);
        this.jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ImagePanel, -1, 120, Short.MAX_VALUE));
        jPanel7Layout.setVerticalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ImagePanel, -1, 100, Short.MAX_VALUE));
        this.jLabel3.setFont(new Font("Palatino Linotype", 0, 11));
        this.jLabel3.setForeground(new Color(204, 204, 204));
        this.jLabel3.setText("Select Image");
        this.jButton1.setText("Brows");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ImageGUI.this.browsImage(evt);
            }
        });
        this.jTextField1.setText("Select Image");
        this.jTextField1.setEditable(false);
        this.jTextField1.setToolTipText("Image to be put as watermark");
        this.jTextField1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ImageGUI.this.BrowsInputImage(evt);
            }
        });
        this.jLabel4.setFont(new Font("Palatino Linotype", 0, 11));
        this.jLabel4.setForeground(new Color(204, 204, 204));
        this.jLabel4.setText("Fill");
        this.jLabel5.setFont(new Font("Palatino Linotype", 0, 11));
        this.jLabel5.setForeground(new Color(204, 204, 204));
        this.jLabel5.setText("Scale");
        this.jSlider1.setMinimum(5);
        this.jSlider1.setValue(100);
        this.jSlider1.setToolTipText("Set fill of image to be watermarked ");
        this.jSlider1.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                ImageGUI.this.imageFillChangeAction(evt);
            }
        });
        this.jSlider2.setMinimum(5);
        this.jSlider2.setValue(100);
        this.jSlider2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                ImageGUI.this.imageScaleChangeAction(evt);
            }
        });
        this.jTextField3.setText("100%");
        this.jTextField3.setToolTipText("Image Scale");
        this.jTextField3.setEditable(false);
        this.jTextField3.setToolTipText("Fill of image to be watermarked ");
        this.jTextField8.setText("100%");
        this.jTextField8.setToolTipText("Image Scale");
        this.jTextField8.setEditable(false);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel3, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel4, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel5, -2, 60, -2)).addGap(6, 6, 6).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1)).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jTextField8, GroupLayout.Alignment.LEADING).addComponent(this.jTextField3, GroupLayout.Alignment.LEADING, -2, 43, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSlider1, -1, 172, Short.MAX_VALUE).addGroup(jPanel2Layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSlider2, -1, 172, Short.MAX_VALUE)).addComponent(this.jTextField1, -1, 172, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel7, -2, -1, -2).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jButton1)).addComponent(this.jTextField1, -2, -1, -2)).addGap(12, 12, 12).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jTextField3, -2, -1, -2).addComponent(this.jLabel4)).addComponent(this.jSlider1, -2, 20, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel5).addComponent(this.jTextField8, -2, -1, -2).addComponent(this.jSlider2, -2, -1, -2))).addComponent(this.jPanel7, -2, -1, -2)).addContainerGap(10, Short.MAX_VALUE)));
        this.jPanel3.setBackground(new Color(51, 51, 51));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(new LineBorder(new Color(0, 153, 255), 1, true), "Set Position", 0, 0, new Font("Palatino Linotype", 0, 11), new Color(0, 153, 255)));
        this.jLabel8.setFont(new Font("Palatino Linotype", 0, 11));
        this.jLabel8.setForeground(new Color(204, 204, 204));
        this.jLabel8.setText("Choose Position");
        this.jLabel9.setBackground(new Color(204, 204, 204));
        this.jLabel9.setFont(new Font("Palatino Linotype", 0, 11));
        this.jLabel9.setForeground(new Color(204, 204, 204));
        this.jLabel9.setText("X");
        this.jLabel10.setFont(new Font("Palatino Linotype", 0, 11));
        this.jLabel10.setForeground(new Color(204, 204, 204));
        this.jLabel10.setText("Y");
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"Top Left", "Top Center", "Top Right", "Middle Left", "Middle Center", "Middle Right", "Bottom Left", "Bottom Center", "Bottom Right", "Coustome"}));
        this.jComboBox1.setToolTipText("Select Position of image to be Watermarked");
        this.jComboBox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ImageGUI.this.checkCoustomePositon(evt);
            }
        });
        this.HspaceLabel.setFont(new Font("Palatino Linotype", 0, 11));
        this.HspaceLabel.setForeground(new Color(204, 204, 204));
        this.HspaceLabel.setText("Space from Left Edge");
        this.VspaceLabel.setFont(new Font("Palatino Linotype", 0, 11));
        this.VspaceLabel.setForeground(new Color(204, 204, 204));
        this.VspaceLabel.setText("Space from Top Edge");
        this.jTextField4.setText("0");
        this.jTextField4.setEnabled(false);
        this.jTextField4.setToolTipText("Set X Positon of image to be watermarked");
        this.jTextField4.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                ImageGUI.this.XcheckNumber(evt);
            }
        });
        this.jTextField5.setText("0");
        this.jTextField5.setEnabled(false);
        this.jTextField5.setToolTipText("Set Y Positon of image to be watermarked");
        this.jTextField5.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                ImageGUI.this.YcheckNumber(evt);
            }
        });
        this.HSpaceTextField.setToolTipText("Set Vertical spacing (pix) from image Edge");
        this.HSpaceTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                ImageGUI.this.HspaceNumberCheck(evt);
            }
        });
        this.VSpaceTextField.setToolTipText("Set Horizontal spacing (pix) from image Edge");
        this.VSpaceTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                ImageGUI.this.VspaceNumberCheck(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel8).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel10, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel9)).addGap(33, 33, 33).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jTextField4, 0, 0, Short.MAX_VALUE).addComponent(this.jTextField5, -2, 41, -2)))).addGap(96, 96, 96).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.VspaceLabel, -1, -1, Short.MAX_VALUE).addComponent(this.HspaceLabel, -2, 198, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.VSpaceTextField).addComponent(this.HSpaceTextField, -2, 45, -2))).addComponent(this.jComboBox1, -2, 252, -2)).addContainerGap(16, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.jTextField4, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextField5, -2, -1, -2).addComponent(this.jLabel10))).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jComboBox1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.HSpaceTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.VSpaceTextField, -2, -1, -2)).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.HspaceLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.VspaceLabel))))).addContainerGap(10, Short.MAX_VALUE)));
        this.jButton4.setText("Cancel");
        this.jButton4.setToolTipText("Cancel");
        this.jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ImageGUI.this.Cancel(evt);
            }
        });
        this.jButton3.setText("Add");
        this.jButton3.setToolTipText("Add image as a watermarker");
        this.jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ImageGUI.this.AddImageWatermarker(evt);
            }
        });
        if (this.isUpdate) {
            File imagePath;
            ArrayList EditList = (ArrayList)this.imageHelper.getWaterMarkerList().get(this.updateIndex);
            this.watermarkImage = imagePath = (File)EditList.get(3);
            this.jTextField1.setText(this.watermarkImage.getPath());
            int imageScale = Integer.parseInt(EditList.get(4).toString());
            int Fill = Integer.parseInt(EditList.get(9).toString());
            String imagePosition = EditList.get(10).toString();
            String X = EditList.get(11).toString();
            String Y = EditList.get(12).toString();
            String hSpace = EditList.get(13).toString();
            String vSpace = EditList.get(14).toString();
            this.jSlider2.setValue(imageScale);
            this.jSlider1.setValue(Fill);
            this.jComboBox1.setSelectedItem(imagePosition);
            this.jTextField4.setText(X);
            this.jTextField5.setText(Y);
            this.HSpaceTextField.setText(hSpace);
            this.VSpaceTextField.setText(vSpace);
            this.jButton3.setText("Update");
            this.jTextField3.setText(EditList.get(9).toString() + "%");
            this.jTextField8.setText(EditList.get(4).toString() + "%");
            BufferedImage image = this.imageHelper.getPreview(this.watermarkImage);
            RescaleImage previewImage = new RescaleImage();
            BufferedImage result = previewImage.RescaleImage(this.imageHelper, image, 120.0, 160.0);
            ImageIcon i2i = new ImageIcon(result);
            this.ImagePanel.setIcon(i2i);
            this.jPanel7.repaint();
            this.jPanel7.revalidate();
        } else {
            this.jTextField4.setText("0");
            this.jTextField5.setText("0");
            this.HSpaceTextField.setText("0");
            this.VSpaceTextField.setText("0");
            this.jButton3.setText("Add");
            this.jTextField2.setText("100%");
            this.jTextField8.setText("100%");
        }
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addGap(132, 132, 132).addComponent(this.jLabel2))).addContainerGap()).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGap(87, 87, 87).addComponent(this.jButton3, -2, 84, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 192, Short.MAX_VALUE).addComponent(this.jButton4).addGap(77, 77, 77)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, 134, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, 104, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton4).addComponent(this.jButton3)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -2, -1, -2));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 495) / 2, (screenSize.height - 361) / 2, 495, 361);
    }

    private void BrowsInputImage(MouseEvent evt) {
        this.browsImageInput();
    }

    private void browsImage(ActionEvent evt) {
        this.browsImageInput();
    }

    public void browsImageInput() {
        this.jFileChooser1 = new JFileChooser(".");
        ImagePreviewPanel preview = new ImagePreviewPanel();
        this.jFileChooser1.setAccessory(preview);
        this.jFileChooser1.addPropertyChangeListener(preview);
        ImageExtensionFileFilter filter1 = new ImageExtensionFileFilter(this.imageHelper.getProperty("constants.jfilechooser.filter"), this.imageHelper.getImageFormats());
        this.jFileChooser1.setFileFilter(filter1);
        this.jFileChooser1.setMultiSelectionEnabled(false);
        int option = this.jFileChooser1.showOpenDialog(this);
        if (option == 0) {
            try {
                this.watermarkImage = this.jFileChooser1.getSelectedFile();
                this.jTextField1.setText(this.watermarkImage.getPath());
                BufferedImage image = this.imageHelper.getPreview(this.watermarkImage);
                RescaleImage previewImage = new RescaleImage();
                BufferedImage result = previewImage.RescaleImage(this.imageHelper, image, 90.0, 120.0);
                ImageIcon ii = new ImageIcon(result);
                this.ImagePanel.setIcon(ii);
                this.jPanel7.repaint();
                this.jPanel7.revalidate();
            }
            catch (Exception ex) {
                Logger.getLogger(ImageGUI.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void imageFillChangeAction(ChangeEvent evt) {
        this.imageHelper.sliderChangeAction(this.jSlider1, this.jTextField3);
    }

    private void imageScaleChangeAction(ChangeEvent evt) {
        this.imageHelper.sliderChangeAction(this.jSlider2, this.jTextField8);
    }

    private void checkCoustomePositon(ActionEvent evt) {
        if (this.jComboBox1.getSelectedItem().toString().equalsIgnoreCase("Coustome")) {
            this.jTextField4.setEnabled(true);
            this.jTextField5.setEnabled(true);
            this.HSpaceTextField.setEnabled(false);
            this.HSpaceTextField.setText("0");
            this.VSpaceTextField.setEnabled(false);
            this.VSpaceTextField.setText("0");
            this.HspaceLabel.setText("Not Applicable");
            this.VspaceLabel.setText("Not Applicable");
        } else {
            this.jTextField4.setEnabled(false);
            this.jTextField4.setText("0");
            this.jTextField5.setEnabled(false);
            this.jTextField5.setText("0");
            if (this.jComboBox1.getSelectedItem().toString().equalsIgnoreCase("Top Left")) {
                this.HspaceLabel.setText("Space from Left Edge");
                this.VspaceLabel.setText("Space from Top Edge");
                this.VSpaceTextField.setEnabled(true);
                this.VSpaceTextField.setText("0");
                this.HSpaceTextField.setEnabled(true);
                this.HSpaceTextField.setText("0");
            } else if (this.jComboBox1.getSelectedItem().toString().equalsIgnoreCase("Top Center")) {
                this.HspaceLabel.setText("Not Applicable");
                this.HSpaceTextField.setEnabled(false);
                this.HSpaceTextField.setText("0");
                this.VspaceLabel.setText("Space from Top Edge");
                this.VSpaceTextField.setEnabled(true);
                this.VSpaceTextField.setText("0");
            } else if (this.jComboBox1.getSelectedItem().toString().equalsIgnoreCase("Top Right")) {
                this.HspaceLabel.setText("Space from Right Edge");
                this.HSpaceTextField.setEnabled(true);
                this.HSpaceTextField.setText("0");
                this.VspaceLabel.setText("Space from Top Edge");
                this.VSpaceTextField.setEnabled(true);
                this.VSpaceTextField.setText("0");
            } else if (this.jComboBox1.getSelectedItem().toString().equalsIgnoreCase("Middle Left")) {
                this.HspaceLabel.setText("Space from Left Edge");
                this.HSpaceTextField.setEnabled(true);
                this.HSpaceTextField.setText("0");
                this.VspaceLabel.setText("Not Applicable");
                this.VSpaceTextField.setEnabled(false);
                this.VSpaceTextField.setText("0");
            } else if (this.jComboBox1.getSelectedItem().toString().equalsIgnoreCase("Middle Center")) {
                this.HspaceLabel.setText("Not Applicable");
                this.HSpaceTextField.setEnabled(false);
                this.HSpaceTextField.setText("0");
                this.VspaceLabel.setText("Not Applicable");
                this.VSpaceTextField.setEnabled(false);
                this.VSpaceTextField.setText("0");
            } else if (this.jComboBox1.getSelectedItem().toString().equalsIgnoreCase("Middle Right")) {
                this.HspaceLabel.setText("Space from Right Edge");
                this.HSpaceTextField.setEnabled(true);
                this.HSpaceTextField.setText("0");
                this.VspaceLabel.setText("Not Applicable");
                this.VSpaceTextField.setEnabled(false);
                this.VSpaceTextField.setText("0");
            } else if (this.jComboBox1.getSelectedItem().toString().equalsIgnoreCase("Bottom Left")) {
                this.HspaceLabel.setText("Space from Left Edge");
                this.HSpaceTextField.setEnabled(true);
                this.HSpaceTextField.setText("0");
                this.VspaceLabel.setText("Space from Bottom Edge");
                this.VSpaceTextField.setEnabled(true);
                this.VSpaceTextField.setText("0");
            } else if (this.jComboBox1.getSelectedItem().toString().equalsIgnoreCase("Bottom Center")) {
                this.HspaceLabel.setText("Not Applicable");
                this.HSpaceTextField.setEnabled(false);
                this.HSpaceTextField.setText("0");
                this.VspaceLabel.setText("Space from Bottom Edge");
                this.VSpaceTextField.setEnabled(true);
                this.VSpaceTextField.setText("0");
            } else if (this.jComboBox1.getSelectedItem().toString().equalsIgnoreCase("Bottom Right")) {
                this.HspaceLabel.setText("Space from Right Edge");
                this.HSpaceTextField.setEnabled(true);
                this.HSpaceTextField.setText("0");
                this.VspaceLabel.setText("Space from Bottom Edge");
                this.VSpaceTextField.setEnabled(true);
                this.VSpaceTextField.setText("0");
            }
        }
    }

    private void Cancel(ActionEvent evt) {
        this.dispose();
        this.imageHelper.setEnable(this.imageHelper.getMainFrame());
        this.imageHelper.getMainStatus().setText(this.imageHelper.getProperty("message.image.close"));
    }

    private void AddImageWatermarker(ActionEvent evt) {
        if (this.watermarkImage != null) {
            if (this.imageHelper.checkExtension(this.watermarkImage.getName())) {
                ArrayList<Object> imageData = new ArrayList<Object>();
                imageData.add("IMAGE");
                imageData.add(null);
                imageData.add(null);
                imageData.add(this.watermarkImage);
                imageData.add(this.jSlider2.getValue());
                imageData.add(null);
                imageData.add(null);
                imageData.add(null);
                imageData.add(null);
                imageData.add(this.jSlider1.getValue());
                imageData.add(this.jComboBox1.getSelectedItem().toString());
                imageData.add(this.jTextField4.getText());
                imageData.add(this.jTextField5.getText());
                imageData.add(this.HSpaceTextField.getText());
                imageData.add(this.VSpaceTextField.getText());
                if (this.isUpdate) {
                    this.imageHelper.getWaterMarkerList().set(this.updateIndex, imageData);
                    this.imageHelper.Info("Updating Image Watermarker at Index:" + this.updateIndex + " with Parameters List: " + imageData);
                } else {
                    this.imageHelper.getWaterMarkerList().add(imageData);
                    this.imageHelper.Info("Adding Image Watermarker with Parameters List: " + imageData);
                }
                this.dispose();
                this.imageHelper.setEnable(this.imageHelper.getMainFrame());
                this.imageHelper.getMainWaterMarksDetails().removeAll();
                this.imageHelper.setWaterMarkDetails();
                this.imageHelper.getMainStatus().setText(this.imageHelper.getProperty("message.image.success"));
            } else {
                JOptionPane.showMessageDialog(this.jPanel1, this.imageHelper.getProperty("message.warning.imageFilter"));
            }
        } else {
            JOptionPane.showMessageDialog(this.jPanel1, this.imageHelper.getProperty("message.warning.selectImage"));
        }
    }

    private void XcheckNumber(FocusEvent evt) {
        this.imageHelper.checkNumber(this.jTextField4);
    }

    private void YcheckNumber(FocusEvent evt) {
        this.imageHelper.checkNumber(this.jTextField5);
    }

    private void HspaceNumberCheck(FocusEvent evt) {
        this.imageHelper.checkNumber(this.HSpaceTextField);
    }

    private void VspaceNumberCheck(FocusEvent evt) {
        this.imageHelper.checkNumber(this.VSpaceTextField);
    }
}

