/*
 * Decompiled with CFR 0.152.
 */
package WatermarkHelper;

import WatermarkHelper.JFontPreviewPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class JFontChooser
extends JComponent
implements ActionListener,
ListSelectionListener {
    private Font font;
    private JList fontNames;
    private JList fontSizes;
    private JList fontStyles;
    private JTextField currentSize;
    private JButton okay;
    private JButton cancel;
    private Font[] availableFonts;
    private JFontPreviewPanel preview;
    private JDialog dialog;
    private int returnValue;
    public static final int ERROR_OPTION = 0;
    public static final int ACCEPT_OPTION = 2;
    public static final int CANCEL_OPTION = 4;

    public JFontChooser(Font font) {
        this.font = font;
        this.setup();
    }

    private void setup() {
        int i;
        this.setLayout(new BorderLayout());
        Font[] fontList = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        Vector<Font> fonts = new Vector<Font>(1, 1);
        Vector<String> names = new Vector<String>(1, 1);
        for (i = 0; i < fontList.length; ++i) {
            String fontName = fontList[i].getFamily();
            if (names.contains(fontName)) continue;
            names.addElement(fontName);
            fonts.addElement(fontList[i]);
        }
        this.availableFonts = new Font[fonts.size()];
        for (i = 0; i < fonts.size(); ++i) {
            this.availableFonts[i] = (Font)fonts.elementAt(i);
        }
        this.fontNames = new JList(names);
        JScrollPane fontNamesScroll = new JScrollPane(this.fontNames);
        this.fontNames.addListSelectionListener(this);
        Object[] styles = new Object[]{"Regular", "Bold", "Italic", "BoldItalic"};
        this.fontStyles = new JList<Object>(styles);
        JScrollPane fontStylesScroll = new JScrollPane(this.fontStyles);
        this.fontStyles.setSelectedIndex(0);
        this.fontStyles.addListSelectionListener(this);
        String[] sizes = new String[69];
        for (int i2 = 3; i2 < 72; ++i2) {
            sizes[i2 - 3] = new Integer(i2 + 1).toString();
        }
        this.fontSizes = new JList<String>(sizes);
        JScrollPane fontSizesScroll = new JScrollPane(this.fontSizes);
        this.fontSizes.addListSelectionListener(this);
        this.currentSize = new JTextField(5);
        this.currentSize.setText(new Integer(this.font.getSize()).toString());
        this.currentSize.addActionListener(this);
        GridBagLayout g2 = new GridBagLayout();
        GridBagConstraints c2 = new GridBagConstraints();
        JPanel sizePane = new JPanel(g2);
        c2.gridx = 0;
        c2.gridy = 0;
        c2.insets = new Insets(2, 5, 2, 5);
        c2.anchor = 17;
        sizePane.add(this.currentSize);
        g2.setConstraints(this.currentSize, c2);
        sizePane.add(fontSizesScroll);
        ++c2.gridy;
        c2.fill = 2;
        g2.setConstraints(fontSizesScroll, c2);
        this.preview = new JFontPreviewPanel(this.font);
        this.okay = new JButton("OK");
        this.okay.addActionListener(this);
        this.cancel = new JButton("Cancel");
        this.cancel.addActionListener(this);
        GridBagLayout g = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JPanel top = new JPanel(g);
        c.anchor = 17;
        c.fill = 3;
        c.insets = new Insets(2, 5, 2, 5);
        c.gridx = 0;
        c.gridy = 0;
        top.add(fontNamesScroll);
        g.setConstraints(fontNamesScroll, c);
        ++c.gridx;
        top.add(fontStylesScroll);
        g.setConstraints(fontStylesScroll, c);
        ++c.gridx;
        top.add(sizePane);
        g.setConstraints(sizePane, c);
        this.add("North", top);
        this.add("Center", this.preview);
        JPanel buttons = new JPanel(new FlowLayout(2));
        buttons.add(this.okay);
        buttons.add(this.cancel);
        this.add("South", buttons);
        this.fontSizes.setSelectedValue(new Integer(this.font.getSize()).toString(), true);
        this.fontNames.setSelectedValue(this.font.getFamily(), true);
        if (this.font.getStyle() == 0) {
            this.fontStyles.setSelectedValue("Regular", false);
        } else if (this.font.getStyle() == 2) {
            this.fontStyles.setSelectedValue("Italic", false);
        } else if (this.font.getStyle() == 1) {
            this.fontStyles.setSelectedValue("Bold", false);
        } else if (this.font.getStyle() == 3) {
            this.fontStyles.setSelectedValue("BoldItalic", false);
        }
    }

    private void updateFont(Font f) {
        this.font = f;
        this.preview.setFont(this.font);
    }

    private void updateFontSize(int size) {
        this.updateFont(this.font.deriveFont(new Integer(size).floatValue()));
    }

    private void updateFontStyle(int style) {
        this.updateFont(this.font.deriveFont(style));
    }

    public Font getSelectedFont() {
        return this.font;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okay) {
            this.returnValue = 2;
            if (this.dialog != null) {
                this.dialog.setVisible(false);
            }
            this.acceptSelection();
        }
        if (e.getSource() == this.cancel) {
            this.returnValue = 4;
            if (this.dialog != null) {
                this.dialog.setVisible(false);
            }
            this.cancelSelection();
        }
        if (e.getSource() == this.currentSize) {
            this.fontSizes.setSelectedValue(this.currentSize.getText(), true);
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() == this.fontNames) {
            Font f = this.availableFonts[this.fontNames.getSelectedIndex()];
            f = new Font(f.getFontName(), this.font.getStyle(), this.font.getSize());
            this.updateFont(f);
        }
        if (e.getSource() == this.fontSizes) {
            this.currentSize.setText((String)this.fontSizes.getSelectedValue());
            this.updateFontSize(new Integer(this.currentSize.getText()));
        }
        if (e.getSource() == this.fontStyles) {
            int style = 0;
            String selection = (String)this.fontStyles.getSelectedValue();
            if (selection.equals("Regular")) {
                style = 0;
            }
            if (selection.equals("Bold")) {
                style = 1;
            }
            if (selection.equals("Italic")) {
                style = 2;
            }
            if (selection.equals("BoldItalic")) {
                style = 3;
            }
            this.updateFontStyle(style);
        }
    }

    public int showDialog(Component parent, String title) {
        this.returnValue = 0;
        Frame frame = parent instanceof Frame ? (Frame)parent : (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent);
        this.dialog = new JDialog(frame, title, true);
        this.dialog.getContentPane().add("Center", this);
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(parent);
        this.dialog.show();
        return this.returnValue;
    }

    public void acceptSelection() {
    }

    public void cancelSelection() {
    }
}

