/*
 * Decompiled with CFR 0.152.
 */
package jdomain.jdraw.action;

import jdomain.jdraw.action.BlockingDrawAction;
import jdomain.jdraw.data.Frame;
import jdomain.jdraw.data.Palette;
import jdomain.jdraw.gui.ColourEditor;
import jdomain.jdraw.gui.Tool;

public final class EditColourAction
extends BlockingDrawAction {
    private static final long serialVersionUID = 1L;
    private ColourEditor editor;
    private int colIndex;

    protected EditColourAction() {
        super("Edit Colour...");
        this.setToolTipText("Edits the current foreground colour");
    }

    public boolean prepareAction() {
        this.editor = ColourEditor.INSTANCE;
        Frame frame = Tool.getCurrentFrame();
        Palette palette = frame.getPalette();
        this.colIndex = Tool.getPicture().getForeground();
        this.editor.setColour(palette.getColour(this.colIndex).getColour());
        this.editor.open();
        return this.editor.getResult() == 1;
    }

    public void startAction() {
        Tool.getCurrentFrame().getPalette().setColour(this.colIndex, this.editor.getColour());
    }

    public void finishAction() {
    }
}

