/*
 * Decompiled with CFR 0.152.
 */
package jdomain.jdraw.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import jdomain.jdraw.data.Frame;
import jdomain.jdraw.data.Palette;
import jdomain.jdraw.data.event.ChangeEvent;
import jdomain.jdraw.gui.DrawLayers;
import jdomain.jdraw.gui.DrawPanel;
import jdomain.jdraw.gui.FloatingClip;
import jdomain.jdraw.gui.PreviewPanel;
import jdomain.jdraw.gui.Tool;
import jdomain.util.ResourceLoader;
import jdomain.util.gui.BackgroundPanel;

public final class FramePanel
extends BackgroundPanel {
    private static final long serialVersionUID = 1L;
    public static final boolean SHOW_PATTERN = true;
    public static final boolean SHOW_COLOUR = false;
    private static boolean transparencyMode = true;
    private Frame frame;
    private final DrawLayers layeredPane = new DrawLayers();
    private final JScrollPane scrollPane = new JScrollPane(this.layeredPane);

    public FramePanel() {
        super(new BorderLayout(0, 0));
        this.setBackground(Color.white);
        this.add((Component)this.scrollPane, "Center");
        this.setOpaque(true);
        this.setBackgroundIcon(ResourceLoader.getImage("jdomain/jdraw/images/background.gif"));
        this.scrollPane.setOpaque(false);
        this.scrollPane.getViewport().setOpaque(false);
    }

    protected void repaintFrame(int n, int n2, int n3, int n4) {
        Tool.getDrawPanel().repaint(n, n2, n3, n4);
    }

    protected void addClip(FloatingClip floatingClip) {
        this.layeredPane.add((Component)floatingClip, floatingClip.getLayer());
    }

    protected void removeClip(FloatingClip floatingClip) {
        this.layeredPane.remove(floatingClip);
    }

    protected void repaintFrame() {
        Tool.getDrawPanel().repaint();
    }

    public void changeMainBackground(ChangeEvent changeEvent) {
        this.setBackground(Tool.getCurrentPalette().getColour(changeEvent.getNewInt()).getColour());
    }

    protected void revalidateFrame() {
        this.setVisible(false);
        Palette palette = this.frame.getPalette();
        Color color = this.scrollPane.getViewport().getBackground();
        if (this.frame.getTransparentColour() != -1) {
            color = palette.getColour(this.frame.getTransparentColour()).getColour();
        }
        this.setBackground(color);
        this.invalidate();
        this.revalidate();
        JComponent jComponent = (JComponent)this.getParent();
        if (jComponent != null) {
            jComponent.revalidate();
        }
        this.setVisible(true);
        PreviewPanel.INSTANCE.setVisible(false);
        PreviewPanel.INSTANCE.revalidate();
        PreviewPanel.INSTANCE.setVisible(true);
    }

    protected DrawPanel getDrawPanel() {
        return this.layeredPane.getDrawPanel();
    }

    protected int getGrid() {
        return Tool.getGrid();
    }

    protected JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public void toggleTransparencyMode() {
        transparencyMode = !transparencyMode;
        this.showBackgroundIcon(transparencyMode);
        this.setBackground(this.frame.getPalette().getColour(Tool.getPicture().getPictureBackground()).getColour());
    }

    public boolean getTransparencyMode() {
        return transparencyMode;
    }

    public void changeClipData(ChangeEvent changeEvent) {
        if (this.isShowing()) {
            this.revalidateFrame();
        }
    }

    public void changePixel(ChangeEvent changeEvent) {
        if (this.isShowing()) {
            int n = this.getGrid();
            this.repaintFrame(changeEvent.getX() * n, changeEvent.getY() * n, n, n);
            PreviewPanel.INSTANCE.repaint(changeEvent.getX(), changeEvent.getY(), 1, 1);
        }
    }

    public void changeNeedsRepaint(ChangeEvent changeEvent) {
        if (this.isShowing()) {
            this.repaintFrame();
            PreviewPanel.INSTANCE.repaint();
        }
    }

    public void setFrame(Frame frame) {
        this.frame = frame;
        this.layeredPane.setDrawClip(this.frame);
    }

    protected void transparentColourChanged() {
        int n = this.frame.getTransparentColour();
        Color color = n == -1 ? Color.black : this.frame.getPalette().getColour(n).getColour();
        this.setBackground(color);
    }

    public DrawLayers getLayeredPane() {
        return this.layeredPane;
    }
}

