/*
 * Decompiled with CFR 0.152.
 */
package fi.iki.jka;

import fi.iki.jka.JPhoto;
import fi.iki.jka.JPhotoList;
import fi.iki.jka.Utils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public class JPhotoPanel
extends JPanel
implements ListCellRenderer {
    public static final int NO_DROP = 0;
    public static final int DROP_BEFORE = 1;
    public static final int DROP_AFTER = 2;
    protected JPhoto photo = null;
    protected boolean hasFocus = false;
    protected boolean selected = false;
    protected boolean fullView = false;
    protected boolean showtext = false;
    protected int showDrop = 0;
    protected BufferedImage fullImage = null;
    protected Font font = new Font("SansSerif", 1, 12);
    protected String watermark = "";

    public JPhotoPanel() {
        this.setBackground(Color.black);
        this.repaint(0L, 0, 0, this.getWidth(), this.getHeight());
    }

    public JPhotoPanel(boolean fullView) {
        this();
        this.fullView = fullView;
    }

    public JPhotoPanel(String photoName) {
        this();
        this.setPhoto(new JPhoto(new File(photoName)));
    }

    public void setPhoto(JPhoto photo) {
        if (photo != this.photo) {
            this.fullImage = null;
        }
        this.photo = photo;
        this.repaint(0L, 0, 0, this.getWidth(), this.getHeight());
    }

    public JPhoto getPhoto() {
        return this.photo;
    }

    public void setSelected(boolean val) {
        this.selected = val;
    }

    public void setHasFocus(boolean val) {
        this.hasFocus = val;
    }

    public void setFullView(boolean val) {
        this.fullView = val;
    }

    public void setShowtext(boolean val) {
        this.showtext = val;
    }

    public void setWatermark(String mark) {
        this.watermark = mark;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void paint(Graphics g) {
        int cellWidth = this.getWidth();
        int cellHeight = this.getHeight();
        Graphics2D g2 = (Graphics2D)g;
        g2.setBackground(this.getBackground());
        if (this.fullView) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, cellWidth, cellHeight);
        } else if (this.hasFocus || this.selected) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, cellWidth, cellHeight);
            g.setColor(Color.blue);
            if (this.showDrop != 0) {
                if (this.showDrop == 1) {
                    g.fillRect(1, 1, 8, cellHeight - 1);
                } else {
                    g.fillRect(cellWidth - 8, 1, cellWidth - 1, cellHeight - 1);
                }
            } else {
                if (this.selected) {
                    g.fillRect(0, 0, cellWidth - 1, cellHeight - 1);
                }
                if (this.hasFocus) {
                    g.setColor(Color.gray);
                    g.drawRect(0, 0, cellWidth - 1, cellHeight - 1);
                }
            }
        }
        if (this.photo == null) {
            return;
        }
        Dimension limits = new Dimension(cellWidth, cellHeight);
        if (this.fullView) {
            if (this.fullImage == null) {
                this.fullImage = this.photo.getFullImage();
            }
            if (this.fullImage != null && this.fullImage.getHeight(this) > 0) {
                int w = this.fullImage.getWidth(this);
                int h = this.fullImage.getHeight(this);
                Dimension dim = Utils.getScaledSize(limits, w, h);
                int x = (cellWidth - dim.width) / 2;
                int y = (cellHeight - dim.height) / 2;
                g.drawImage(this.fullImage, x, y, dim.width, dim.height, this);
                g.setColor(this.getForeground());
                g.setFont(this.photo.getWatermarkFont());
                Utils.drawWrappedText(g2, x, -(y + dim.height), dim.width, this.watermark);
            } else {
                g.setColor(this.getForeground());
                Utils.drawWrappedText(g2, 1.0f, 1.0f, this.getWidth(), this.photo.getStatus());
            }
            if (this.photo.getText() != null && (this.showtext || this.photo.getOriginalName() == null)) {
                g.setFont(this.font);
                g.setColor(this.getForeground());
                Utils.drawWrappedText(g2, 1.0f, -(this.getHeight() - 1), this.getWidth(), this.photo.getText());
            }
        } else {
            String text;
            int x;
            BufferedImage thumbImage = this.photo.getThumbImageAsync();
            if (thumbImage != null) {
                int w = thumbImage.getWidth();
                int h = thumbImage.getHeight();
                Dimension dim = Utils.getScaledSize(limits, w, h);
                x = (cellWidth - dim.width) / 2;
                int y = (cellHeight - dim.height) / 2;
                g.drawImage(thumbImage, x, y, dim.width, dim.height, this);
                if (this.photo.getAlbumLink() != null) {
                    g.setColor(Color.blue);
                    g.drawRect(x, y, w - 1, h - 1);
                    g.drawRect(x + 1, y + 1, w - 3, h - 3);
                    g.setColor(this.getForeground());
                }
            } else {
                g.setFont(this.font);
                g.setColor(this.getForeground());
                Utils.drawWrappedText(g2, 1.0f, 20.0f, this.getWidth(), this.photo.getStatus());
            }
            g.setFont(this.font);
            g.setColor(this.getForeground());
            if (this.photo.getAlbumLink() != null) {
                String name = "[Link to " + this.photo.getAlbumLink() + "]";
                Utils.drawWrappedText(g2, 1.0f, 2.0f, this.getWidth() - 2, name);
            }
            if (this.selected) {
                g.setColor(Color.white);
            }
            if ((text = this.photo.getText()) != null && !text.equals("")) {
                if (thumbImage == null) {
                    Utils.drawWrappedText(g2, 1.0f, -this.getHeight(), this.getWidth() - 2, text);
                } else {
                    FontMetrics fm = g.getFontMetrics();
                    int margin = cellWidth - fm.stringWidth("...") - 3;
                    x = 0;
                    int i = 0;
                    while (i < text.length()) {
                        if ((x += fm.charWidth(text.charAt(i))) > margin) break;
                        ++i;
                    }
                    if (i < text.length()) {
                        text = String.valueOf(text.substring(0, i)) + "...";
                    }
                    g.drawString(text, 3, cellHeight - 3);
                }
            } else {
                g.drawString(this.photo.getImageName(), 3, cellHeight - 3);
            }
        }
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JPhotoList photolist = (JPhotoList)list;
        int dragbegin = photolist.getDragBegin();
        this.showDrop = dragbegin >= 0 ? (dragbegin > index ? 1 : 2) : 0;
        this.setSelected(isSelected);
        this.setHasFocus(cellHasFocus);
        this.setPhoto((JPhoto)value);
        return this;
    }

    public static void main(String[] args) {
        JFrame[] frames = new JFrame[args.length];
        int i = 0;
        while (i < args.length) {
            frames[i] = new JFrame(args[i]);
            Container picPane = frames[i].getContentPane();
            JPhotoPanel selected = new JPhotoPanel(args[i]);
            selected.setFullView(true);
            picPane.add(selected);
            frames[i].setDefaultCloseOperation(3);
            frames[i].setSize(700, 700);
            frames[i].setLocation(20 * i, 20 * i);
            frames[i].show();
            ++i;
        }
    }
}

