/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.dtx;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.HashMap;
import java.util.Properties;
import org.exolab.castor.dtx.DTXException;
import org.exolab.castor.dtx.DTXQuery;
import org.exolab.castor.jdo.conf.DataSource;
import org.exolab.castor.jdo.conf.Database;
import org.exolab.castor.jdo.conf.Driver;
import org.exolab.castor.jdo.conf.Mapping;
import org.exolab.castor.jdo.conf.Param;
import org.exolab.castor.mapping.xml.ClassMapping;
import org.exolab.castor.mapping.xml.MappingRoot;
import org.exolab.castor.persist.PersistenceFactoryRegistry;
import org.exolab.castor.persist.spi.PersistenceFactory;
import org.exolab.castor.util.DTDResolver;
import org.exolab.castor.util.Logger;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.reader.SchemaReader;
import org.xml.sax.DocumentHandler;
import org.xml.sax.InputSource;

public class DTXEngine {
    protected DocumentHandler _handler = null;
    protected String _databaseURL = null;
    protected PrintWriter _logWriter = Logger.getSystemLogger();
    protected Database _database = null;
    protected String _schemaURL = null;
    protected Schema _schema = null;
    protected HashMap _classMappings = null;
    protected Connection _conn = null;
    protected PersistenceFactory _factory = null;
    static /* synthetic */ Class class$org$exolab$castor$jdo$conf$Database;
    static /* synthetic */ Class class$org$exolab$castor$mapping$xml$MappingRoot;

    public DTXEngine() {
    }

    public DTXEngine(String string, String string2) throws DTXException {
        this.setDatabase(string);
        this.setSchema(string2);
    }

    public void setSchema(String string) throws DTXException {
        this._schemaURL = string;
        try {
            SchemaReader schemaReader = new SchemaReader(new InputSource(new URL(string).openStream()));
            this._schema = schemaReader.read();
        }
        catch (IOException iOException) {
            throw new DTXException(iOException);
        }
        catch (Exception exception) {
            throw new DTXException(exception);
        }
    }

    public void setDatabase(String string) throws DTXException {
        this._databaseURL = string;
        Unmarshaller unmarshaller = new Unmarshaller(class$org$exolab$castor$jdo$conf$Database == null ? (class$org$exolab$castor$jdo$conf$Database = DTXEngine.class$("org.exolab.castor.jdo.conf.Database")) : class$org$exolab$castor$jdo$conf$Database);
        unmarshaller.setEntityResolver(new DTDResolver());
        if (this._logWriter != null) {
            unmarshaller.setLogWriter(this._logWriter);
        }
        try {
            this._database = (Database)unmarshaller.unmarshal(new InputSource(new URL(string).openStream()));
        }
        catch (Exception exception) {
            throw new DTXException(exception);
        }
        this._factory = this._database.getEngine() == null ? PersistenceFactoryRegistry.getPersistenceFactory("generic") : PersistenceFactoryRegistry.getPersistenceFactory(this._database.getEngine());
        if (this._factory == null) {
            throw new DTXException("no engine");
        }
        this._classMappings = new HashMap();
        Unmarshaller unmarshaller2 = new Unmarshaller(class$org$exolab$castor$mapping$xml$MappingRoot == null ? (class$org$exolab$castor$mapping$xml$MappingRoot = DTXEngine.class$("org.exolab.castor.mapping.xml.MappingRoot")) : class$org$exolab$castor$mapping$xml$MappingRoot);
        if (this._logWriter != null) {
            unmarshaller2.setLogWriter(this._logWriter);
        }
        Mapping[] mappingArray = this._database.getMapping();
        int n = 0;
        while (n < mappingArray.length) {
            try {
                URL uRL = new URL(new URL(string), mappingArray[n].getHref());
                MappingRoot mappingRoot = (MappingRoot)unmarshaller2.unmarshal(new InputSource(uRL.openStream()));
                ClassMapping[] classMappingArray = mappingRoot.getClassMapping();
                int n2 = 0;
                while (n2 < classMappingArray.length) {
                    this._classMappings.put(classMappingArray[n2].getName(), classMappingArray[n2]);
                    if (this._logWriter != null) {
                        this._logWriter.println("Got class: " + classMappingArray[n2].getName());
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {
                throw new DTXException(exception);
            }
            ++n;
        }
    }

    public void setLogWriter(PrintWriter printWriter) {
        this._logWriter = printWriter;
    }

    public void setDocumentHandler(DocumentHandler documentHandler) {
        this._handler = documentHandler;
    }

    public DTXQuery prepareQuery(String string) throws DTXException {
        DTXQuery dTXQuery = new DTXQuery();
        dTXQuery.setEngine(this);
        dTXQuery.setHandler(this._handler);
        dTXQuery.setLogWriter(this._logWriter);
        dTXQuery.prepare(string);
        return dTXQuery;
    }

    Database getDatabase() {
        return this._database;
    }

    Schema getSchema() {
        return this._schema;
    }

    PersistenceFactory getFactory() {
        return this._factory;
    }

    Connection getConnection() throws DTXException {
        if (this._conn == null) {
            DataSource dataSource = this._database.getDataSource();
            Driver driver = this._database.getDriver();
            if (dataSource != null) {
                throw new DTXException("dtx.DataSourceUnimplemented");
            }
            if (driver != null) {
                try {
                    String string = driver.getClassName();
                    Class.forName(string);
                    String string2 = driver.getUrl();
                    Param[] paramArray = driver.getParam();
                    Properties properties = new Properties();
                    int n = 0;
                    while (n < paramArray.length) {
                        Param param = paramArray[n];
                        properties.setProperty(param.getName(), param.getValue());
                        ++n;
                    }
                    this._conn = DriverManager.getConnection(string2, properties);
                }
                catch (Exception exception) {
                    throw new DTXException(exception);
                }
            }
        }
        return this._conn;
    }

    ClassMapping getClassMapping(String string) {
        return (ClassMapping)this._classMappings.get(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

