/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif.test;

import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.lang.Rational;
import com.drew.metadata.Metadata;
import com.drew.metadata.exif.ExifDirectory;
import com.drew.metadata.exif.NikonType2MakernoteDirectory;
import java.io.File;
import junit.framework.TestCase;

public class NikonType2MakernoteTest
extends TestCase {
    private NikonType2MakernoteDirectory _nikonDirectory;
    private ExifDirectory _exifDirectory;
    static /* synthetic */ Class class$com$drew$metadata$exif$NikonType2MakernoteDirectory;
    static /* synthetic */ Class class$com$drew$metadata$exif$ExifDirectory;

    public NikonType2MakernoteTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        File file = new File("src/com/drew/metadata/exif/test/nikonMakernoteType2.jpg");
        Metadata metadata = JpegMetadataReader.readMetadata(file);
        this._nikonDirectory = (NikonType2MakernoteDirectory)metadata.getDirectory(class$com$drew$metadata$exif$NikonType2MakernoteDirectory == null ? (class$com$drew$metadata$exif$NikonType2MakernoteDirectory = NikonType2MakernoteTest.class$("com.drew.metadata.exif.NikonType2MakernoteDirectory")) : class$com$drew$metadata$exif$NikonType2MakernoteDirectory);
        this._exifDirectory = (ExifDirectory)metadata.getDirectory(class$com$drew$metadata$exif$ExifDirectory == null ? (class$com$drew$metadata$exif$ExifDirectory = NikonType2MakernoteTest.class$("com.drew.metadata.exif.ExifDirectory")) : class$com$drew$metadata$exif$ExifDirectory);
    }

    public void testNikonMakernote_MatchesKnownValues() throws Exception {
        NikonType2MakernoteTest.assertEquals((String)"", (String)this._nikonDirectory.getString(1));
        NikonType2MakernoteTest.assertEquals((String)"0 0", (String)this._nikonDirectory.getString(2));
        NikonType2MakernoteTest.assertEquals((String)"COLOR", (String)this._nikonDirectory.getString(3));
        NikonType2MakernoteTest.assertEquals((String)"NORMAL ", (String)this._nikonDirectory.getString(4));
        NikonType2MakernoteTest.assertEquals((String)"AUTO        ", (String)this._nikonDirectory.getString(5));
        NikonType2MakernoteTest.assertEquals((String)"AUTO  ", (String)this._nikonDirectory.getString(6));
        NikonType2MakernoteTest.assertEquals((String)"AF-C  ", (String)this._nikonDirectory.getString(7));
        NikonType2MakernoteTest.assertEquals((String)"NORMAL      ", (String)this._nikonDirectory.getString(8));
        NikonType2MakernoteTest.assertEquals((Object)new Rational(4416, 500), (Object)this._nikonDirectory.getRational(10));
        NikonType2MakernoteTest.assertEquals((String)"AUTO  ", (String)this._nikonDirectory.getString(15));
        NikonType2MakernoteTest.assertEquals((int)1300, (int)this._nikonDirectory.getInt(17));
        NikonType2MakernoteTest.assertEquals((String)"AUTO         ", (String)this._nikonDirectory.getString(128));
        NikonType2MakernoteTest.assertEquals((String)"OFF         ", (String)this._nikonDirectory.getString(130));
        NikonType2MakernoteTest.assertEquals((int)0, (int)this._nikonDirectory.getInt(133));
        NikonType2MakernoteTest.assertEquals((int)1, (int)this._nikonDirectory.getInt(134));
        NikonType2MakernoteTest.assertEquals((String)"                ", (String)this._nikonDirectory.getString(143));
        NikonType2MakernoteTest.assertEquals((int)0, (int)this._nikonDirectory.getInt(148));
        NikonType2MakernoteTest.assertEquals((String)"FPNR", (String)this._nikonDirectory.getString(149));
        NikonType2MakernoteTest.assertEquals((String)"PrintIM", (String)this._nikonDirectory.getString(3584));
        NikonType2MakernoteTest.assertEquals((int)1394, (int)this._nikonDirectory.getInt(3600));
    }

    public void testExifDirectory_MatchesKnownValues() throws Exception {
        NikonType2MakernoteTest.assertEquals((String)"          ", (String)this._exifDirectory.getString(270));
        NikonType2MakernoteTest.assertEquals((String)"NIKON", (String)this._exifDirectory.getString(271));
        NikonType2MakernoteTest.assertEquals((String)"E995", (String)this._exifDirectory.getString(272));
        NikonType2MakernoteTest.assertEquals((double)72.0, (double)this._exifDirectory.getDouble(282), (double)0.001);
        NikonType2MakernoteTest.assertEquals((double)72.0, (double)this._exifDirectory.getDouble(283), (double)0.001);
        NikonType2MakernoteTest.assertEquals((int)2, (int)this._exifDirectory.getInt(296));
        NikonType2MakernoteTest.assertEquals((String)"E995v1.6", (String)this._exifDirectory.getString(305));
        NikonType2MakernoteTest.assertEquals((String)"2002:08:29 17:31:40", (String)this._exifDirectory.getString(306));
        NikonType2MakernoteTest.assertEquals((int)1, (int)this._exifDirectory.getInt(531));
        NikonType2MakernoteTest.assertEquals((Object)new Rational(2439024, 100000000), (Object)this._exifDirectory.getRational(33434));
        NikonType2MakernoteTest.assertEquals((double)2.6, (double)this._exifDirectory.getDouble(33437), (double)0.001);
        NikonType2MakernoteTest.assertEquals((int)2, (int)this._exifDirectory.getInt(34850));
        NikonType2MakernoteTest.assertEquals((int)100, (int)this._exifDirectory.getInt(34855));
        NikonType2MakernoteTest.assertEquals((String)"0210", (String)this._exifDirectory.getString(36864));
        NikonType2MakernoteTest.assertEquals((String)"2002:08:29 17:31:40", (String)this._exifDirectory.getString(36868));
        NikonType2MakernoteTest.assertEquals((String)"2002:08:29 17:31:40", (String)this._exifDirectory.getString(36867));
        NikonType2MakernoteTest.assertEquals((int)197121, (int)this._exifDirectory.getInt(37121));
        NikonType2MakernoteTest.assertEquals((int)0, (int)this._exifDirectory.getInt(37380));
        NikonType2MakernoteTest.assertEquals((String)"0", (String)this._exifDirectory.getString(37381));
        NikonType2MakernoteTest.assertEquals((int)5, (int)this._exifDirectory.getInt(37383));
        NikonType2MakernoteTest.assertEquals((int)0, (int)this._exifDirectory.getInt(37384));
        NikonType2MakernoteTest.assertEquals((int)1, (int)this._exifDirectory.getInt(37385));
        NikonType2MakernoteTest.assertEquals((double)8.2, (double)this._exifDirectory.getDouble(37386), (double)0.001);
        NikonType2MakernoteTest.assertEquals((String)"", (String)this._exifDirectory.getString(37510));
        NikonType2MakernoteTest.assertEquals((String)"0100", (String)this._exifDirectory.getString(40960));
        NikonType2MakernoteTest.assertEquals((int)1, (int)this._exifDirectory.getInt(40961));
        NikonType2MakernoteTest.assertEquals((int)2048, (int)this._exifDirectory.getInt(40962));
        NikonType2MakernoteTest.assertEquals((int)1536, (int)this._exifDirectory.getInt(40963));
        NikonType2MakernoteTest.assertEquals((int)3, (int)this._exifDirectory.getInt(41728));
        NikonType2MakernoteTest.assertEquals((int)1, (int)this._exifDirectory.getInt(41729));
        NikonType2MakernoteTest.assertEquals((int)6, (int)this._exifDirectory.getInt(259));
        NikonType2MakernoteTest.assertEquals((int)1494, (int)this._exifDirectory.getInt(513));
        NikonType2MakernoteTest.assertEquals((int)6077, (int)this._exifDirectory.getInt(514));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

