/*
 * Decompiled with CFR 0.152.
 */
package pm.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import pm.gui.PM_CutPicture;
import pm.gui.PM_FocusPanel;
import pm.gui.PM_FocusTraversalPolicy;
import pm.gui.PM_IndexView;
import pm.gui.PM_ModifyExternal;
import pm.gui.PM_PictureView;
import pm.gui.PM_PictureViewDragAndDrop;
import pm.gui.PM_WindowBase;
import pm.gui.PM_WindowLeftThumbnails;
import pm.gui.PM_WindowMainMenu;
import pm.gui.PM_WindowRightTabbedPane;
import pm.gui.PM_WindowSearch;
import pm.gui.PM_WindowSlideshow;
import pm.gui.PM_WindowStatusPanel;
import pm.inout.PM_All_ExternalPrograms;
import pm.inout.PM_All_InitValues;
import pm.inout.PM_ExportDelete;
import pm.inout.PM_LogFile;
import pm.inout.PM_SequencesInout;
import pm.inout.PM_XML_File_Session;
import pm.picture.PM_MetadataContainer;
import pm.picture.PM_Picture;
import pm.print.PM_CutTempPrint;
import pm.print.PM_PicturePrint;
import pm.search.PM_DatabaseLucene;
import pm.search.PM_LuceneLists;
import pm.utilities.PM_Action;
import pm.utilities.PM_Configuration;
import pm.utilities.PM_Help;
import pm.utilities.PM_Interface;
import pm.utilities.PM_ListenerX;
import pm.utilities.PM_MSG;
import pm.utilities.PM_Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PM_WindowMain
extends JFrame
implements PM_Interface {
    private PM_WindowLeftThumbnails windowThumbnails = null;
    private PM_WindowRightTabbedPane windowRechts = null;
    private PM_WindowStatusPanel statusPanel = null;
    private PM_ModifyExternal windowExternBearbeiten;
    private PM_WindowSlideshow windowDiaShow;
    private PM_CutPicture windowZeigenOriginal;
    private JDialog dialogBildAendernDrucken = null;
    private JDialog dialogZeigenOriginal;
    private JDialog dialogDiaShow;
    private JDialog dialogExternBearbeiten;
    private JPanel gesPanel = null;
    private PM_Configuration einstellungen;
    private JSplitPane splitPane = null;
    private static PM_WindowMain instance = null;
    private PM_WindowBase justChanged = null;
    private Component focusOld = null;
    public JTextField textFieldPressed = null;
    private PM_CutTempPrint windowDruckenAendern = null;

    public PM_WindowMain() {
        String string = "Photo Manager " + PM_Utils.getPmVersion();
        this.setTitle(string);
        instance = this;
    }

    public static PM_WindowMain getInstance() {
        return instance;
    }

    public void init(PM_ListenerX pM_ListenerX) {
        Serializable serializable;
        if (pM_ListenerX != null) {
            pM_ListenerX.actionPerformed(new PM_Action("max", 8));
        }
        this.einstellungen = PM_Configuration.getInstance();
        this.windowThumbnails = new PM_WindowLeftThumbnails(this, 30);
        this.windowThumbnails.setName("windowThumbnails");
        this.statusPanel = PM_WindowStatusPanel.getInstance();
        this.windowRechts = new PM_WindowRightTabbedPane(this, pM_ListenerX);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this.windowRechts);
        this.splitPane = new JSplitPane(1, this.windowThumbnails, this.windowRechts);
        int n = PM_All_InitValues.getInstance().getValueInt(this, "vertical-devider");
        if (n == 0) {
            n = 500;
        }
        this.splitPane.setDividerLocation(n);
        this.splitPane.setOneTouchExpandable(true);
        PM_WindowMainMenu pM_WindowMainMenu = new PM_WindowMainMenu(this);
        this.setJMenuBar(pM_WindowMainMenu.getMenuBar());
        this.statusPanel.init();
        this.gesPanel = new JPanel();
        this.gesPanel.setLayout(new BorderLayout());
        this.gesPanel.add((Component)this.splitPane, "Center");
        this.gesPanel.add((Component)this.statusPanel, "South");
        this.setContentPane(this.gesPanel);
        this.dialogZeigenOriginal = new JDialog((Frame)this, true);
        this.windowZeigenOriginal = new PM_CutPicture(this, this.dialogZeigenOriginal);
        this.windowZeigenOriginal.setPreferredSize(PM_Utils.getScreenSize());
        this.dialogZeigenOriginal.setUndecorated(true);
        this.dialogZeigenOriginal.getContentPane().add(this.windowZeigenOriginal);
        this.dialogZeigenOriginal.pack();
        this.dialogDiaShow = new JDialog((Frame)this, true);
        this.windowDiaShow = new PM_WindowSlideshow(this, this.dialogDiaShow);
        this.windowDiaShow.setPreferredSize(PM_Utils.getScreenSize());
        this.dialogDiaShow.setUndecorated(true);
        this.dialogDiaShow.getContentPane().add(this.windowDiaShow);
        this.dialogDiaShow.pack();
        this.dialogBildAendernDrucken = new JDialog((Frame)this, true);
        this.windowDruckenAendern = new PM_CutTempPrint(this, this.dialogBildAendernDrucken);
        this.windowDruckenAendern.setPreferredSize(PM_Utils.getScreenSize());
        this.dialogBildAendernDrucken.setUndecorated(true);
        this.dialogBildAendernDrucken.getContentPane().add(this.windowDruckenAendern);
        this.dialogBildAendernDrucken.pack();
        this.dialogExternBearbeiten = new JDialog((Frame)this, true);
        this.windowExternBearbeiten = new PM_ModifyExternal(this, this.dialogExternBearbeiten);
        Dimension dimension = PM_Utils.getScreenSize();
        dimension.height -= 20;
        this.windowExternBearbeiten.setPreferredSize(dimension);
        this.dialogExternBearbeiten.setUndecorated(true);
        this.dialogExternBearbeiten.getContentPane().add(this.windowExternBearbeiten);
        this.dialogExternBearbeiten.pack();
        PM_LuceneLists pM_LuceneLists = PM_LuceneLists.getInstance();
        pM_LuceneLists.fireAllListener();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PM_WindowMain.this.close();
            }
        });
        this.pack();
        int n2 = PM_All_InitValues.getInstance().getValueInt(this, "positionX");
        int n3 = PM_All_InitValues.getInstance().getValueInt(this, "positionY");
        int n4 = PM_All_InitValues.getInstance().getValueInt(this, "positionW");
        int n5 = PM_All_InitValues.getInstance().getValueInt(this, "positionH");
        if (n4 > 0) {
            serializable = new Rectangle(n2, n3, n4, n5);
            this.setSize(serializable.width, serializable.height);
            this.setLocation(new Point(serializable.x, serializable.y));
        }
        this.keyBindingsForFocusPanel(this);
        this.keyBindingsForDiashow(this);
        this.keyBindingsForChangeMainWindow(this);
        this.keyBindingsForEnterFocusOwner(this);
        this.keyBindingsForClose(this);
        this.keyBindingsForTabChange(this);
        this.keyBindingsForHelpSet(this);
        serializable = this.windowRechts.getWindowSuchen().initRequestFocus();
        this.setAlterFocus((Component)serializable);
        PM_FocusTraversalPolicy pM_FocusTraversalPolicy = new PM_FocusTraversalPolicy(this);
        this.setFocusTraversalPolicy(pM_FocusTraversalPolicy);
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        keyboardFocusManager.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                Component component = (Component)propertyChangeEvent.getNewValue();
                if ("focusOwner".equals(string) && component != null) {
                    PM_WindowMain.this.focusChanged(component);
                }
            }
        });
        PM_SequencesInout.getInstance().setChangeListener();
        this.windowThumbnails.getIndexView().initEnd();
        this.windowRechts.getWindowSuchen().initSelectTree();
        this.windowRechts.getWindowSuchen().initTreeOriginal();
        this.statusPanel.updateAnzahlBilder();
        System.out.println("--- Beginn Verarbeitung ------");
        this.setVisible(true);
    }

    public void close() {
        if (!this.requestToClose()) {
            return;
        }
        int n = JOptionPane.showConfirmDialog(null, PM_MSG.getMsg("winMainExit"), "Terminate", 0);
        if (n == 1) {
            return;
        }
        this.doClose();
        this.setVisible(false);
        this.dispose();
        System.out.println("PhotoManager terminated");
        System.exit(0);
    }

    private void keyBindingsForTabChange(PM_WindowMain pM_WindowMain) {
        InputMap inputMap = this.gesPanel.getInputMap(1);
        ActionMap actionMap = this.gesPanel.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(83, 2), "VK_Suchen");
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowMain.this.reiter(0);
            }
        };
        actionMap.put("VK_Suchen", abstractAction);
        inputMap.put(KeyStroke.getKeyStroke(66, 2), "VK_Bild");
        AbstractAction abstractAction2 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowMain.this.reiter(2);
            }
        };
        actionMap.put("VK_Bild", abstractAction2);
        inputMap.put(KeyStroke.getKeyStroke(71, 2), "VK_Gruppe");
        AbstractAction abstractAction3 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowMain.this.reiter(3);
            }
        };
        actionMap.put("VK_Gruppe", abstractAction3);
        inputMap.put(KeyStroke.getKeyStroke(82, 2), "VK_Serie");
        AbstractAction abstractAction4 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowMain.this.reiter(1);
            }
        };
        actionMap.put("VK_Serie", abstractAction4);
        inputMap.put(KeyStroke.getKeyStroke(68, 2), "VK_Drucken");
        AbstractAction abstractAction5 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowMain.this.reiter(4);
            }
        };
        actionMap.put("VK_Drucken", abstractAction5);
        inputMap.put(KeyStroke.getKeyStroke(69, 2), "VK_Export");
        AbstractAction abstractAction6 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowMain.this.reiter(5);
            }
        };
        actionMap.put("VK_Export", abstractAction6);
        inputMap.put(KeyStroke.getKeyStroke(73, 2), "VK_Info");
        AbstractAction abstractAction7 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowMain.this.reiter(7);
            }
        };
        actionMap.put("VK_Info", abstractAction7);
    }

    private void keyBindingsForEnterFocusOwner(PM_WindowMain pM_WindowMain) {
        InputMap inputMap = this.gesPanel.getInputMap(1);
        ActionMap actionMap = this.gesPanel.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(10, 0), "VK_ENTER");
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowMain.this.enterPressed();
            }
        };
        actionMap.put("VK_ENTER", abstractAction);
    }

    private void keyBindingsForClose(PM_WindowMain pM_WindowMain) {
        InputMap inputMap = this.gesPanel.getInputMap(1);
        ActionMap actionMap = this.gesPanel.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(123, 0), "VK_F12");
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowMain.this.closeF12();
            }
        };
        actionMap.put("VK_F12", abstractAction);
    }

    private void keyBindingsForChangeMainWindow(PM_WindowMain pM_WindowMain) {
        InputMap inputMap = this.gesPanel.getInputMap(1);
        ActionMap actionMap = this.gesPanel.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(10, 2), "VK_CTRL_ENTER");
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowMain.this.ctrlEnterPressed();
            }
        };
        actionMap.put("VK_CTRL_ENTER", abstractAction);
    }

    private void keyBindingsForHelpSet(PM_WindowMain pM_WindowMain) {
        PM_Help pM_Help = PM_Help.getInstance();
        if (pM_Help == null) {
            // empty if block
        }
        InputMap inputMap = this.gesPanel.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke(112, 0), "help");
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = PM_MSG.getMsg("menuHelp1") + PM_MSG.getMsg("menuHelp2") + PM_MSG.getMsg("menuHelp3") + PM_MSG.getMsg("menuHelp4") + PM_MSG.getMsg("menuHelp5");
                JOptionPane.showConfirmDialog(null, string, "Help", -1, 1);
            }
        };
        ActionMap actionMap = this.gesPanel.getActionMap();
        actionMap.put("help", abstractAction);
    }

    private void keyBindingsForFocusPanel(PM_WindowMain pM_WindowMain) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(39, 2);
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(37, 2);
        KeyStroke keyStroke3 = KeyStroke.getKeyStroke(38, 2);
        KeyStroke keyStroke4 = KeyStroke.getKeyStroke(40, 2);
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowMain.this.pfeil(39);
            }
        };
        AbstractAction abstractAction2 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowMain.this.pfeil(37);
            }
        };
        AbstractAction abstractAction3 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowMain.this.pfeil(38);
            }
        };
        AbstractAction abstractAction4 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowMain.this.pfeil(40);
            }
        };
        InputMap inputMap = this.windowRechts.getInputMap(1);
        inputMap.put(keyStroke, "VK_RIGHT");
        inputMap.put(keyStroke2, "VK_LEFT");
        inputMap.put(keyStroke3, "VK_UP");
        inputMap.put(keyStroke4, "VK_DOWN");
        ActionMap actionMap = this.windowRechts.getActionMap();
        actionMap.put("VK_RIGHT", abstractAction);
        actionMap.put("VK_LEFT", abstractAction2);
        actionMap.put("VK_UP", abstractAction3);
        actionMap.put("VK_DOWN", abstractAction4);
        InputMap inputMap2 = this.windowThumbnails.getInputMap(1);
        inputMap2.put(keyStroke, "VK_RIGHT");
        inputMap2.put(keyStroke2, "VK_LEFT");
        inputMap2.put(keyStroke3, "VK_UP");
        inputMap2.put(keyStroke4, "VK_DOWN");
        ActionMap actionMap2 = this.windowThumbnails.getActionMap();
        actionMap2.put("VK_RIGHT", abstractAction);
        actionMap2.put("VK_LEFT", abstractAction2);
        actionMap2.put("VK_UP", abstractAction3);
        actionMap2.put("VK_DOWN", abstractAction4);
    }

    private void keyBindingsForDiashow(PM_WindowMain pM_WindowMain) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(113, 0);
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(114, 0);
        KeyStroke keyStroke3 = KeyStroke.getKeyStroke(115, 0);
        InputMap inputMap = this.gesPanel.getInputMap(1);
        ActionMap actionMap = this.gesPanel.getActionMap();
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowMain.this.diashow(1);
            }
        };
        AbstractAction abstractAction2 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowMain.this.diashow(2);
            }
        };
        AbstractAction abstractAction3 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowMain.this.diashow(3);
            }
        };
        inputMap.put(keyStroke, "normal");
        inputMap.put(keyStroke2, "sequent");
        inputMap.put(keyStroke3, "random");
        actionMap.put("normal", abstractAction);
        actionMap.put("sequent", abstractAction2);
        actionMap.put("random", abstractAction3);
        InputMap inputMap2 = this.windowDiaShow.getInputMap();
        inputMap2.put(keyStroke, "normal");
        inputMap2.put(keyStroke2, "sequent");
        inputMap2.put(keyStroke3, "random");
        ActionMap actionMap2 = this.windowDiaShow.getActionMap();
        AbstractAction abstractAction4 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowMain.this.windowDiaShow.keyPressedFkt(1);
            }
        };
        AbstractAction abstractAction5 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowMain.this.windowDiaShow.keyPressedFkt(2);
            }
        };
        AbstractAction abstractAction6 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowMain.this.windowDiaShow.keyPressedFkt(3);
            }
        };
        actionMap2.put("normal", abstractAction4);
        actionMap2.put("sequent", abstractAction5);
        actionMap2.put("random", abstractAction6);
        InputMap inputMap3 = this.windowZeigenOriginal.getInputMap();
        inputMap3.put(keyStroke, "normal");
        inputMap3.put(keyStroke2, "sequent");
        inputMap3.put(keyStroke3, "random");
        ActionMap actionMap3 = this.windowZeigenOriginal.getActionMap();
        AbstractAction abstractAction7 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowMain.this.windowZeigenOriginal.keyPressedFkt(1);
            }
        };
        AbstractAction abstractAction8 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowMain.this.windowZeigenOriginal.keyPressedFkt(2);
            }
        };
        AbstractAction abstractAction9 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowMain.this.windowZeigenOriginal.keyPressedFkt(3);
            }
        };
        actionMap3.put("normal", abstractAction7);
        actionMap3.put("sequent", abstractAction8);
        actionMap3.put("random", abstractAction9);
    }

    public void setJustChanged(PM_WindowBase pM_WindowBase) {
        this.justChanged = pM_WindowBase;
    }

    private void setAlterFocus(Component component) {
        this.focusOld = component;
    }

    private Component getAlterFocus() {
        return this.focusOld;
    }

    private void focusChanged(Component component) {
        Component component2;
        if (this.justChanged != null) {
            component2 = this.justChanged.getAktiverFocus();
            if (component2 != null) {
                component2.requestFocusInWindow();
            }
            this.justChanged = null;
        }
        if (component == (component2 = this.getAlterFocus())) {
            return;
        }
        PM_WindowBase pM_WindowBase = this.getWindowBaseWithFocusOwner(component);
        if (pM_WindowBase == null) {
            return;
        }
        this.setAlterFocus(component);
        pM_WindowBase.setAktiverFocus(component);
        PM_FocusPanel pM_FocusPanel = this.getFocusPanel(component2);
        PM_FocusPanel pM_FocusPanel2 = this.getFocusPanel(component);
        if (pM_FocusPanel2 != null && pM_FocusPanel2 != null) {
            pM_FocusPanel2.setLastFocus(component);
        }
        if (pM_FocusPanel != pM_FocusPanel2) {
            if (pM_FocusPanel != null) {
                pM_FocusPanel.setBackgroundColor(PM_WindowBase.COLOR_BG_PANEL);
            }
            if (pM_FocusPanel2 != null) {
                pM_FocusPanel2.setBackgroundColor(PM_WindowBase.COLOR_BG_PANEL_SEL);
            }
        }
        this.setBackgroundColor(component2, PM_WindowBase.COLOR_ENABLED, PM_WindowBase.COLOR_BG_PANEL);
        this.setBackgroundColor(component, PM_WindowBase.COLOR_BG_FOCUS, PM_WindowBase.COLOR_BG_PANEL_SEL);
    }

    private void setBackgroundColor(Component component, Color color, Color color2) {
        if (component instanceof JTree) {
            JTree jTree = (JTree)component;
            jTree.setBackground(color2);
            return;
        }
        if (component instanceof JList) {
            ((JList)component).setSelectionBackground(color);
            ((JList)component).setBackground(color2);
            return;
        }
        if (component instanceof PM_IndexView) {
            PM_IndexView pM_IndexView = (PM_IndexView)component;
            pM_IndexView.setBackground(color2);
            PM_PictureView pM_PictureView = pM_IndexView.getPictureViewSelected();
            if (pM_PictureView != null) {
                pM_PictureView.requestFocusInWindow();
            }
            return;
        }
        if (component instanceof PM_PictureViewDragAndDrop) {
            PM_PictureViewDragAndDrop pM_PictureViewDragAndDrop = (PM_PictureViewDragAndDrop)component;
            PM_IndexView pM_IndexView = pM_PictureViewDragAndDrop.getIndexView();
            pM_IndexView.setBackground(color2);
            return;
        }
        component.setBackground(color);
    }

    private PM_FocusPanel getFocusPanel(Component component) {
        if (component == null) {
            return null;
        }
        PM_IndexView pM_IndexView = null;
        for (Container container = component.getParent(); container != null; container = container.getParent()) {
            if (container instanceof PM_FocusPanel) {
                return (PM_FocusPanel)container;
            }
            if (!(container instanceof PM_IndexView)) continue;
            pM_IndexView = (PM_IndexView)container;
            return pM_IndexView.getFocusPanel();
        }
        return null;
    }

    public void keyTextFieldPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if ((n == 37 || n == 39) && (keyEvent.getModifiers() & 2) != 0) {
            if (this.textFieldPressed != null) {
                this.textFieldPressed = null;
                return;
            }
            this.pfeil(n);
        }
    }

    public PM_FocusPanel getFocusPanelWithFocusOwner() {
        PM_WindowBase pM_WindowBase = this.getWindowBaseWithFocusOwner();
        if (pM_WindowBase == null) {
            return null;
        }
        return pM_WindowBase.getFocusPanelWithFocusOwner();
    }

    public PM_FocusPanel getFocusPanelWithFocusOwner(Component component) {
        PM_WindowBase pM_WindowBase = this.getWindowBaseWithFocusOwner(component);
        if (pM_WindowBase == null) {
            return null;
        }
        return pM_WindowBase.getFocusPanelWithFocusOwner(component);
    }

    private void pfeil(int n) {
        Component component = this.getFocusOwner();
        PM_FocusPanel pM_FocusPanel = this.getFocusPanel(component);
        if (pM_FocusPanel == null) {
            return;
        }
        Component component2 = pM_FocusPanel.getNextFocus(component, n, this);
        if (component2 == null) {
            return;
        }
        component2.requestFocusInWindow();
    }

    public void diashow(int n) {
        Component component = this.getFocusOwner();
        PM_WindowBase pM_WindowBase = this.getWindowBaseWithFocusOwner(component);
        if (pM_WindowBase == null) {
            return;
        }
        if (pM_WindowBase instanceof PM_WindowSearch) {
            PM_WindowSearch pM_WindowSearch = (PM_WindowSearch)pM_WindowBase;
            pM_WindowSearch.startDiashow(n);
        }
    }

    private void closeF12() {
        if (!this.requestToClose()) {
            return;
        }
        int n = JOptionPane.showConfirmDialog(this, PM_MSG.getMsg("winMainExit"), "Terminate", 0, 3);
        if (n == 1) {
            return;
        }
        this.doClose();
        this.setVisible(false);
        this.dispose();
        System.out.println("PhotoManager terminated");
        System.exit(0);
    }

    private void reiter(int n) {
        this.windowRechts.setSelectedIndex(n);
    }

    public PM_WindowBase getWindowBaseWithFocusOwner(Component component) {
        if (PM_Utils.isAncestorOf(component, this.windowThumbnails)) {
            return this.windowThumbnails;
        }
        if (PM_Utils.isAncestorOf(component, this.windowRechts)) {
            return this.windowRechts.getWindowSelected();
        }
        return null;
    }

    public PM_WindowBase getWindowBaseWithFocusOwner() {
        Component component = this.getFocusOwner();
        return this.getWindowBaseWithFocusOwner(component);
    }

    private void ctrlEnterPressed() {
        Component component = this.getFocusOwner();
        if (component == null) {
            return;
        }
        if (PM_Utils.isAncestorOf(component, this.windowThumbnails)) {
            Component component2 = this.windowRechts.getWindowSelected().getAktiverFocus();
            if (component2 != null) {
                component2.requestFocusInWindow();
            }
            return;
        }
        if (PM_Utils.isAncestorOf(component, this.windowRechts)) {
            this.windowThumbnails.getIndexView().requestFocusInWindow();
            return;
        }
    }

    private void enterPressed() {
        Component component = this.getFocusOwner();
        if (component == null) {
            return;
        }
        if (component instanceof JButton) {
            ((JButton)component).doClick();
        } else if (component instanceof JCheckBox) {
            ((JCheckBox)component).doClick();
        }
    }

    public PM_WindowLeftThumbnails getWindowThumbnails() {
        return this.windowThumbnails;
    }

    public PM_WindowBase getWindowRightSelected() {
        return this.windowRechts.getWindowSelected();
    }

    public void rereadPictureViewThumbnail(PM_Picture pM_Picture) {
        this.windowRechts.flushPictureViewThumbnail(pM_Picture);
        this.windowThumbnails.rereadPictureViewThumbnail(pM_Picture);
    }

    public PM_WindowRightTabbedPane getWindowRechts() {
        return this.windowRechts;
    }

    public int getSelectedTab() {
        return this.windowRechts.getSelectedTab();
    }

    public PM_IndexView getIndexViewThumbnails() {
        return this.windowThumbnails.getIndexView();
    }

    public PM_IndexView getIndexViewWindowRight() {
        return this.getWindowRightSelected().getIndexView();
    }

    public boolean requestToClose() {
        return this.windowRechts.requestToClose();
    }

    public void closeAlbum() {
        this.windowThumbnails.closeAlbum();
        this.windowRechts.closeAlbum();
    }

    public void rereadAllThumbs() {
        this.windowThumbnails.rereadAllThumbs();
        this.windowRechts.rereadAllThumbs();
    }

    public boolean flushAndCloseDisplay() {
        if (!this.requestToClose()) {
            return false;
        }
        PM_MetadataContainer.getInstance().flush();
        PM_DatabaseLucene.getInstance().flush();
        PM_SequencesInout.getInstance().flush();
        if (!this.windowThumbnails.flush()) {
            return false;
        }
        return this.windowRechts.flush();
    }

    private void doClose() {
        PM_All_InitValues.getInstance().putValueInt(this, "positionX", this.getLocation().x);
        PM_All_InitValues.getInstance().putValueInt(this, "positionY", this.getLocation().y);
        PM_All_InitValues.getInstance().putValueInt(this, "positionW", this.getSize().width);
        PM_All_InitValues.getInstance().putValueInt(this, "positionH", this.getSize().height);
        PM_All_InitValues.getInstance().putValueInt(this, "vertical-devider", this.splitPane.getDividerLocation());
        this.windowRechts.close();
        this.windowThumbnails.close();
        PM_ExportDelete.deleteAllPictures();
        PM_MetadataContainer.getInstance().close();
        PM_DatabaseLucene.getInstance().close();
        PM_SequencesInout.getInstance().close();
        PM_All_ExternalPrograms.getInstance().close();
        PM_XML_File_Session.getInstance().close();
        this.einstellungen.close();
        PM_All_InitValues.getInstance().close();
        PM_LogFile.getInstance().close();
    }

    public PM_CutTempPrint getDialogDruckenAendern() {
        return this.windowDruckenAendern;
    }

    public boolean doBildAendernDrucken(PM_PicturePrint pM_PicturePrint) {
        this.windowDruckenAendern.start(pM_PicturePrint);
        this.dialogBildAendernDrucken.setVisible(true);
        return this.windowDruckenAendern.getReturnStatus();
    }

    public void closeBildAendernDrucken() {
        this.dialogBildAendernDrucken.dispose();
    }

    public PM_Picture doBildZeigenOriginal(PM_Picture pM_Picture, List<PM_Picture> list) {
        if (!this.windowZeigenOriginal.start(pM_Picture, list)) {
            return pM_Picture;
        }
        this.dialogZeigenOriginal.setVisible(true);
        PM_Picture pM_Picture2 = this.windowZeigenOriginal.getPicture();
        if (this.windowZeigenOriginal.getDiaShowAufrufen()) {
            pM_Picture2 = this.doDiaShow(pM_Picture2, list, 1);
        }
        PM_Picture.readImageOriginal(new ArrayList<PM_Picture>(), new ArrayList<PM_Picture>());
        return pM_Picture2;
    }

    public PM_Picture doDiaShow(PM_Picture pM_Picture, List<PM_Picture> list, int n) {
        if (!this.windowDiaShow.start(pM_Picture, list, n)) {
            return pM_Picture;
        }
        this.dialogDiaShow.setVisible(true);
        PM_Picture pM_Picture2 = this.windowDiaShow.getPicture();
        if (this.windowDiaShow.getAendernAufrufen()) {
            pM_Picture2 = this.doBildZeigenOriginal(pM_Picture2, list);
        }
        PM_Picture.flushAllImagesOriginal();
        return pM_Picture2;
    }

    public void doExternBearbeiten(PM_Picture pM_Picture) {
        if (!this.windowExternBearbeiten.start(pM_Picture)) {
            return;
        }
        this.dialogExternBearbeiten.setVisible(true);
    }
}

