/*
 * Decompiled with CFR 0.152.
 */
package pm.print;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import pm.print.PM_PaperFormatF1;
import pm.print.PM_PaperFormatF2;
import pm.print.PM_PaperFormatF4;
import pm.print.PM_PaperFormatF6;
import pm.print.PM_PicturePrint;
import pm.print.PM_PmPrinter;
import pm.utilities.PM_Interface;

public class PM_PaperFormat
implements PM_Interface {
    protected List<Line2D> hilfsLinien = new ArrayList<Line2D>();
    protected PM_PicturePrint[] allePictureDrucken = null;
    protected PM_PmPrinter drucker = null;
    protected Rectangle2D papierBereichGesamt = null;
    protected double papierGesX = 0.0;
    protected double papierGesY = 0.0;
    protected double papierGesB = 0.0;
    protected double papierGesH = 0.0;
    private static final PM_PaperFormatF1 papierFormatF1 = new PM_PaperFormatF1();
    private static final PM_PaperFormatF2 papierFormatF2 = new PM_PaperFormatF2();
    private static final PM_PaperFormatF4 papierFormatF4 = new PM_PaperFormatF4();
    private static final PM_PaperFormatF6 papierFormatF6 = new PM_PaperFormatF6();

    public static PM_PaperFormat getPaperFormat(String string) {
        if (string.equals("F1")) {
            return papierFormatF1;
        }
        if (string.equals("F2")) {
            return papierFormatF2;
        }
        if (string.equals("F4")) {
            return papierFormatF4;
        }
        if (string.equals("F6")) {
            return papierFormatF6;
        }
        return null;
    }

    public void init(PM_PmPrinter pM_PmPrinter) {
        this.drucker = pM_PmPrinter;
        this.papierBereichGesamt = pM_PmPrinter.getDruckBereichGesamt();
        this.papierGesX = this.papierBereichGesamt.getX();
        this.papierGesY = this.papierBereichGesamt.getY();
        this.papierGesB = this.papierBereichGesamt.getWidth();
        this.papierGesH = this.papierBereichGesamt.getHeight();
    }

    public String getAbmessungPapierBereich() {
        if (this.allePictureDrucken == null || this.drucker == null) {
            return "unbekannt";
        }
        Rectangle2D rectangle2D = this.allePictureDrucken[0].getPapierBereich();
        return this.getAbmessungen(rectangle2D);
    }

    public String getAbmessungDruckBereich() {
        if (this.allePictureDrucken == null || this.drucker == null) {
            return "unbekannt";
        }
        Rectangle2D rectangle2D = this.allePictureDrucken[0].getDruckBereich();
        return this.getAbmessungen(rectangle2D);
    }

    private String getAbmessungen(Rectangle2D rectangle2D) {
        Point2D point2D = this.drucker.getAufloesung();
        int n = (int)Math.round(rectangle2D.getWidth() / point2D.getX() * (double)25.4f);
        int n2 = (int)Math.round(rectangle2D.getHeight() / point2D.getY() * (double)25.4f);
        return Integer.toString(n) + "x" + Integer.toString(n2);
    }

    protected void createAllePictureDrucken(int n) {
        this.allePictureDrucken = new PM_PicturePrint[n];
        for (int i = 0; i < n; ++i) {
            this.allePictureDrucken[i] = new PM_PicturePrint(this.drucker, i);
        }
        this.hilfsLinien = new ArrayList<Line2D>();
    }

    public PM_PicturePrint[] getAllePictureDrucken() {
        return this.allePictureDrucken;
    }

    public List getHilfsLinien() {
        return this.hilfsLinien;
    }
}

