/*
 * Decompiled with CFR 0.152.
 */
package pm.print;

import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import pm.picture.PM_Picture;
import pm.print.PM_PictureFormat;
import pm.print.PM_PmPrinter;
import pm.utilities.PM_Interface;

public class PM_PicturePrint
implements PM_Interface {
    private PM_Picture picture;
    private PM_PmPrinter drucker;
    private PM_PictureFormat bildFormat;
    private int bildNummer;
    private boolean empty = true;
    private Image imageOriginal = null;
    private Rectangle2D papierBereich = null;
    private Rectangle2D druckBereich = null;
    private Rectangle2D cutRectangle = null;
    private String beschriftung = "";

    public PM_PicturePrint(PM_PmPrinter pM_PmPrinter, int n) {
        this.drucker = pM_PmPrinter;
        this.bildNummer = n;
    }

    public int init(PM_Picture pM_Picture, PM_PictureFormat pM_PictureFormat, String string) {
        this.empty = false;
        this.picture = pM_Picture;
        this.bildFormat = pM_PictureFormat;
        this.setBeschriftung(string);
        this.lesenImages();
        this.imageOriginal = pM_Picture.getImageOriginal();
        this.cutRectangle = pM_Picture.meta.getCutRectangle();
        pM_PictureFormat.init(this);
        pM_PictureFormat.toPictureDrucken(this);
        return this.bildNummer;
    }

    public String getBeschriftung() {
        return this.beschriftung;
    }

    public void setBeschriftung(String string) {
        if (string.equalsIgnoreCase("datum")) {
            Date date = this.picture.meta.getDateCurrent();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy");
            this.beschriftung = simpleDateFormat.format(date);
            return;
        }
        this.beschriftung = "";
    }

    public PM_PmPrinter getDrucker() {
        return this.drucker;
    }

    public void delete() {
        this.empty = true;
        this.picture = null;
        this.lesenImages();
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public PM_Picture getPicture() {
        return this.picture;
    }

    public int getBildNummer() {
        return this.bildNummer;
    }

    public Image getImage() {
        return this.imageOriginal;
    }

    public PM_PictureFormat getBildFormat() {
        return this.bildFormat;
    }

    public Rectangle2D getCutRectangle() {
        return this.cutRectangle;
    }

    public void setCutRectangle(Rectangle2D rectangle2D) {
        this.cutRectangle = rectangle2D;
    }

    public void setPapierBereich(Rectangle2D rectangle2D) {
        this.papierBereich = rectangle2D;
    }

    public Rectangle2D getPapierBereich() {
        return this.papierBereich;
    }

    public void setDruckBereich(Rectangle2D rectangle2D) {
        this.druckBereich = rectangle2D;
    }

    public Rectangle2D getDruckBereich() {
        return this.druckBereich;
    }

    private void lesenImages() {
        ArrayList<PM_Picture> arrayList = new ArrayList<PM_Picture>();
        PM_PicturePrint[] pM_PicturePrintArray = this.drucker.getAlleBilder();
        for (int i = 0; i < pM_PicturePrintArray.length; ++i) {
            PM_PicturePrint pM_PicturePrint = pM_PicturePrintArray[i];
            if (pM_PicturePrint.isEmpty() || arrayList.contains(pM_PicturePrint.getPicture())) continue;
            arrayList.add(pM_PicturePrint.getPicture());
        }
        PM_Picture.readImageOriginal(arrayList, new ArrayList<PM_Picture>());
    }
}

