/*
 * Decompiled with CFR 0.152.
 */
package pm.sequence;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import pm.inout.PM_SequencesInout;
import pm.sequence.PM_Sequence;
import pm.sequence.PM_SequenceAlbum;
import pm.sequence.PM_TreeModel;
import pm.utilities.PM_Action;
import pm.utilities.PM_Interface;
import pm.utilities.PM_Listener;
import pm.utilities.PM_MSG;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PM_TreeModelAlbum
extends PM_TreeModel
implements PM_Interface {
    private Map<PM_Sequence, Set<DefaultMutableTreeNode>> openSequenceMap = new HashMap<PM_Sequence, Set<DefaultMutableTreeNode>>();
    private Set<DefaultMutableTreeNode> markNodes = new HashSet<DefaultMutableTreeNode>();
    private static PM_TreeModelAlbum instance = null;
    private PM_Sequence sequenceSelected = null;

    public static PM_TreeModelAlbum getInstance() {
        if (instance == null) {
            instance = new PM_TreeModelAlbum();
        }
        return instance;
    }

    private PM_TreeModelAlbum() {
        this.rootNode.setUserObject(PM_MSG.getMsg("photalbum"));
        List<PM_Sequence> list = PM_SequencesInout.getInstance().getList(PM_Interface.SequenceType.ALBUM);
        for (PM_Sequence pM_Sequence : list) {
            this.initAddSequence(pM_Sequence);
        }
        this.createSequenceDictionary();
        this.makeTreeModelListener();
        this.initDone();
    }

    private void makeTreeModelListener() {
        PM_Listener pM_Listener = new PM_Listener(){

            public void actionPerformed(PM_Action pM_Action) {
                PM_Interface.TreeModelChangedType treeModelChangedType;
                Object object = pM_Action.getObject();
                if (object instanceof PM_Interface.TreeModelChangedType && ((treeModelChangedType = (PM_Interface.TreeModelChangedType)((Object)object)) == PM_Interface.TreeModelChangedType.INSERT || treeModelChangedType == PM_Interface.TreeModelChangedType.REMOVE)) {
                    PM_TreeModelAlbum.this.treeNodesInsertedRemoved();
                }
            }
        };
        this.addChangeListener(pM_Listener);
    }

    private void treeNodesInsertedRemoved() {
        this.createSequenceDictionary();
        this.markSequenceSelected();
        PM_TreeModelAlbum.nodesNotInAlbum();
    }

    public Map<PM_Sequence, Set<DefaultMutableTreeNode>> getSequenceDictionary() {
        return this.openSequenceMap;
    }

    public void createSequenceDictionary() {
        this.openSequenceMap = new HashMap<PM_Sequence, Set<DefaultMutableTreeNode>>();
        Enumeration<TreeNode> enumeration = this.rootNode.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            Set<Object> set;
            PM_SequenceAlbum pM_SequenceAlbum;
            PM_Sequence pM_Sequence;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            Object object = defaultMutableTreeNode.getUserObject();
            if (!(object instanceof PM_SequenceAlbum) || (pM_Sequence = (pM_SequenceAlbum = (PM_SequenceAlbum)object).getSeqClosed()) == null) continue;
            if (this.openSequenceMap.containsKey(pM_Sequence)) {
                set = this.openSequenceMap.get(pM_Sequence);
                set.add(defaultMutableTreeNode);
                continue;
            }
            set = new HashSet<DefaultMutableTreeNode>();
            set.add(defaultMutableTreeNode);
            this.openSequenceMap.put(pM_Sequence, set);
        }
    }

    public void setSequenceSelected(PM_Sequence pM_Sequence) {
        this.sequenceSelected = pM_Sequence;
        this.markSequenceSelected();
        this.nodeChanged(this.rootNode);
    }

    public void markSequenceSelected() {
        this.markNodes = this.openSequenceMap.containsKey(this.sequenceSelected) ? this.openSequenceMap.get(this.sequenceSelected) : new HashSet<DefaultMutableTreeNode>();
    }

    @Override
    public ArrayList<PM_Sequence> getSequenceListWrite() {
        return this._getSequenceList(true);
    }

    public Set<DefaultMutableTreeNode> getMarkNodes() {
        return this.markNodes;
    }

    @Override
    protected PM_Sequence getSequenceForWrite(DefaultMutableTreeNode defaultMutableTreeNode) {
        String string = PM_TreeModel.getPathFromNode(defaultMutableTreeNode);
        PM_SequenceAlbum pM_SequenceAlbum = new PM_SequenceAlbum(string);
        pM_SequenceAlbum.setStringLeaf(true);
        return pM_SequenceAlbum;
    }
}

