/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.Iterator;
import java.util.Vector;

public class BubbleMap {
    public static final boolean DEBUG = false;
    public static final int UNASSIGNED = -1;
    public static final int ASSIGNED = Integer.MAX_VALUE;
    public static final int CIRCULAR_LAYOUT = 1;
    public static final int RECTANGULAR_LAYOUT = 2;
    protected final int NORTH = 0;
    protected final int NORTHEAST = 1;
    protected final int EAST = 2;
    protected final int SOUTHEAST = 3;
    protected final int SOUTH = 4;
    protected final int SOUTHWEST = 5;
    protected final int WEST = 6;
    protected final int NORTHWEST = 7;
    protected int[] origSizes;
    protected Rectangle origBox;
    protected double origiar;
    protected int[][] idGrid = null;
    protected int numCols = 0;
    protected int numRows = 0;
    protected Rectangle box;
    protected Vector idList;
    protected Vector nextList;
    protected int layoutType = 1;

    public BubbleMap(int[] nArray, double d, Rectangle rectangle) {
        this.origSizes = nArray;
        this.origBox = rectangle;
        this.origiar = d;
    }

    public void setLayoutType(int n) {
        this.layoutType = n;
    }

    public int getLayoutType() {
        return this.layoutType;
    }

    public Vector bubbleMapLayout() {
        Point[] pointArray;
        int n = this.computeSize(this.origSizes);
        double d = this.computeAspectRatio(this.origBox) / this.origiar;
        this.numRows = (int)Math.ceil(Math.sqrt((double)n / d));
        this.numCols = (int)Math.ceil((double)n / (double)this.numRows);
        this.box = new Rectangle(this.origBox.x, this.origBox.y, this.numCols, this.numRows);
        BubbleMap.debugPrintln("Orig box = " + this.origBox + ", New Box = " + this.box);
        BubbleMap.debugPrintln("rows=" + this.numRows + ", cols=" + this.numCols);
        this.idGrid = new int[this.numRows][this.numCols];
        int n2 = 0;
        while (n2 < this.numRows) {
            int n3 = 0;
            while (n3 < this.numCols) {
                this.idGrid[n2][n3] = -1;
                ++n3;
            }
            ++n2;
        }
        this.idList = new Vector();
        this.nextList = new Vector();
        n2 = 0;
        while (n2 < this.origSizes.length) {
            pointArray = this.fill(n2, this.origSizes[n2]);
            this.idList.add(pointArray);
            ++n2;
        }
        int n4 = 0;
        BubbleMap.debugPrintln("");
        Iterator iterator = this.idList.iterator();
        while (iterator.hasNext()) {
            pointArray = (Point[])iterator.next();
            BubbleMap.debugPrintln("Size[" + n4 + "] = " + pointArray.length);
            n2 = 0;
            while (n2 < pointArray.length) {
                BubbleMap.debugPrintln("pt[" + n2 + "] = " + pointArray[n2]);
                ++n2;
            }
            ++n4;
        }
        return this.idList;
    }

    Point[] fill(int n, int n2) {
        Point point = null;
        BubbleMap.debugPrintln("A: id=" + n + ", size=" + n2);
        int n3 = 0;
        block0: while (n3 < this.numRows) {
            int n4 = 0;
            while (n4 < this.numCols) {
                if (this.idGrid[n3][n4] < n) {
                    point = new Point(n4, n3);
                    break block0;
                }
                ++n4;
            }
            ++n3;
        }
        this.idGrid[point.y][point.x] = n;
        this.nextList.clear();
        this.insert(this.nextList, point, point);
        Point[] pointArray = new Point[n2];
        this.fillRecurse(n, n2, pointArray, point);
        return pointArray;
    }

    /*
     * Unable to fully structure code
     */
    void fillRecurse(int var1_1, int var2_2, Point[] var3_3, Point var4_4) {
        block29: {
            var8_5 = null;
            if (var2_2 == 0) {
                return;
            }
            BubbleMap.debugPrintln("B: id=" + var1_1 + ", size=" + var2_2 + ", startpt=" + var4_4);
            try {
                var8_5 = (Point)this.nextList.get(0);
                this.nextList.remove(0);
                break block29;
            }
            catch (Exception var9_6) {
                var6_14 = 0;
                ** while (var6_14 < this.numRows)
            }
lbl-1000:
            // 1 sources

            {
                var7_15 = 0;
                while (var7_15 < this.numCols) {
                    if (this.idGrid[var6_14][var7_15] < var1_1) {
                        var8_5 = new Point(var7_15, var6_14);
                    }
                    ++var7_15;
                }
                ++var6_14;
                continue;
            }
lbl21:
            // 1 sources

            if (var8_5 == null) {
                System.out.println("ERROR - can't find space for point");
            }
        }
        var3_3[--var2_2] = var8_5;
        this.idGrid[var8_5.y][var8_5.x] = 0x7FFFFFFF;
        if (var2_2 > 0) {
            try {
                if (this.idGrid[var8_5.y][var8_5.x + 1] < var1_1) {
                    this.idGrid[var8_5.y][var8_5.x + 1] = var1_1;
                    this.insert(this.nextList, var4_4, new Point(var8_5.x + 1, var8_5.y));
                }
            }
            catch (Exception var9_7) {
                // empty catch block
            }
            try {
                if (this.idGrid[var8_5.y + 1][var8_5.x] < var1_1) {
                    this.idGrid[var8_5.y + 1][var8_5.x] = var1_1;
                    this.insert(this.nextList, var4_4, new Point(var8_5.x, var8_5.y + 1));
                }
            }
            catch (Exception var9_8) {
                // empty catch block
            }
            try {
                if (this.idGrid[var8_5.y][var8_5.x - 1] < var1_1) {
                    this.idGrid[var8_5.y][var8_5.x - 1] = var1_1;
                    this.insert(this.nextList, var4_4, new Point(var8_5.x - 1, var8_5.y));
                }
            }
            catch (Exception var9_9) {
                // empty catch block
            }
            try {
                if (this.idGrid[var8_5.y + 1][var8_5.x - 1] < var1_1) {
                    this.idGrid[var8_5.y + 1][var8_5.x - 1] = var1_1;
                    this.insert(this.nextList, var4_4, new Point(var8_5.x - 1, var8_5.y + 1));
                }
            }
            catch (Exception var9_10) {
                // empty catch block
            }
            try {
                if (this.idGrid[var8_5.y + 1][var8_5.x + 1] < var1_1) {
                    this.idGrid[var8_5.y + 1][var8_5.x + 1] = var1_1;
                    this.insert(this.nextList, var4_4, new Point(var8_5.x + 1, var8_5.y + 1));
                }
            }
            catch (Exception var9_11) {
                // empty catch block
            }
            try {
                if (this.idGrid[var8_5.y - 1][var8_5.x] < var1_1) {
                    this.idGrid[var8_5.y - 1][var8_5.x] = var1_1;
                    this.insert(this.nextList, var4_4, new Point(var8_5.x, var8_5.y - 1));
                }
            }
            catch (Exception var9_12) {
                // empty catch block
            }
            try {
                if (this.idGrid[var8_5.y - 1][var8_5.x + 1] < var1_1) {
                    this.idGrid[var8_5.y - 1][var8_5.x + 1] = var1_1;
                    this.insert(this.nextList, var4_4, new Point(var8_5.x + 1, var8_5.y - 1));
                }
            }
            catch (Exception var9_13) {
                // empty catch block
            }
            this.fillRecurse(var1_1, var2_2, var3_3, var4_4);
        }
    }

    void insert(Vector vector, Point point, Point point2) {
        int n = 0;
        block0 : switch (this.layoutType) {
            case 1: {
                int n2 = (point2.x - point.x) * (point2.x - point.x) + (point2.y - point.y) * (point2.y - point.y);
                Iterator iterator = vector.iterator();
                while (iterator.hasNext()) {
                    Point point3 = (Point)iterator.next();
                    int n3 = (point3.x - point.x) * (point3.x - point.x) + (point3.y - point.y) * (point3.y - point.y);
                    if (n2 < n3) break block0;
                    ++n;
                }
                break;
            }
            case 2: {
                n = vector.size();
            }
        }
        vector.add(n, point2);
    }

    public Vector getResult() {
        return this.idList;
    }

    public Rectangle getResultBox() {
        return this.box;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Vector getBoundary(int n) {
        Point point;
        int n2 = 0;
        Vector<Point> vector = new Vector<Point>();
        Point point2 = null;
        boolean bl = true;
        if (this.idList == null) {
            BubbleMap.debugPrintln("Layout hasn't been computed yet");
            return vector;
        }
        int n3 = 0;
        while (n3 < this.numCols) {
            int n4 = 0;
            while (n4 < this.numRows) {
                this.idGrid[n4][n3] = -1;
                ++n4;
            }
            ++n3;
        }
        Point[] pointArray = (Point[])this.idList.get(n);
        int n5 = 0;
        while (n5 < pointArray.length) {
            this.idGrid[pointArray[n5].y][pointArray[n5].x] = Integer.MAX_VALUE;
            ++n5;
        }
        Point point3 = point = pointArray[0];
        int n6 = 0;
        while (n6 < 8) {
            if (this.hasNeighbor(point3, n6)) break;
            ++n6;
        }
        BubbleMap.debugPrintln("Building boundary: startpt = " + point);
        do {
            BubbleMap.debugPrintln("pt = " + point3 + ", direction = " + n6);
            boolean bl2 = false;
            Point point4 = null;
            n5 = 0;
            block15: while (n5 < 9) {
                BubbleMap.debugPrintln("searching direction[" + n5 + "] = " + n6);
                switch (n6) {
                    case 0: {
                        if (!this.hasNeighbor(point3, 0)) {
                            if (bl) {
                                bl = false;
                                vector.add(new Point(point3.x, point3.y));
                                BubbleMap.debugPrintln("add " + vector.lastElement());
                            }
                            point2 = new Point(point3.x + 1, point3.y);
                            vector.add(point2);
                            BubbleMap.debugPrintln("add " + vector.lastElement());
                            bl2 = true;
                            break;
                        }
                        if (!bl2 || point4 != null) break;
                        point4 = new Point(point3.x, point3.y - 1);
                        n2 = 6;
                        break block15;
                    }
                    case 1: {
                        if (!this.hasNeighbor(point3, 1) || !bl2 || point4 != null) break;
                        point4 = new Point(point3.x + 1, point3.y - 1);
                        n2 = 6;
                        break block15;
                    }
                    case 2: {
                        if (!this.hasNeighbor(point3, 2)) {
                            if (bl) {
                                bl = false;
                                vector.add(new Point(point3.x + 1, point3.y));
                                BubbleMap.debugPrintln("add " + vector.lastElement());
                            }
                            point2 = new Point(point3.x + 1, point3.y + 1);
                            vector.add(point2);
                            BubbleMap.debugPrintln("add " + vector.lastElement());
                            bl2 = true;
                            break;
                        }
                        if (!bl2) break;
                        point4 = new Point(point3.x + 1, point3.y);
                        n2 = 0;
                        break block15;
                    }
                    case 3: {
                        if (!this.hasNeighbor(point3, 3) || !bl2 || point4 != null) break;
                        point4 = new Point(point3.x + 1, point3.y + 1);
                        n2 = 0;
                        break block15;
                    }
                    case 4: {
                        if (!this.hasNeighbor(point3, 4)) {
                            if (bl) {
                                bl = false;
                                vector.add(new Point(point3.x + 1, point3.y + 1));
                                BubbleMap.debugPrintln("add " + vector.lastElement());
                            }
                            point2 = new Point(point3.x, point3.y + 1);
                            vector.add(point2);
                            BubbleMap.debugPrintln("add " + vector.lastElement());
                            bl2 = true;
                            break;
                        }
                        if (!bl2 || point4 != null) break;
                        point4 = new Point(point3.x, point3.y + 1);
                        n2 = 2;
                        break block15;
                    }
                    case 5: {
                        if (!this.hasNeighbor(point3, 5) || !bl2 || point4 != null) break;
                        point4 = new Point(point3.x - 1, point3.y + 1);
                        n2 = 2;
                        break block15;
                    }
                    case 6: {
                        if (!this.hasNeighbor(point3, 6)) {
                            if (bl) {
                                bl = false;
                                vector.add(new Point(point3.x, point3.y + 1));
                                BubbleMap.debugPrintln("add " + vector.lastElement());
                            }
                            point2 = new Point(point3.x, point3.y);
                            vector.add(point2);
                            BubbleMap.debugPrintln("add " + vector.lastElement());
                            bl2 = true;
                            break;
                        }
                        if (!bl2 || point4 != null) break;
                        point4 = new Point(point3.x - 1, point3.y);
                        n2 = 4;
                        break block15;
                    }
                    case 7: {
                        if (!this.hasNeighbor(point3, 7) || !bl2 || point4 != null) break;
                        point4 = new Point(point3.x - 1, point3.y - 1);
                        n2 = 4;
                        break block15;
                    }
                }
                n6 = (n6 + 1) % 8;
                ++n5;
            }
            n6 = n2;
            point3 = point4;
            if (point3 == null) return vector;
        } while (!point.equals(point3));
        return vector;
    }

    boolean hasNeighbor(Point point, int n) {
        boolean bl = false;
        switch (n) {
            case 0: {
                try {
                    if (this.idGrid[point.y - 1][point.x] != Integer.MAX_VALUE) break;
                    bl = true;
                }
                catch (Exception exception) {}
                break;
            }
            case 1: {
                try {
                    if (this.idGrid[point.y - 1][point.x + 1] != Integer.MAX_VALUE) break;
                    bl = true;
                }
                catch (Exception exception) {}
                break;
            }
            case 2: {
                try {
                    if (this.idGrid[point.y][point.x + 1] != Integer.MAX_VALUE) break;
                    bl = true;
                }
                catch (Exception exception) {}
                break;
            }
            case 3: {
                try {
                    if (this.idGrid[point.y + 1][point.x + 1] != Integer.MAX_VALUE) break;
                    bl = true;
                }
                catch (Exception exception) {}
                break;
            }
            case 4: {
                try {
                    if (this.idGrid[point.y + 1][point.x] != Integer.MAX_VALUE) break;
                    bl = true;
                }
                catch (Exception exception) {}
                break;
            }
            case 5: {
                try {
                    if (this.idGrid[point.y + 1][point.x - 1] != Integer.MAX_VALUE) break;
                    bl = true;
                }
                catch (Exception exception) {}
                break;
            }
            case 6: {
                try {
                    if (this.idGrid[point.y][point.x - 1] != Integer.MAX_VALUE) break;
                    bl = true;
                }
                catch (Exception exception) {}
                break;
            }
            case 7: {
                try {
                    if (this.idGrid[point.y - 1][point.x - 1] != Integer.MAX_VALUE) break;
                    bl = true;
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return bl;
    }

    public void printStatistics() {
        if (this.idList == null) {
            System.out.println("Layout hasn't been computed yet");
        } else {
            System.out.print("Sizes: ");
            int n = 0;
            while (n < this.origSizes.length) {
                System.out.print(this.origSizes[n] + " ");
                ++n;
            }
            System.out.println("");
            System.out.println("Requested Box = " + this.origBox);
            System.out.println("Final Box = " + this.box);
        }
    }

    Point2D getCenterOfMass(Point[] pointArray) {
        double d = 0.0;
        double d2 = 0.0;
        int n = 0;
        while (n < pointArray.length) {
            d += (double)pointArray[n].x;
            d2 += (double)pointArray[n].y;
            ++n;
        }
        return new Point2D.Double(d /= (double)pointArray.length, d2 /= (double)pointArray.length);
    }

    protected int computeArea(Rectangle rectangle) {
        return rectangle.width * rectangle.height;
    }

    protected int computeSize(int[] nArray) {
        int n = 0;
        if (nArray != null) {
            int n2 = 0;
            while (n2 < nArray.length) {
                n += nArray[n2];
                ++n2;
            }
        }
        return n;
    }

    protected Rectangle computeUnion(Rectangle[] rectangleArray) {
        Rectangle rectangle = new Rectangle(rectangleArray[0]);
        int n = 1;
        while (n < rectangleArray.length) {
            int n2 = Math.min(rectangle.x, rectangleArray[n].x);
            int n3 = Math.max(rectangle.x + rectangle.width, rectangleArray[n].x + rectangleArray[n].width);
            int n4 = Math.min(rectangle.y, rectangleArray[n].y);
            int n5 = Math.max(rectangle.y + rectangle.height, rectangleArray[n].y + rectangleArray[n].height);
            rectangle.setRect(n2, n4, n3 - n2, n5 - n4);
            ++n;
        }
        return rectangle;
    }

    protected double computeAspectRatio(Rectangle rectangle) {
        return (double)rectangle.width / (double)rectangle.height;
    }

    protected static void debugPrint(String string) {
    }

    protected static void debugPrintln(String string) {
    }
}

