/*
 * Decompiled with CFR 0.152.
 */
import edu.umd.cs.jazz.component.ZPolygon;
import edu.umd.cs.jazz.util.ZRenderContext;
import edu.umd.cs.jazz.util.ZUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

class CushionPolygon
extends ZPolygon
implements Feathered {
    PhotoMesa photomesa;
    Paint[] c = null;
    GeneralPath[] p = null;
    Stroke featherStroke;

    public CushionPolygon(PhotoMesa photoMesa, ZPolygon zPolygon) {
        this.photomesa = photoMesa;
        this.setCoords(zPolygon.getXCoords(), zPolygon.getYCoords());
        this.updateFeatherDepth();
    }

    public void updateFeatherDepth() {
        this.c = new Paint[this.photomesa.state.getFeatherDepth()];
        this.p = new GeneralPath[this.photomesa.state.getFeatherDepth()];
        this.setCoords(this.getXCoords(), this.getYCoords());
        this.setPenPaint(this.getPenPaint());
    }

    public void setPenPaint(Paint paint) {
        super.setPenPaint(paint);
        double d = 1.0 / (double)(this.photomesa.state.getFeatherDepth() + 1);
        double d2 = 0.0;
        int n = 0;
        while (n < this.photomesa.state.getFeatherDepth()) {
            this.c[n] = this.colorLerp(paint, d2 += d, 255, 255, 255);
            ++n;
        }
    }

    public void setPenWidth(double d) {
        super.setPenWidth(d);
        this.featherStroke = new BasicStroke((float)(0.6 * this.penWidth), 0, 0);
    }

    Paint colorLerp(Paint paint, double d, int n, int n2, int n3) {
        Color color = null;
        if (paint != null && paint instanceof Color) {
            Color color2 = (Color)paint;
            int n4 = (int)((double)color2.getRed() + d * (double)(n - color2.getRed()));
            int n5 = (int)((double)color2.getGreen() + d * (double)(n - color2.getGreen()));
            int n6 = (int)((double)color2.getBlue() + d * (double)(n - color2.getBlue()));
            color = new Color(n4, n5, n6);
        }
        return color;
    }

    public void setCoords(double[] dArray, double[] dArray2) {
        super.setCoords(dArray, dArray2);
        if (this.p != null && dArray.length > 0) {
            Point2D.Double double_ = new Point2D.Double();
            Point2D.Double double_2 = new Point2D.Double();
            Point2D.Double double_3 = new Point2D.Double();
            int n = 0;
            while (n < this.photomesa.state.getFeatherDepth()) {
                this.p[n] = new GeneralPath();
                double d = 0.5 * ZUtil.angleBetweenPoints(dArray[0], dArray2[0], dArray[dArray.length - 2], dArray2[dArray2.length - 2], dArray[1], dArray2[1]);
                if (d > 0.0) {
                    d -= Math.PI;
                }
                AffineTransform affineTransform = AffineTransform.getRotateInstance(d, dArray[0], dArray2[0]);
                this.movePointInDir(dArray[0], dArray2[0], dArray[dArray.length - 2], dArray2[dArray2.length - 2], n + 1, double_);
                affineTransform.transform(double_, double_2);
                double d2 = n + 1;
                if (d > -1.0 || d < -2.0) {
                    d2 /= 0.707;
                }
                this.movePointInDir(dArray[0], dArray2[0], ((Point2D)double_2).getX(), ((Point2D)double_2).getY(), d2, double_3);
                this.p[n].moveTo((float)((Point2D)double_3).getX(), (float)((Point2D)double_3).getY());
                int n2 = 1;
                while (n2 < dArray.length - 1) {
                    d = 0.5 * ZUtil.angleBetweenPoints(dArray[n2], dArray2[n2], dArray[n2 - 1], dArray2[n2 - 1], dArray[n2 + 1], dArray2[n2 + 1]);
                    if (d > 0.0) {
                        d -= Math.PI;
                    }
                    affineTransform = AffineTransform.getRotateInstance(d, dArray[n2], dArray2[n2]);
                    this.movePointInDir(dArray[n2], dArray2[n2], dArray[n2 - 1], dArray2[n2 - 1], n + 1, double_);
                    affineTransform.transform(double_, double_2);
                    d2 = n + 1;
                    if (d > -1.0 || d < -2.0) {
                        d2 /= 0.707;
                    }
                    this.movePointInDir(dArray[n2], dArray2[n2], ((Point2D)double_2).getX(), ((Point2D)double_2).getY(), d2, double_3);
                    this.p[n].lineTo((float)((Point2D)double_3).getX(), (float)((Point2D)double_3).getY());
                    ++n2;
                }
                this.p[n].closePath();
                ++n;
            }
        }
    }

    void movePointInDir(double d, double d2, double d3, double d4, double d5, Point2D point2D) {
        double d6 = d3 - d;
        double d7 = d4 - d2;
        double d8 = Math.sqrt(d6 * d6 + d7 * d7);
        point2D.setLocation(d + d5 * (d6 / d8), d2 + d5 * (d7 / d8));
    }

    public void render(ZRenderContext zRenderContext) {
        super.render(zRenderContext);
        Graphics2D graphics2D = zRenderContext.getGraphics2D();
        if (this.p.length > 0 && this.p[0] != null) {
            graphics2D.setStroke(this.featherStroke);
            int n = 0;
            while (n < this.photomesa.state.getFeatherDepth()) {
                graphics2D.setPaint(this.c[n]);
                graphics2D.draw(this.p[n]);
                ++n;
            }
        }
    }
}

