/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class Preferences
extends JPanel {
    static Preferences prefs = null;
    PhotoMesa photomesa = null;
    JSlider groupPaddingSlider = null;
    JSlider imagePaddingSlider = null;
    JSlider featherDepthSlider = null;
    JSlider colorBalanceSlider = null;
    JCheckBox showLabels = null;
    JSlider animationSpeedSlider = null;
    JCheckBox exportSizeCheckBox = null;
    JTextField exportSizeText = null;
    JLabel jpegQualityLabel = null;
    JSlider jpegSlider = null;
    JSlider aspectRatioSlider = null;
    JSlider thumbPenWidthSlider = null;
    JTextField controlFileNames = null;
    JCheckBox twoLevelNames = null;
    JRadioButton delayedPreview = null;
    JCheckBox rightButtonMenu = null;
    static JCheckBox askingBeforeDelete = null;
    JRadioButton globalLocation = null;
    JTextField thumbBaseDir = null;
    JTextField externalEditor = null;

    public static Preferences getPrefs(PhotoMesa photoMesa) {
        if (prefs == null) {
            prefs = new Preferences(photoMesa);
            prefs.setMinimumSize(new Dimension(0, 0));
        }
        return prefs;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        Dimension dimension2 = new Dimension(255, (int)dimension.getHeight());
        return dimension2;
    }

    void resetLayoutToDefaults() {
        this.photomesa.state.setGroupPadding(0.6);
        this.groupPaddingSlider.setValue((int)(this.photomesa.state.getGroupPadding() * 100.0));
        this.photomesa.state.setImagePadding(2);
        this.imagePaddingSlider.setValue(this.photomesa.state.getImagePadding() * 100);
        this.photomesa.state.setFeatherDepth(5);
        this.featherDepthSlider.setValue(this.photomesa.state.getFeatherDepth() * 100);
        this.photomesa.state.setColorBalance(0.0);
        this.colorBalanceSlider.setValue((int)(this.photomesa.state.getColorBalance() * 100.0));
        this.photomesa.state.setShowLabels(true);
        this.showLabels.setSelected(this.photomesa.state.getShowLabels());
        this.photomesa.state.setTwoLevelNames(false);
        this.twoLevelNames.setSelected(this.photomesa.state.getTwoLevelNames());
        this.photomesa.state.setThumbPenWidth(1);
        this.thumbPenWidthSlider.setValue(1);
        this.photomesa.state.setAspectRatio(1.5);
        this.aspectRatioSlider.setValue((int)Math.ceil(this.photomesa.state.getAspectRatio() * 10.0));
    }

    void resetInteractionToDefaults() {
        this.photomesa.state.setAnimationSpeed(1.0);
        this.animationSpeedSlider.setValue((int)(this.photomesa.state.getAnimationSpeed() * 100.0));
        this.photomesa.state.setPreviewType(3);
        this.delayedPreview.setSelected(true);
        this.photomesa.state.setRightButtonMenu(false);
        this.rightButtonMenu.setSelected(false);
        this.photomesa.state.setAskingBeforeDelete(true);
        askingBeforeDelete.setSelected(true);
    }

    void resetImportExportToDefaults() {
        this.exportSizeText.setText(Integer.toString(600));
        this.exportSizeText.setEnabled(true);
        this.photomesa.state.setExportImageSizeEnabled(true);
        this.jpegSlider.setEnabled(true);
        this.jpegQualityLabel.setEnabled(true);
        this.exportSizeCheckBox.setSelected(true);
        this.photomesa.state.setJPEGEncodeQuality(0.5f);
        this.jpegSlider.setValue((int)Math.ceil(this.photomesa.state.getJPEGEncodeQuality() * 10.0f));
        this.controlFileNames.setText("thumbs .xvpics");
        this.photomesa.state.setControlFileNames("thumbs .xvpics");
        this.externalEditor.setText("");
        this.photomesa.state.setImageEditor("");
        this.photomesa.state.setLocalThumbnails(false);
        this.globalLocation.setSelected(true);
        this.thumbBaseDir.setText(PhotoMesa.THUMB_BASE_DIR);
        this.thumbBaseDir.setEnabled(true);
        this.photomesa.state.setThumbBaseDir(PhotoMesa.THUMB_BASE_DIR);
    }

    private Preferences(final PhotoMesa photoMesa) {
        this.photomesa = photoMesa;
        JTabbedPane jTabbedPane = new JTabbedPane();
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("Image Layout Properties:"));
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        int n = (int)(photoMesa.state.getGroupPadding() * 100.0);
        JLabel jLabel = new JLabel("Space Between Groups: ");
        jLabel.setForeground(Color.black);
        this.groupPaddingSlider = new JSlider(0, 150, n);
        this.groupPaddingSlider.setMajorTickSpacing(10);
        this.groupPaddingSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (!Preferences.this.groupPaddingSlider.getValueIsAdjusting()) {
                    double d = (float)Preferences.this.groupPaddingSlider.getValue() / 100.0f;
                    photoMesa.state.setGroupPadding(d);
                }
            }
        });
        jPanel.add(jLabel);
        jPanel.add(this.groupPaddingSlider);
        n = photoMesa.state.getImagePadding() * 100;
        JLabel jLabel2 = new JLabel("Space Between Images: ");
        jLabel2.setForeground(Color.black);
        this.imagePaddingSlider = new JSlider(0, 1000, n);
        this.imagePaddingSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (!Preferences.this.imagePaddingSlider.getValueIsAdjusting()) {
                    int n = Preferences.this.imagePaddingSlider.getValue() / 100;
                    photoMesa.state.setImagePadding(n);
                }
            }
        });
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        jPanel.add(jLabel2);
        jPanel.add(this.imagePaddingSlider);
        n = photoMesa.state.getFeatherDepth() * 100;
        JLabel jLabel3 = new JLabel("Group Feathering: ");
        jLabel3.setForeground(Color.black);
        this.featherDepthSlider = new JSlider(0, 1000, n);
        this.featherDepthSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (!Preferences.this.featherDepthSlider.getValueIsAdjusting()) {
                    int n = Preferences.this.featherDepthSlider.getValue() / 100;
                    photoMesa.state.setFeatherDepth(n);
                }
            }
        });
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        jPanel.add(jLabel3);
        jPanel.add(this.featherDepthSlider);
        n = (int)(100.0 * photoMesa.state.getColorBalance());
        JLabel jLabel4 = new JLabel("Background Color Intensity: ");
        jLabel4.setForeground(Color.black);
        this.colorBalanceSlider = new JSlider(0, 100, n);
        this.colorBalanceSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (!Preferences.this.colorBalanceSlider.getValueIsAdjusting()) {
                    double d = (double)Preferences.this.colorBalanceSlider.getValue() / 100.0;
                    photoMesa.state.setColorBalance(d);
                }
            }
        });
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        jPanel.add(jLabel4);
        jPanel.add(this.colorBalanceSlider);
        n = photoMesa.state.getThumbPenWidth();
        JLabel jLabel5 = new JLabel("Thumbnail Border Width: ");
        jLabel5.setForeground(Color.black);
        this.thumbPenWidthSlider = new JSlider(0, 5, n);
        this.thumbPenWidthSlider.setMajorTickSpacing(1);
        this.thumbPenWidthSlider.setSnapToTicks(true);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        hashtable.put(new Integer(0), new JLabel("0"));
        hashtable.put(new Integer(1), new JLabel("1"));
        hashtable.put(new Integer(2), new JLabel("2"));
        hashtable.put(new Integer(3), new JLabel("3"));
        hashtable.put(new Integer(4), new JLabel("4"));
        hashtable.put(new Integer(5), new JLabel("5"));
        this.thumbPenWidthSlider.setLabelTable(hashtable);
        this.thumbPenWidthSlider.setPaintLabels(true);
        this.thumbPenWidthSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (!Preferences.this.thumbPenWidthSlider.getValueIsAdjusting()) {
                    int n = Preferences.this.thumbPenWidthSlider.getValue();
                    photoMesa.state.setThumbPenWidth(n);
                }
            }
        });
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        jPanel.add(jLabel5);
        jPanel.add(this.thumbPenWidthSlider);
        n = (int)(photoMesa.state.getAspectRatio() * 10.0);
        JLabel jLabel6 = new JLabel("Aspect Ratio (Width/Height): ");
        jLabel6.setForeground(Color.black);
        this.aspectRatioSlider = new JSlider(5, 20, n);
        this.aspectRatioSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (!Preferences.this.aspectRatioSlider.getValueIsAdjusting()) {
                    double d = (double)Preferences.this.aspectRatioSlider.getValue() / 10.0;
                    photoMesa.state.setAspectRatio(d);
                }
            }
        });
        this.aspectRatioSlider.setMajorTickSpacing(5);
        Hashtable<Integer, JLabel> hashtable2 = new Hashtable<Integer, JLabel>();
        hashtable2.put(new Integer(5), new JLabel("1/2"));
        hashtable2.put(new Integer(7), new JLabel("2/3"));
        hashtable2.put(new Integer(10), new JLabel("1/1"));
        hashtable2.put(new Integer(15), new JLabel("3/2"));
        hashtable2.put(new Integer(20), new JLabel("2/1"));
        this.aspectRatioSlider.setLabelTable(hashtable2);
        this.aspectRatioSlider.setPaintLabels(true);
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        jPanel.add(jLabel6);
        jPanel.add(this.aspectRatioSlider);
        this.showLabels = new JCheckBox("Show Labels");
        this.showLabels.setSelected(photoMesa.state.getShowLabels());
        this.showLabels.setForeground(Color.black);
        this.showLabels.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                photoMesa.state.setShowLabels(Preferences.this.showLabels.isSelected());
            }
        });
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        jPanel.add(this.showLabels);
        this.twoLevelNames = new JCheckBox("Two Level Labels");
        this.twoLevelNames.setSelected(photoMesa.state.getTwoLevelNames());
        this.twoLevelNames.setForeground(Color.black);
        this.twoLevelNames.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                photoMesa.state.setTwoLevelNames(Preferences.this.twoLevelNames.isSelected());
            }
        });
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        jPanel.add(this.twoLevelNames);
        jPanel.add(Box.createRigidArea(new Dimension(20, 20)));
        JButton jButton = new JButton("Reset to Defaults");
        jPanel.add(jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Preferences.this.resetLayoutToDefaults();
            }
        });
        jTabbedPane.addTab("Layout", jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder("Interaction Properties:"));
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JRadioButton jRadioButton = new JRadioButton("No Preview");
        jRadioButton.setSelected(0 == photoMesa.state.getPreviewType());
        jRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                photoMesa.state.setPreviewType(0);
                photoMesa.imagePane.stopPreview();
            }
        });
        JRadioButton jRadioButton2 = new JRadioButton("Immediate Preview");
        jRadioButton2.setSelected(1 == photoMesa.state.getPreviewType());
        jRadioButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                photoMesa.state.setPreviewType(1);
            }
        });
        JRadioButton jRadioButton3 = new JRadioButton("Tooltip Preview");
        jRadioButton3.setSelected(2 == photoMesa.state.getPreviewType());
        jRadioButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                photoMesa.state.setPreviewType(2);
            }
        });
        this.delayedPreview = new JRadioButton("Delayed Preview");
        this.delayedPreview.setSelected(3 == photoMesa.state.getPreviewType());
        this.delayedPreview.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                photoMesa.state.setPreviewType(3);
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(this.delayedPreview);
        JPanel jPanel3 = new JPanel(){

            public Dimension getMaximumSize() {
                Dimension dimension = super.getMaximumSize();
                Dimension dimension2 = super.getPreferredSize();
                Dimension dimension3 = new Dimension((int)dimension.getWidth(), (int)dimension2.getHeight());
                return dimension3;
            }
        };
        jPanel3.setBorder(BorderFactory.createTitledBorder("Preview Type:"));
        jPanel3.setLayout(new GridLayout(4, 1));
        jPanel3.add(jRadioButton);
        jPanel3.add(jRadioButton2);
        jPanel3.add(jRadioButton3);
        jPanel3.add(this.delayedPreview);
        jPanel2.add(jPanel3);
        n = (int)(200.0 - photoMesa.state.getAnimationSpeed() * 100.0);
        JLabel jLabel7 = new JLabel("Zoom Speed: ");
        jLabel7.setForeground(Color.black);
        this.animationSpeedSlider = new JSlider(0, 200, n);
        this.animationSpeedSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (!Preferences.this.animationSpeedSlider.getValueIsAdjusting()) {
                    double d = (float)(200 - Preferences.this.animationSpeedSlider.getValue()) / 100.0f;
                    photoMesa.state.setAnimationSpeed(d);
                }
            }
        });
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        jPanel4.add(jLabel7);
        jPanel4.add(this.animationSpeedSlider);
        this.rightButtonMenu = new JCheckBox("Right Button Popup Menu");
        this.rightButtonMenu.setSelected(photoMesa.state.getRightButtonMenu());
        this.rightButtonMenu.setForeground(Color.black);
        this.rightButtonMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                photoMesa.state.setRightButtonMenu(Preferences.this.rightButtonMenu.isSelected());
            }
        });
        jPanel4.add(Box.createRigidArea(new Dimension(10, 10)));
        jPanel4.add(this.rightButtonMenu);
        askingBeforeDelete = new JCheckBox("Confirm Before Delete Images:");
        askingBeforeDelete.setSelected(photoMesa.state.getAskingBeforeDelete());
        askingBeforeDelete.setForeground(Color.black);
        askingBeforeDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                photoMesa.state.setAskingBeforeDelete(askingBeforeDelete.isSelected());
            }
        });
        jPanel4.add(Box.createRigidArea(new Dimension(10, 10)));
        jPanel4.add(askingBeforeDelete);
        JButton jButton2 = new JButton("Reset to Defaults"){

            public float getAlignmentX() {
                return 0.0f;
            }
        };
        jPanel4.add(Box.createRigidArea(new Dimension(10, 20)));
        jPanel4.add(jButton2);
        jPanel2.add(Box.createRigidArea(new Dimension(10, 10)));
        jPanel2.add(jPanel4);
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Preferences.this.resetInteractionToDefaults();
            }
        });
        jTabbedPane.addTab("Interaction", jPanel2);
        JPanel jPanel5 = new JPanel();
        jPanel5.setBorder(BorderFactory.createTitledBorder("Import and Export Properties:"));
        jPanel5.setLayout(new BoxLayout(jPanel5, 1));
        this.thumbBaseDir = new JTextField(20){

            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }

            public float getAlignmentX() {
                return 0.0f;
            }
        };
        this.thumbBaseDir.setText(photoMesa.state.getThumbBaseDir());
        this.thumbBaseDir.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                photoMesa.state.setThumbBaseDir(Preferences.this.thumbBaseDir.getText());
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                photoMesa.state.setThumbBaseDir(Preferences.this.thumbBaseDir.getText());
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                photoMesa.state.setThumbBaseDir(Preferences.this.thumbBaseDir.getText());
            }
        });
        if (photoMesa.state.getLocalThumbnails()) {
            this.thumbBaseDir.setEnabled(false);
        }
        this.globalLocation = new JRadioButton("Central location");
        this.globalLocation.setSelected(!photoMesa.state.getLocalThumbnails());
        this.globalLocation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                photoMesa.state.setLocalThumbnails(false);
                Preferences.this.thumbBaseDir.setText(photoMesa.state.getThumbBaseDir());
                Preferences.this.thumbBaseDir.setEnabled(true);
            }
        });
        JRadioButton jRadioButton4 = new JRadioButton("Distributed with images");
        jRadioButton4.setSelected(photoMesa.state.getLocalThumbnails());
        jRadioButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                photoMesa.state.setLocalThumbnails(true);
                Preferences.this.thumbBaseDir.setEnabled(false);
            }
        });
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.globalLocation);
        buttonGroup2.add(jRadioButton4);
        JPanel jPanel6 = new JPanel(){

            public Dimension getMaximumSize() {
                Dimension dimension = super.getMaximumSize();
                Dimension dimension2 = super.getPreferredSize();
                Dimension dimension3 = new Dimension((int)dimension.getWidth(), (int)dimension2.getHeight());
                return dimension3;
            }
        };
        jPanel6.setBorder(BorderFactory.createTitledBorder("Thumbnail Location:"));
        jPanel6.setLayout(new GridLayout(2, 1));
        jPanel6.add(this.globalLocation);
        jPanel6.add(this.thumbBaseDir);
        jPanel6.add(jRadioButton4);
        jPanel5.add(Box.createRigidArea(new Dimension(10, 10)));
        jPanel5.add(jPanel6);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BoxLayout(jPanel7, 1));
        this.exportSizeCheckBox = new JCheckBox("Export Image Size (pixels):");
        this.exportSizeCheckBox.setSelected(photoMesa.state.getExportImageSizeEnabled());
        this.exportSizeText = new JTextField(5){

            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }

            public float getAlignmentX() {
                return 0.0f;
            }
        };
        this.exportSizeText.setDocument(new PlainDocument(){

            public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
                try {
                    int n2 = Integer.parseInt(string);
                    super.insertString(n, string, attributeSet);
                }
                catch (Exception exception) {
                    String[] stringArray = new String[]{"Invalid number: " + string, "Must be an integer"};
                    JOptionPane.showMessageDialog(photoMesa.getImagePane(), stringArray, "PhotoMesa Information", 0);
                }
            }
        });
        this.exportSizeText.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
            }

            public void insertUpdate(DocumentEvent documentEvent) {
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                try {
                    String string = Preferences.this.exportSizeText.getText();
                    if (string == null || string.length() == 0) {
                        photoMesa.state.setExportImageSize(600);
                        return;
                    }
                    int n = Integer.parseInt(string);
                    photoMesa.state.setExportImageSize(n);
                }
                catch (Exception exception) {
                    String[] stringArray = new String[]{"Invalid number: " + Preferences.this.exportSizeText.getText(), "Must be an integer"};
                    JOptionPane.showMessageDialog(photoMesa.getImagePane(), stringArray, "PhotoMesa Information", 0);
                }
            }
        });
        this.exportSizeText.setText(Integer.toString(photoMesa.state.getExportImageSize()));
        this.exportSizeText.setEnabled(photoMesa.state.getExportImageSizeEnabled());
        this.exportSizeCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (Preferences.this.exportSizeCheckBox.isSelected()) {
                    Preferences.this.exportSizeText.setEnabled(true);
                    Preferences.this.exportSizeText.setText(Integer.toString(photoMesa.state.getExportImageSize()));
                    Preferences.this.jpegSlider.setEnabled(true);
                    Preferences.this.jpegQualityLabel.setEnabled(true);
                    photoMesa.state.setExportImageSizeEnabled(true);
                } else {
                    Preferences.this.exportSizeText.setEnabled(false);
                    Preferences.this.jpegSlider.setEnabled(false);
                    Preferences.this.jpegQualityLabel.setEnabled(false);
                    photoMesa.state.setExportImageSizeEnabled(false);
                }
            }
        });
        jPanel7.add(this.exportSizeCheckBox);
        jPanel7.add(this.exportSizeText);
        n = (int)Math.ceil(photoMesa.state.getJPEGEncodeQuality() * 10.0f);
        this.jpegQualityLabel = new JLabel("Export JPEG Quality: ");
        this.jpegQualityLabel.setForeground(Color.black);
        this.jpegQualityLabel.setEnabled(photoMesa.state.getExportImageSizeEnabled());
        this.jpegSlider = new JSlider(0, 10, n);
        this.jpegSlider.setEnabled(photoMesa.state.getExportImageSizeEnabled());
        this.jpegSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (!Preferences.this.jpegSlider.getValueIsAdjusting()) {
                    float f = (float)Preferences.this.jpegSlider.getValue() / 10.0f;
                    photoMesa.state.setJPEGEncodeQuality(f);
                }
            }
        });
        jPanel7.add(Box.createRigidArea(new Dimension(10, 10)));
        jPanel7.add(this.jpegQualityLabel);
        jPanel7.add(this.jpegSlider);
        JLabel jLabel8 = new JLabel("Excluded Directories : ");
        jLabel8.setForeground(Color.black);
        this.controlFileNames = new JTextField(20){

            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }

            public float getAlignmentX() {
                return 0.0f;
            }
        };
        this.controlFileNames.setText(photoMesa.state.getControlFileNames());
        this.controlFileNames.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                photoMesa.state.setControlFileNames(Preferences.this.controlFileNames.getText());
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                photoMesa.state.setControlFileNames(Preferences.this.controlFileNames.getText());
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                photoMesa.state.setControlFileNames(Preferences.this.controlFileNames.getText());
            }
        });
        jPanel7.add(Box.createRigidArea(new Dimension(20, 10)));
        jPanel7.add(jLabel8);
        jPanel7.add(this.controlFileNames);
        JLabel jLabel9 = new JLabel("Image Editor : ");
        jLabel9.setForeground(Color.black);
        this.externalEditor = new JTextField(20){

            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }

            public float getAlignmentX() {
                return 0.0f;
            }
        };
        this.externalEditor.setText(photoMesa.state.getImageEditor());
        this.externalEditor.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                photoMesa.state.setImageEditor(Preferences.this.externalEditor.getText());
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                photoMesa.state.setImageEditor(Preferences.this.externalEditor.getText());
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                photoMesa.state.setImageEditor(Preferences.this.externalEditor.getText());
            }
        });
        jPanel7.add(Box.createRigidArea(new Dimension(10, 20)));
        jPanel7.add(jLabel9);
        jPanel7.add(this.externalEditor);
        jPanel7.add(Box.createRigidArea(new Dimension(10, 20)));
        JButton jButton3 = new JButton("Reset to Default");
        jPanel7.add(jButton3);
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Preferences.this.resetImportExportToDefaults();
            }
        });
        jPanel5.add(Box.createRigidArea(new Dimension(10, 10)));
        jPanel5.add(jPanel7);
        jTabbedPane.addTab("Import&Export", jPanel5);
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setVgap(1);
        borderLayout.setHgap(1);
        this.setLayout(borderLayout);
        this.add(jTabbedPane);
        jPanel.addMouseListener(new MouseAdapter(){

            public void mouseExited(MouseEvent mouseEvent) {
                photoMesa.imagePane.requestFocus();
            }
        });
        jPanel2.addMouseListener(new MouseAdapter(){

            public void mouseExited(MouseEvent mouseEvent) {
                photoMesa.imagePane.requestFocus();
            }
        });
        jPanel5.addMouseListener(new MouseAdapter(){

            public void mouseExited(MouseEvent mouseEvent) {
                photoMesa.imagePane.requestFocus();
            }
        });
    }
}

