/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Iterator;

public class State
implements Serializable {
    static Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    transient PhotoMesa photomesa = null;
    Rectangle windowBounds;
    File currentDirectory = new File("/");
    int exportImageSize = 600;
    boolean exportImageSizeEnabled = true;
    float jpegEncodeQuality = 0.5f;
    boolean showLabels = true;
    double groupPadding = 0.6;
    int imagePadding = 2;
    int featherDepth = 5;
    double animationSpeed = 1.0;
    int layoutType = 1;
    int sortType = 1;
    int groupType = 1;
    int previewType = 3;
    double colorBalance = 0.0;
    double aspectRatio = 1.5;
    int thumbPenWidth = 1;
    String controlFileNames = "thumbs .xvpics";
    boolean twoLevelNames = false;
    boolean rightButtonMenu = false;
    boolean askingBeforeDelete = true;
    boolean localThumbnails = false;
    String thumbBaseDir = PhotoMesa.THUMB_BASE_DIR;
    String imageEditor = "";

    public State() {
        this.windowBounds = new Rectangle(State.screenSize.width / 2 - 512, State.screenSize.height / 2 - 360, 1024, 720);
    }

    public void setPhotoMesa(PhotoMesa photoMesa) {
        this.photomesa = photoMesa;
    }

    public void setWindowBounds(Rectangle rectangle) {
        this.windowBounds = rectangle;
    }

    public Rectangle getWindowBounds() {
        return this.windowBounds;
    }

    public void setCurrentDirectory(File file) {
        this.currentDirectory = file;
    }

    public File getCurrentDirectory() {
        return this.currentDirectory;
    }

    void setExportImageSize(int n) {
        this.exportImageSize = n;
    }

    int getExportImageSize() {
        return this.exportImageSize;
    }

    void setExportImageSizeEnabled(boolean bl) {
        this.exportImageSizeEnabled = bl;
    }

    boolean getExportImageSizeEnabled() {
        return this.exportImageSizeEnabled;
    }

    void setJPEGEncodeQuality(float f) {
        this.jpegEncodeQuality = f;
    }

    float getJPEGEncodeQuality() {
        return this.jpegEncodeQuality;
    }

    void setShowLabels(boolean bl) {
        this.showLabels = bl;
        this.photomesa.getImagePane().updateLabels();
    }

    boolean getShowLabels() {
        return this.showLabels;
    }

    void setGroupPadding(double d) {
        this.groupPadding = d;
        this.photomesa.reLayout();
    }

    double getGroupPadding() {
        return this.groupPadding;
    }

    void setImagePadding(int n) {
        this.imagePadding = n;
        this.photomesa.reLayout();
    }

    int getImagePadding() {
        return this.imagePadding;
    }

    void setFeatherDepth(int n) {
        this.featherDepth = n;
        this.photomesa.reFeather();
    }

    int getFeatherDepth() {
        return this.featherDepth;
    }

    void setAnimationSpeed(double d) {
        this.animationSpeed = d;
    }

    double getAnimationSpeed() {
        return this.animationSpeed;
    }

    void setColorBalance(double d) {
        this.colorBalance = d;
        Iterator iterator = this.photomesa.regions.iterator();
        while (iterator.hasNext()) {
            Region region = (Region)iterator.next();
            region.updateColor();
        }
    }

    double getColorBalance() {
        return this.colorBalance;
    }

    void setLayoutType(int n) {
        this.layoutType = n;
        this.photomesa.reLayout();
    }

    int getLayoutType() {
        return this.layoutType;
    }

    void setSortType(int n) {
        this.sortType = n;
        this.photomesa.sort();
        this.photomesa.reLayout();
    }

    int getSortType() {
        return this.sortType;
    }

    void setGroupType(int n) {
        this.groupType = n;
        this.photomesa.loadFile(this.currentDirectory);
    }

    int getGroupType() {
        return this.groupType;
    }

    void setPreviewType(int n) {
        this.previewType = n;
    }

    int getPreviewType() {
        return this.previewType;
    }

    void setRightButtonMenu(boolean bl) {
        this.rightButtonMenu = bl;
    }

    boolean getRightButtonMenu() {
        return this.rightButtonMenu;
    }

    void setAskingBeforeDelete(boolean bl) {
        this.askingBeforeDelete = bl;
    }

    boolean getAskingBeforeDelete() {
        return this.askingBeforeDelete;
    }

    void setLocalThumbnails(boolean bl) {
        this.localThumbnails = bl;
        this.photomesa.reGroup();
    }

    boolean getLocalThumbnails() {
        return this.localThumbnails;
    }

    void setAspectRatio(double d) {
        this.aspectRatio = d;
        this.photomesa.reLayout();
    }

    double getAspectRatio() {
        return this.aspectRatio;
    }

    void setThumbPenWidth(int n) {
        this.thumbPenWidth = n;
        this.photomesa.imagePane.updateThumbBorderWidth();
    }

    int getThumbPenWidth() {
        return this.thumbPenWidth;
    }

    void setControlFileNames(String string) {
        this.controlFileNames = string;
    }

    String getControlFileNames() {
        return this.controlFileNames;
    }

    void setTwoLevelNames(boolean bl) {
        this.twoLevelNames = bl;
        this.photomesa.updateLabels(bl);
    }

    boolean getTwoLevelNames() {
        return this.twoLevelNames;
    }

    void setThumbBaseDir(String string) {
        this.thumbBaseDir = string;
    }

    String getThumbBaseDir() {
        return this.thumbBaseDir;
    }

    void setImageEditor(String string) {
        this.imageEditor = string;
    }

    String getImageEditor() {
        return this.imageEditor;
    }

    public void save(PhotoMesa photoMesa) {
        FileOutputStream fileOutputStream = null;
        ObjectOutputStream objectOutputStream = null;
        String string = State.getStateFileName(photoMesa);
        try {
            fileOutputStream = new FileOutputStream(string);
            objectOutputStream = new ObjectOutputStream(fileOutputStream);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            objectOutputStream.writeObject(this);
            objectOutputStream.flush();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static State restore(PhotoMesa photoMesa) {
        FileInputStream fileInputStream = null;
        ObjectInputStream objectInputStream = null;
        State state = null;
        String string = State.getStateFileName(photoMesa);
        try {
            fileInputStream = new FileInputStream(string);
            objectInputStream = new ObjectInputStream(fileInputStream);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (objectInputStream != null) {
            try {
                state = (State)objectInputStream.readObject();
                fileInputStream.close();
            }
            catch (Exception exception) {
                state = null;
            }
        }
        if (state == null) {
            state = new State();
        }
        state.setPhotoMesa(photoMesa);
        return state;
    }

    public static String getStateFileName(PhotoMesa photoMesa) {
        String string = photoMesa.getAppDir() + File.separator + ".photomesa.state";
        return string;
    }
}

