/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz;

import edu.umd.cs.jazz.ZDrawingSurface;
import edu.umd.cs.jazz.ZLayerGroup;
import edu.umd.cs.jazz.ZNode;
import edu.umd.cs.jazz.ZRoot;
import edu.umd.cs.jazz.ZTransformGroup;
import edu.umd.cs.jazz.ZTransformable;
import edu.umd.cs.jazz.ZVisualComponent;
import edu.umd.cs.jazz.component.ZFillColor;
import edu.umd.cs.jazz.event.ZCameraEvent;
import edu.umd.cs.jazz.event.ZCameraListener;
import edu.umd.cs.jazz.io.ZObjectOutputStream;
import edu.umd.cs.jazz.util.ZBounds;
import edu.umd.cs.jazz.util.ZDebug;
import edu.umd.cs.jazz.util.ZFindFilter;
import edu.umd.cs.jazz.util.ZList;
import edu.umd.cs.jazz.util.ZListImpl;
import edu.umd.cs.jazz.util.ZNodeNotFoundException;
import edu.umd.cs.jazz.util.ZNoninvertibleTransformException;
import edu.umd.cs.jazz.util.ZObjectReferenceTable;
import edu.umd.cs.jazz.util.ZRenderContext;
import edu.umd.cs.jazz.util.ZRenderContextFactory;
import edu.umd.cs.jazz.util.ZSceneGraphPath;
import edu.umd.cs.jazz.util.ZUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;

public class ZCamera
extends ZVisualComponent
implements ZFillColor,
ZTransformable,
Serializable {
    public static final Color fillColor_DEFAULT = Color.white;
    private AffineTransform viewTransform;
    private AffineTransform originalViewTransform = null;
    private AffineTransform inverseViewTransform = null;
    private transient boolean inverseViewTransformDirty = true;
    private ZList.ZLayerGroupList layers = ZListImpl.NullList;
    private Color fillColor = fillColor_DEFAULT;
    private transient ZDrawingSurface surface = null;
    private transient int debugRenderCount = 0;
    private transient ZRenderContext renderContext = null;
    private ZBounds paintBounds;
    private transient ZBounds tmpBounds = new ZBounds();
    private static ZRenderContextFactory renderContextFactory = new ZRenderContextFactory(){

        public ZRenderContext createRenderContext(ZCamera camera) {
            return new ZRenderContext(camera);
        }

        public ZRenderContext createRenderContext(Graphics2D aG2, ZBounds visibleBounds, ZDrawingSurface aSurface, int qualityRequested) {
            return new ZRenderContext(aG2, visibleBounds, aSurface, qualityRequested);
        }
    };
    static /* synthetic */ Class class$edu$umd$cs$jazz$event$ZCameraListener;

    public ZCamera() {
        this(null, null);
    }

    public ZCamera(ZLayerGroup layer, ZDrawingSurface aSurface) {
        this.surface = aSurface;
        this.viewTransform = new AffineTransform();
        this.originalViewTransform = new AffineTransform();
        this.paintBounds = new ZBounds();
        this.renderContext = this.createRenderContext(this);
        this.addLayer(layer);
    }

    protected Object duplicateObject() {
        ZCamera newCamera = (ZCamera)super.duplicateObject();
        newCamera.viewTransform = this.getViewTransform();
        newCamera.originalViewTransform = new AffineTransform();
        newCamera.paintBounds = new ZBounds();
        newCamera.tmpBounds = new ZBounds();
        newCamera.surface = null;
        newCamera.debugRenderCount = 0;
        newCamera.inverseViewTransform = null;
        newCamera.inverseViewTransformDirty = true;
        if (!this.layers.isNull()) {
            newCamera.layers = (ZList.ZLayerGroupList)this.layers.clone();
        }
        return newCamera;
    }

    protected void updateObjectReferences(ZObjectReferenceTable objRefTable) {
        super.updateObjectReferences(objRefTable);
        ZLayerGroup[] layersRef = this.layers.getLayersReference();
        int i = 0;
        while (i < this.layers.size()) {
            ZLayerGroup newLayer = (ZLayerGroup)objRefTable.getNewObjectReference(layersRef[i]);
            if (newLayer == null) {
                layersRef[i].addCamera(this);
            } else {
                layersRef[i] = newLayer;
            }
            ++i;
        }
    }

    public static void setRenderContextFactory(ZRenderContextFactory factory) {
        renderContextFactory = factory;
    }

    public ZRenderContext createRenderContext(ZCamera camera) {
        return renderContextFactory.createRenderContext(camera);
    }

    public ZRenderContext createRenderContext(Graphics2D aG2, ZBounds visibleBounds, ZDrawingSurface aSurface, int qualityRequested) {
        return renderContextFactory.createRenderContext(aG2, visibleBounds, aSurface, qualityRequested);
    }

    public void trimToSize() {
        super.trimToSize();
        this.layers.trimToSize();
    }

    public void addLayer(ZLayerGroup layer) {
        if (layer == null) {
            return;
        }
        if (this.layers.isNull()) {
            this.layers = new ZListImpl.ZLayerGroupListImpl(1);
        }
        if (this.layers.contains(layer)) {
            return;
        }
        this.layers.add(layer);
        layer.addCamera(this);
    }

    public void removeLayer(ZLayerGroup layer) {
        if (this.layers.remove(layer)) {
            layer.removeCamera(this);
        }
    }

    public void replaceLayer(ZLayerGroup original, ZLayerGroup replacement) {
        if (this.layers.replaceWith(original, replacement)) {
            original.removeCamera(this);
            replacement.addCamera(this);
        }
    }

    public ZLayerGroup[] getLayers() {
        return (ZLayerGroup[])this.layers.toArray();
    }

    public ZLayerGroup[] getLayersReference() {
        return this.layers.getLayersReference();
    }

    public int getNumLayers() {
        return this.layers.size();
    }

    public ZDrawingSurface getDrawingSurface() {
        return this.surface;
    }

    public void setDrawingSurface(ZDrawingSurface aSurface) {
        this.surface = aSurface;
        this.repaint();
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color aColor) {
        this.fillColor = aColor;
        this.repaint();
    }

    public ZBounds getViewBounds() {
        ZBounds result = this.getBounds();
        this.cameraToLocal(result, null);
        return result;
    }

    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(new ZBounds(x, y, w, h));
        this.reshape();
    }

    public void setBounds(Rectangle2D newBounds) {
        super.setBounds(new ZBounds(newBounds));
        this.reshape();
    }

    public double getMagnification() {
        return Math.max(this.viewTransform.getScaleX(), this.viewTransform.getScaleY());
    }

    public void repaint() {
        super.repaint();
        if (!this.inTransaction && this.surface != null) {
            this.surface.repaint(this.getBoundsReference());
        }
    }

    public void repaint(ZBounds repaintBounds) {
        if (ZDebug.debugRepaint) {
            System.out.println("ZCamera.repaint(bounds): this = " + this);
        }
        if (this.inTransaction || repaintBounds.isEmpty()) {
            return;
        }
        ZRoot root = this.getRoot();
        if (root != null) {
            root.setCurrentRenderContext(this.renderContext);
        }
        this.tmpBounds.setRect(repaintBounds);
        ZTransformGroup.transform(this.tmpBounds, this.viewTransform);
        ZBounds bounds = this.getBoundsReference();
        float x1 = Math.max((float)this.tmpBounds.getMinX(), (float)bounds.getMinX());
        float y1 = Math.max((float)this.tmpBounds.getMinY(), (float)bounds.getMinY());
        float x2 = Math.min((float)this.tmpBounds.getMaxX(), (float)bounds.getMaxX());
        float y2 = Math.min((float)this.tmpBounds.getMaxY(), (float)bounds.getMaxY());
        if (x1 >= x2 || y1 >= y2) {
            return;
        }
        this.tmpBounds.setRect(x1, y1, x2 - x1, y2 - y1);
        repaintBounds.setRect(this.tmpBounds);
        this.parents.collectiveRepaint(repaintBounds);
        if (this.surface != null) {
            this.surface.repaint(this.tmpBounds);
        }
        if (root != null) {
            root.setCurrentRenderContext(null);
        }
    }

    public void render(ZRenderContext renderContext) {
        Graphics2D g2 = renderContext.getGraphics2D();
        ZBounds visibleBounds = renderContext.getVisibleBounds();
        ZBounds cameraBounds = this.getBoundsReference();
        boolean paintingWholeCamera = false;
        AffineTransform saveTransform = g2.getTransform();
        Shape saveClip = g2.getClip();
        if (visibleBounds.contains(cameraBounds)) {
            paintingWholeCamera = true;
        }
        renderContext.pushCamera(this);
        if (renderContext.getDrawingSurface().getCamera() != renderContext.getRenderingCamera()) {
            if (ZDebug.debugRender) {
                System.out.println("ZCamera.render: clipping to camera bounds = " + cameraBounds);
            }
            g2.clip(cameraBounds);
        }
        this.paintBounds.reset();
        this.paintBounds.add(visibleBounds);
        this.paintBounds.transform(this.getInverseViewTransformReference());
        renderContext.pushVisibleBounds(this.paintBounds);
        g2.transform(this.viewTransform);
        if (!paintingWholeCamera) {
            if (ZDebug.debugRender) {
                System.out.println("ZCamera.render: clipping to paint bounds = " + this.paintBounds);
            }
            g2.clip(this.paintBounds);
        }
        if (this.fillColor != null) {
            g2.setColor(this.fillColor);
            g2.fill(this.paintBounds);
        }
        if (ZDebug.debugRender) {
            System.out.println("ZCamera.render");
            System.out.println("ZCamera.render: xformed visible bounds = " + this.paintBounds);
            System.out.println("ZCamera.render: camera bounds = " + cameraBounds);
            System.out.println("ZCamera.render: transform = " + g2.getTransform());
            System.out.println("ZCamera.render: clip = " + g2.getClip().getBounds2D());
        }
        AffineTransform origTransform = g2.getTransform();
        ZLayerGroup[] layersRef = this.getLayersReference();
        int i = 0;
        while (i < this.getNumLayers()) {
            ZLayerGroup layer = layersRef[i];
            g2.transform(layer.getParent().getLocalToGlobalTransform());
            layer.render(renderContext);
            g2.setTransform(origTransform);
            ++i;
        }
        renderContext.popVisibleBounds();
        renderContext.popCamera();
        g2.setTransform(saveTransform);
        g2.setClip(saveClip);
        if (ZDebug.debugRegionMgmt && !paintingWholeCamera) {
            this.paintBounds.reset();
            this.paintBounds.add(visibleBounds);
            int color = 100 + this.debugRenderCount % 10 * 10;
            g2.setColor(new Color(color, color, color, 150));
            g2.fill(this.paintBounds);
            ++this.debugRenderCount;
        }
    }

    public ZRoot getRoot() {
        return this.layers.size() > 0 ? ((ZLayerGroup)this.layers.get(0)).getRoot() : null;
    }

    public boolean pick(Rectangle2D rect, ZSceneGraphPath path) {
        Rectangle2D viewRect = (Rectangle2D)rect.clone();
        Rectangle2D.Double transformedRect = new Rectangle2D.Double();
        if (!this.getBoundsReference().intersects(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight())) {
            return false;
        }
        path.push(this);
        path.pushCamera(this);
        path.pushTransformer(this);
        AffineTransform origTm = path.getTransform();
        AffineTransform tm = new AffineTransform(origTm);
        tm.concatenate(this.viewTransform);
        path.setTransform(tm);
        path.setCameraTransform(origTm);
        AffineTransform inverse = this.getInverseViewTransformReference();
        ZTransformGroup.transform(viewRect, inverse);
        ZLayerGroup[] layersRef = this.getLayersReference();
        int i = this.layers.size() - 1;
        while (i >= 0) {
            ZLayerGroup layer = layersRef[i];
            AffineTransform localToGlobal = layer.getLocalToGlobalTransform();
            try {
                AffineTransform globalToLocal = localToGlobal.createInverse();
                ((Rectangle2D)transformedRect).setRect(viewRect);
                ZTransformGroup.transform(transformedRect, globalToLocal);
                if (layer.pick(transformedRect, path)) {
                    return true;
                }
            }
            catch (NoninvertibleTransformException e) {
                throw new ZNoninvertibleTransformException(e);
            }
            --i;
        }
        return true;
    }

    public ArrayList findNodes(ZFindFilter filter) {
        ArrayList result = new ArrayList();
        this.findNodes(filter, result);
        return result;
    }

    int findNodes(ZFindFilter filter, ArrayList nodes) {
        int nodesSearched = 0;
        ZLayerGroup[] layersRef = this.getLayersReference();
        int i = 0;
        while (i < this.layers.size()) {
            nodesSearched += layersRef[i].findNodes(filter, nodes);
            ++i;
        }
        return nodesSearched;
    }

    public String dump() {
        String str = super.dump();
        str = str + "\n View Bounds:   " + this.getViewBounds() + "\n View Transform: " + this.getViewTransform();
        int i = 0;
        while (i < this.layers.size()) {
            str = str + "\n Layer: " + this.layers.get(i);
            ++i;
        }
        return str;
    }

    public void addCameraListener(ZCameraListener l) {
        this.getListenerList().add(class$edu$umd$cs$jazz$event$ZCameraListener == null ? (class$edu$umd$cs$jazz$event$ZCameraListener = ZCamera.class$("edu.umd.cs.jazz.event.ZCameraListener")) : class$edu$umd$cs$jazz$event$ZCameraListener, l);
    }

    public void removeCameraListener(ZCameraListener l) {
        this.removeEventListener(class$edu$umd$cs$jazz$event$ZCameraListener == null ? (class$edu$umd$cs$jazz$event$ZCameraListener = ZCamera.class$("edu.umd.cs.jazz.event.ZCameraListener")) : class$edu$umd$cs$jazz$event$ZCameraListener, l);
    }

    public void getMatrix(double[] matrix) {
        this.viewTransform.getMatrix(matrix);
    }

    public void setTransform(double m00, double m10, double m01, double m11, double m02, double m12) {
        this.setViewTransform(m00, m10, m01, m11, m02, m12);
    }

    public AffineTransform getViewTransform() {
        return (AffineTransform)this.viewTransform.clone();
    }

    protected void computeInverseViewTransform() {
        try {
            this.inverseViewTransform = this.viewTransform.createInverse();
            this.inverseViewTransformDirty = false;
        }
        catch (NoninvertibleTransformException e) {
            throw new ZNoninvertibleTransformException(e);
        }
    }

    public AffineTransform getInverseViewTransform() {
        return (AffineTransform)this.getInverseViewTransformReference().clone();
    }

    public AffineTransform getInverseViewTransformReference() {
        if (this.inverseViewTransformDirty) {
            this.computeInverseViewTransform();
        }
        return this.inverseViewTransform;
    }

    public void setViewTransform(AffineTransform transform) {
        this.originalViewTransform.setTransform(this.viewTransform);
        this.viewTransform.setTransform(transform);
        this.inverseViewTransformDirty = true;
        if (this.hasListenerOfType(class$edu$umd$cs$jazz$event$ZCameraListener == null ? (class$edu$umd$cs$jazz$event$ZCameraListener = ZCamera.class$("edu.umd.cs.jazz.event.ZCameraListener")) : class$edu$umd$cs$jazz$event$ZCameraListener)) {
            this.fireEvent(ZCameraEvent.createViewChangedEvent(this, this.originalViewTransform));
        }
        this.repaint();
    }

    public void setViewTransform(double m00, double m10, double m01, double m11, double m02, double m12) {
        this.originalViewTransform.setTransform(this.viewTransform);
        this.viewTransform.setTransform(m00, m10, m01, m11, m02, m12);
        this.inverseViewTransformDirty = true;
        if (this.hasListenerOfType(class$edu$umd$cs$jazz$event$ZCameraListener == null ? (class$edu$umd$cs$jazz$event$ZCameraListener = ZCamera.class$("edu.umd.cs.jazz.event.ZCameraListener")) : class$edu$umd$cs$jazz$event$ZCameraListener)) {
            this.fireEvent(ZCameraEvent.createViewChangedEvent(this, this.originalViewTransform));
        }
        this.repaint();
    }

    public double cameraToLocal(Point2D pt, ZNode node) {
        AffineTransform inverse = this.getInverseViewTransformReference();
        inverse.transform(pt, pt);
        double dz = Math.max(inverse.getScaleX(), inverse.getScaleY());
        if (node != null) {
            ZLayerGroup layer = this.getAncestorLayerFor(node);
            if (layer == null) {
                throw new ZNodeNotFoundException("Node " + node + " is not accessible from camera " + this);
            }
            dz *= node.globalToLocal(pt);
        }
        return dz;
    }

    public double cameraToLocal(Dimension2D aDimension, ZNode node) {
        double dz = 0.0;
        try {
            dz = ZUtil.inverseTransformDimension(aDimension, this.viewTransform);
        }
        catch (NoninvertibleTransformException e) {
            throw new ZNoninvertibleTransformException(e);
        }
        if (node != null) {
            ZLayerGroup layer = this.getAncestorLayerFor(node);
            if (layer == null) {
                throw new ZNodeNotFoundException("Node " + node + " is not accessible from camera " + this);
            }
            dz *= node.globalToLocal(aDimension);
        }
        return dz;
    }

    public double cameraToLocal(Rectangle2D rect, ZNode node) {
        AffineTransform inverse = this.getInverseViewTransformReference();
        ZTransformGroup.transform(rect, inverse);
        double dz = Math.max(inverse.getScaleX(), inverse.getScaleY());
        if (node != null) {
            ZLayerGroup layer = this.getAncestorLayerFor(node);
            if (layer == null) {
                throw new ZNodeNotFoundException("Node " + node + " is not accessible from camera " + this);
            }
            dz *= node.globalToLocal(rect);
        }
        return dz;
    }

    public double localToCamera(Point2D pt, ZNode node) {
        double dz = 1.0;
        if (node != null) {
            ZLayerGroup layer = this.getAncestorLayerFor(node);
            if (layer == null) {
                throw new ZNodeNotFoundException("Node " + node + " is not accessible from camera " + this);
            }
            dz *= node.localToGlobal(pt);
        }
        this.viewTransform.transform(pt, pt);
        return dz *= Math.max(this.viewTransform.getScaleX(), this.viewTransform.getScaleY());
    }

    public double localToCamera(Dimension2D aDimension, ZNode node) {
        double dz = 1.0;
        if (node != null) {
            ZLayerGroup layer = this.getAncestorLayerFor(node);
            if (layer == null) {
                throw new ZNodeNotFoundException("Node " + node + " is not accessible from camera " + this);
            }
            dz *= node.localToGlobal(aDimension);
        }
        return dz *= ZUtil.transformDimension(aDimension, this.viewTransform);
    }

    public double localToCamera(Rectangle2D rect, ZNode node) {
        double dz = 1.0;
        if (node != null) {
            ZLayerGroup layer = this.getAncestorLayerFor(node);
            if (layer == null) {
                throw new ZNodeNotFoundException("Node " + node + " is not accessible from camera " + this);
            }
            dz *= node.localToGlobal(rect);
        }
        ZTransformGroup.transform(rect, this.viewTransform);
        return dz *= Math.max(this.viewTransform.getScaleX(), this.viewTransform.getScaleY());
    }

    public void center(Rectangle2D refBounds, int millis, ZDrawingSurface aSurface) {
        double dy;
        AffineTransform at = new AffineTransform();
        ZBounds bounds = this.getBoundsReference();
        double dx = bounds.getWidth() / refBounds.getWidth();
        double scale = dx < (dy = bounds.getHeight() / refBounds.getHeight()) ? dx : dy;
        double ctrX = 0.5 * bounds.getWidth();
        double ctrY = 0.5 * bounds.getHeight();
        double refBoundsX = refBounds.getX() + 0.5 * refBounds.getWidth();
        double refBoundsY = refBounds.getY() + 0.5 * refBounds.getHeight();
        at.translate(ctrX + -refBoundsX * scale, ctrY + -refBoundsY * scale);
        at.scale(scale, scale);
        this.animate(at, millis, aSurface);
    }

    public void center(Rectangle2D srcBounds, Rectangle2D destBounds, int millis, ZDrawingSurface surface) {
        double by;
        double bx;
        double bh;
        double bw;
        double dy;
        double dx = srcBounds.getWidth() / destBounds.getWidth();
        if (dx < (dy = srcBounds.getHeight() / destBounds.getHeight())) {
            bw = destBounds.getWidth() / destBounds.getHeight() * srcBounds.getHeight();
            bh = srcBounds.getHeight();
            bx = srcBounds.getX() + 0.5 * srcBounds.getWidth() - 0.5 * bw;
            by = srcBounds.getY();
        } else {
            bw = srcBounds.getWidth();
            bh = destBounds.getHeight() / destBounds.getWidth() * srcBounds.getWidth();
            bx = srcBounds.getX();
            by = srcBounds.getY() + 0.5 * srcBounds.getHeight() - 0.5 * bh;
        }
        Rectangle2D.Double rect = new Rectangle2D.Double(bx, by, bw, bh);
        this.centerWithAspectChange(rect, destBounds, millis, surface);
    }

    public void centerWithAspectChange(Rectangle2D srcBounds, Rectangle2D destBounds, int millis, ZDrawingSurface surface) {
        ZBounds cameraBounds = this.getBounds();
        double gcw = cameraBounds.getWidth() * srcBounds.getWidth() / destBounds.getWidth();
        double gch = cameraBounds.getHeight() * srcBounds.getHeight() / destBounds.getHeight();
        double gcx = srcBounds.getX() - gcw * ((destBounds.getX() - cameraBounds.getX()) / cameraBounds.getWidth());
        double gcy = srcBounds.getY() - gch * ((destBounds.getY() - cameraBounds.getY()) / cameraBounds.getHeight());
        Rectangle2D.Double rect = new Rectangle2D.Double(gcx, gcy, gcw, gch);
        this.centerWithAspectChange(rect, millis, surface);
    }

    public void centerWithAspectChange(Rectangle2D refBounds, int millis, ZDrawingSurface aSurface) {
        AffineTransform at = new AffineTransform();
        ZBounds bounds = this.getBounds();
        double dx = bounds.getWidth() / refBounds.getWidth();
        double dy = bounds.getHeight() / refBounds.getHeight();
        double scaleX = dx;
        double scaleY = dy;
        double ctrX = 0.5 * bounds.getWidth();
        double ctrY = 0.5 * bounds.getHeight();
        double refBoundsX = refBounds.getX() + 0.5 * refBounds.getWidth();
        double refBoundsY = refBounds.getY() + 0.5 * refBounds.getHeight();
        at.translate(ctrX + -refBoundsX * scaleX, ctrY + -refBoundsY * scaleY);
        at.scale(scaleX, scaleY);
        this.animate(at, millis, aSurface);
    }

    public Point2D getTranslation() {
        return new Point2D.Double(this.viewTransform.getTranslateX(), this.viewTransform.getTranslateY());
    }

    public double getTranslateX() {
        return this.viewTransform.getTranslateX();
    }

    public void setTranslateX(double x) {
        this.setTranslation(x, this.getTranslateY());
    }

    public double getTranslateY() {
        return this.viewTransform.getTranslateY();
    }

    public void setTranslateY(double y) {
        this.setTranslation(this.getTranslateX(), y);
    }

    public void translate(double dx, double dy) {
        this.originalViewTransform.setTransform(this.viewTransform);
        this.viewTransform.translate(dx, dy);
        this.updateViewTransform();
    }

    public void translate(double dx, double dy, int millis, ZDrawingSurface surface) {
        AffineTransform at = new AffineTransform(this.viewTransform);
        at.translate(dx, dy);
        ZTransformGroup.animate(this, at, millis, surface);
    }

    public void setTranslation(double x, double y) {
        double[] mat = new double[6];
        this.viewTransform.getMatrix(mat);
        mat[4] = x;
        mat[5] = y;
        this.setViewTransform(mat[0], mat[1], mat[2], mat[3], mat[4], mat[5]);
    }

    public void setTranslation(double x, double y, int millis, ZDrawingSurface surface) {
        AffineTransform at = new AffineTransform(this.viewTransform);
        double[] mat = new double[6];
        at.translate(x, y);
        at.getMatrix(mat);
        mat[4] = x;
        mat[5] = y;
        at.setTransform(mat[0], mat[1], mat[2], mat[3], mat[4], mat[5]);
        ZTransformGroup.animate(this, at, millis, surface);
    }

    public double getScale() {
        return this.getMagnification();
    }

    public void scale(double dz) {
        this.originalViewTransform.setTransform(this.viewTransform);
        this.viewTransform.scale(dz, dz);
        this.updateViewTransform();
    }

    public void scale(double dz, double x, double y) {
        this.originalViewTransform.setTransform(this.viewTransform);
        this.viewTransform.translate(x, y);
        this.viewTransform.scale(dz, dz);
        this.viewTransform.translate(-x, -y);
        this.updateViewTransform();
    }

    public void scale(double dz, int millis, ZDrawingSurface surface) {
        AffineTransform at = new AffineTransform(this.viewTransform);
        at.scale(dz, dz);
        ZTransformGroup.animate(this, at, millis, surface);
    }

    public void scale(double dz, double x, double y, int millis, ZDrawingSurface surface) {
        AffineTransform at = new AffineTransform(this.viewTransform);
        at.translate(x, y);
        at.scale(dz, dz);
        at.translate(-x, -y);
        ZTransformGroup.animate(this, at, millis, surface);
    }

    public void setScale(double finalz) {
        double dz = finalz / this.getScale();
        this.scale(dz);
    }

    public void setScale(double finalz, double x, double y) {
        double dz = finalz / this.getScale();
        this.scale(dz, x, y);
    }

    public void setScale(double finalz, int millis, ZDrawingSurface surface) {
        double dz = finalz / this.getScale();
        this.scale(dz, millis, surface);
    }

    public void setScale(double finalz, double x, double y, int millis, ZDrawingSurface surface) {
        double dz = finalz / this.getScale();
        this.scale(dz, x, y, millis, surface);
    }

    public void animate(AffineTransform at, int millis, ZDrawingSurface surface) {
        ZTransformGroup.animate(this, at, millis, surface);
    }

    public void writeObject(ZObjectOutputStream out) throws IOException {
        super.writeObject(out);
        if (!this.viewTransform.isIdentity()) {
            out.writeState("java.awt.geom.AffineTransform", "viewTransform", this.viewTransform);
        }
        if (this.fillColor != fillColor_DEFAULT) {
            out.writeState("java.awt.Color", "fillColor", this.fillColor);
        }
        this.layers.writeObject("layers", out);
        Vector<Double> cameraBoundsNumbers = new Vector<Double>();
        cameraBoundsNumbers.addElement(new Double(this.getBounds().getX()));
        cameraBoundsNumbers.addElement(new Double(this.getBounds().getY()));
        cameraBoundsNumbers.addElement(new Double(this.getBounds().getWidth()));
        cameraBoundsNumbers.addElement(new Double(this.getBounds().getHeight()));
        out.writeState("Vector", "cameraBounds", cameraBoundsNumbers);
    }

    public void writeObjectRecurse(ZObjectOutputStream out) throws IOException {
        super.writeObjectRecurse(out);
        ZLayerGroup[] layersRef = this.getLayersReference();
        int i = 0;
        while (i < this.layers.size()) {
            out.addObject(layersRef[i]);
            ++i;
        }
    }

    public void setState(String fieldType, String fieldName, Object fieldValue) {
        super.setState(fieldType, fieldName, fieldValue);
        if (fieldName.compareTo("layers") == 0) {
            Iterator i = ((Vector)fieldValue).iterator();
            while (i.hasNext()) {
                ZLayerGroup layer = (ZLayerGroup)i.next();
                this.addLayer(layer);
            }
        } else if (fieldName.compareTo("viewTransform") == 0) {
            this.setViewTransform((AffineTransform)fieldValue);
        } else if (fieldName.compareTo("fillColor") == 0) {
            this.setFillColor((Color)fieldValue);
        } else if (fieldName.compareTo("cameraBounds") == 0) {
            Vector cameraBoundsNumbers = (Vector)fieldValue;
            Rectangle2D.Double cameraBounds = new Rectangle2D.Double((Double)cameraBoundsNumbers.elementAt(0), (Double)cameraBoundsNumbers.elementAt(1), (Double)cameraBoundsNumbers.elementAt(2), (Double)cameraBoundsNumbers.elementAt(3));
            this.setBounds(cameraBounds);
        }
    }

    protected ZLayerGroup getAncestorLayerFor(ZNode node) {
        ZLayerGroup[] layersRef = this.getLayersReference();
        int i = 0;
        while (i < this.layers.size()) {
            if (node == layersRef[i] || node.isDescendentOf(layersRef[i])) {
                return layersRef[i];
            }
            ++i;
        }
        return null;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.tmpBounds = new ZBounds();
        this.inverseViewTransformDirty = true;
        this.debugRenderCount = 0;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.trimToSize();
        out.defaultWriteObject();
    }

    private void updateViewTransform() {
        this.inverseViewTransformDirty = true;
        if (this.hasListenerOfType(class$edu$umd$cs$jazz$event$ZCameraListener == null ? (class$edu$umd$cs$jazz$event$ZCameraListener = ZCamera.class$("edu.umd.cs.jazz.event.ZCameraListener")) : class$edu$umd$cs$jazz$event$ZCameraListener)) {
            this.fireEvent(ZCameraEvent.createViewChangedEvent(this, this.originalViewTransform));
        }
        this.originalViewTransform.setTransform(this.viewTransform);
        this.repaint();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

