/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz;

import edu.umd.cs.jazz.ZGroup;
import edu.umd.cs.jazz.ZLayoutManager;
import edu.umd.cs.jazz.ZNode;
import edu.umd.cs.jazz.ZTransformGroup;
import edu.umd.cs.jazz.io.ZObjectOutputStream;
import edu.umd.cs.jazz.io.ZSerializable;
import edu.umd.cs.jazz.util.ZBounds;
import edu.umd.cs.jazz.util.ZSceneGraphEditor;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.IOException;

public class ZGridLayoutManager
implements ZLayoutManager,
ZSerializable {
    public static final int COLUMN = 1;
    public static final int ROW = 2;
    protected static final Point2D DEFAULT_START_POINT;
    protected static final double DEFAULT_CELL_WIDTH = 50.0;
    protected static final double DEFAULT_CELL_HEIGHT = 50.0;
    protected static final double DEFAULT_HORIZONTAL_SPACING = 25.0;
    protected static final double DEFAULT_VERTICAL_SPACING = 25.0;
    int rowsOrColumns;
    int numCells;
    boolean invertChildren = false;
    Point2D layoutStartPoint = (Point2D)DEFAULT_START_POINT.clone();
    double cellWidth = 50.0;
    double cellHeight = 50.0;
    double horizontalSpacing = 25.0;
    double verticalSpacing = 25.0;

    public ZGridLayoutManager() {
    }

    public ZGridLayoutManager(int rowsOrColumns, int numCells) {
        this.rowsOrColumns = rowsOrColumns;
        this.numCells = numCells;
    }

    public ZGridLayoutManager(int rowsOrColumns, int numCells, double width, double height) {
        this(rowsOrColumns, numCells);
        this.cellWidth = width;
        this.cellHeight = height;
    }

    public ZGridLayoutManager(int rowsOrColumns, int numCells, double width, double height, double horizontalSpacing, double verticalSpacing) {
        this(rowsOrColumns, numCells, width, height);
        this.horizontalSpacing = horizontalSpacing;
        this.verticalSpacing = verticalSpacing;
    }

    public ZGridLayoutManager(int rowsOrColumns, int numCells, double width, double height, double horizontalSpacing, double verticalSpacing, double layoutStartX, double layoutStartY) {
        this(rowsOrColumns, numCells, width, height, horizontalSpacing, verticalSpacing);
        this.layoutStartPoint.setLocation(layoutStartX, layoutStartY);
    }

    public int getGridAxis() {
        return this.rowsOrColumns;
    }

    public void setGridAxis(int rowsOrColumns) {
        this.rowsOrColumns = rowsOrColumns;
    }

    public void setInvertChildren(boolean invertChildren) {
        this.invertChildren = invertChildren;
    }

    public boolean getInvertChildren() {
        return this.invertChildren;
    }

    public int getNumCells() {
        return this.numCells;
    }

    public void setNumCells(int numCells) {
        this.numCells = numCells;
    }

    public double getCellWidth() {
        return this.cellWidth;
    }

    public void setCellWidth(double width) {
        this.cellWidth = width;
    }

    public double getCellHeight() {
        return this.cellHeight;
    }

    public void setCellHeight(double height) {
        this.cellHeight = height;
    }

    public double getVerticalSpacing() {
        return this.verticalSpacing;
    }

    public void setVerticalSpacing(double verticalSpacing) {
        this.verticalSpacing = verticalSpacing;
    }

    public double getHorizontalSpacing() {
        return this.horizontalSpacing;
    }

    public void setHorizontalSpacing(double horizontalSpacing) {
        this.horizontalSpacing = horizontalSpacing;
    }

    public Point2D getLayoutStartPoint() {
        return (Point2D)this.layoutStartPoint.clone();
    }

    public void setLayoutStartPoint(double x, double y) {
        this.layoutStartPoint.setLocation(x, y);
    }

    public void setLayoutStartPoint(Point2D startPoint) {
        this.layoutStartPoint.setLocation(startPoint);
    }

    public void doLayout(ZGroup node) {
        block10: {
            ZNode primary = node.editor().getNode();
            if (!(primary instanceof ZGroup)) break block10;
            int numChildren = ((ZGroup)primary).getNumChildren();
            ZNode[] children = ((ZGroup)primary).getChildrenReference();
            if (this.invertChildren) {
                ZNode[] invertedChildren = new ZNode[numChildren];
                int i = 0;
                while (i < numChildren) {
                    invertedChildren[i] = children[numChildren - i - 1];
                    ++i;
                }
                children = invertedChildren;
            }
            int numColumns = 0;
            Point2D currentPt = (Point2D)this.layoutStartPoint.clone();
            if (numChildren > 0) {
                if (this.rowsOrColumns == 1) {
                    numColumns = this.numCells;
                    int numRows = this.numCells % numChildren == 0 ? this.numCells / numChildren : this.numCells / numChildren + 1;
                    int curCount = 0;
                    while (curCount < numChildren) {
                        int i = 0;
                        while (i < numColumns && curCount < numChildren) {
                            ZSceneGraphEditor editor = children[curCount].editor();
                            ZNode child = editor.getNode();
                            ZBounds bounds = child.getBounds();
                            double scale = Math.min(this.cellWidth / bounds.getWidth(), this.cellHeight / bounds.getHeight());
                            ZTransformGroup transform = editor.getTransformGroup();
                            AffineTransform at = transform.getTransform();
                            at.setTransform(scale, at.getShearX(), at.getShearY(), scale, 0.0, 0.0);
                            bounds.transform(at);
                            at.setTransform(at.getScaleX(), at.getShearX(), at.getShearY(), at.getScaleY(), currentPt.getX() - bounds.getX(), currentPt.getY() - bounds.getY());
                            transform.setTransform(at);
                            currentPt.setLocation(currentPt.getX() + this.cellWidth + this.horizontalSpacing, currentPt.getY());
                            ++curCount;
                            ++i;
                        }
                        currentPt.setLocation(this.layoutStartPoint.getX(), currentPt.getY() + this.cellHeight + this.verticalSpacing);
                    }
                } else if (this.rowsOrColumns == 2) {
                    numColumns = this.numCells % numChildren == 0 ? this.numCells / numChildren : this.numCells / numChildren + 1;
                    int numRows = this.numCells;
                    int curCount = 0;
                    while (curCount < numChildren) {
                        int i = 0;
                        while (i < numRows && curCount < numChildren) {
                            ZSceneGraphEditor editor = children[curCount].editor();
                            ZNode child = editor.getNode();
                            ZBounds bounds = child.getBounds();
                            double scale = Math.min(this.cellWidth / bounds.getWidth(), this.cellHeight / bounds.getHeight());
                            ZTransformGroup transform = editor.getTransformGroup();
                            AffineTransform at = transform.getTransform();
                            at.setTransform(scale, at.getShearX(), at.getShearY(), scale, 0.0, 0.0);
                            bounds.transform(at);
                            at.setTransform(at.getScaleX(), at.getShearX(), at.getShearY(), at.getScaleY(), currentPt.getX() - bounds.getX(), currentPt.getY() - bounds.getY());
                            transform.setTransform(at);
                            currentPt.setLocation(currentPt.getX(), currentPt.getY() + this.cellHeight + this.verticalSpacing);
                            ++curCount;
                            ++i;
                        }
                        currentPt.setLocation(currentPt.getX() + this.cellWidth + this.horizontalSpacing, this.layoutStartPoint.getY());
                    }
                }
            }
        }
    }

    public void doLayout(ZGroup node, int millis) {
    }

    public void preLayout(ZGroup node) {
    }

    public void postLayout(ZGroup node) {
    }

    public Object clone() {
        return null;
    }

    public void writeObject(ZObjectOutputStream out) throws IOException {
    }

    public void writeObjectRecurse(ZObjectOutputStream out) throws IOException {
    }

    public void setState(String fieldType, String fieldName, Object fieldValue) {
    }

    static {
        COLUMN = 1;
        ROW = 2;
        DEFAULT_START_POINT = new Point2D.Double(0.0, 0.0);
        DEFAULT_CELL_WIDTH = 50.0;
        DEFAULT_CELL_HEIGHT = 50.0;
        DEFAULT_HORIZONTAL_SPACING = 25.0;
        DEFAULT_VERTICAL_SPACING = 25.0;
    }
}

