/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz;

import edu.umd.cs.jazz.ZGroup;
import edu.umd.cs.jazz.ZLayoutManager;
import edu.umd.cs.jazz.ZNode;
import edu.umd.cs.jazz.io.ZObjectOutputStream;
import edu.umd.cs.jazz.io.ZSerializable;
import edu.umd.cs.jazz.util.ZLayout;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;

public class ZPathLayoutManager
implements ZLayoutManager,
ZSerializable {
    private transient Shape shape = null;
    private ArrayList path = new ArrayList();
    boolean invertChildren = false;
    private boolean closed = false;
    private double flatness = 1.0;
    private boolean exact = true;
    private double space = -1.0;
    private double tolerance = -1.0;

    public ZPathLayoutManager() {
        this(new Line2D.Double(0.0, 0.0, 1.0, 1.0));
    }

    public ZPathLayoutManager(Shape s) {
        this.setShape(s);
    }

    public Object clone() {
        ZPathLayoutManager newObject;
        try {
            newObject = (ZPathLayoutManager)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Object.clone() failed: " + e);
        }
        if (this.path != null) {
            newObject.path = (ArrayList)this.path.clone();
        }
        if (this.shape != null) {
            // empty if block
        }
        return newObject;
    }

    public void preLayout(ZGroup node) {
    }

    public void postLayout(ZGroup node) {
    }

    public void doLayout(ZGroup node, int millis) {
        System.out.println("WARNING: Layout animation not implemented yet - layout being applied without animation.");
        this.doLayout(node);
    }

    public void doLayout(ZGroup node) {
        ZNode primary = node.editor().getNode();
        if (primary instanceof ZGroup) {
            ZNode[] children = ((ZGroup)primary).getChildren();
            if (this.invertChildren) {
                int i = 0;
                while (i < children.length / 2) {
                    ZNode tmp = children[i];
                    children[i] = children[children.length - i - 1];
                    children[children.length - i - 1] = tmp;
                    ++i;
                }
            }
            if (this.exact) {
                if (this.space >= 0.0) {
                    ZLayout.distribute(children, this.path, this.space, this.tolerance, true, this.closed);
                } else {
                    ZLayout.distribute(children, this.path, this.tolerance, this.closed);
                }
            } else if (this.space >= 0.0) {
                ZLayout.distribute(children, this.path, this.space, this.tolerance, false, this.closed);
            } else {
                ZLayout.distribute(children, this.path, false, this.closed);
            }
        }
    }

    public void setInvertChildren(boolean invertChildren) {
        this.invertChildren = invertChildren;
    }

    public boolean getInvertChildren() {
        return this.invertChildren;
    }

    public boolean getClosed() {
        return this.closed;
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    public double getFlatness() {
        return this.flatness;
    }

    public void setFlatness(double flatness) {
        this.flatness = flatness;
        this.setShape(this.shape);
    }

    public boolean getExact() {
        return this.exact;
    }

    public void setExact(boolean exact) {
        this.exact = exact;
    }

    public double getTolerance() {
        return this.tolerance;
    }

    public void setTolerance(double tolerance) {
        this.tolerance = tolerance;
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setShape(Shape shape) {
        this.shape = shape;
        PathIterator p = shape.getPathIterator(new AffineTransform());
        FlatteningPathIterator fp = new FlatteningPathIterator(p, this.flatness);
        this.path.clear();
        while (!fp.isDone()) {
            int i;
            double[] farr = new double[6];
            int type = fp.currentSegment(farr);
            if (type == 0 || type == 1) {
                this.path.add(new Point2D.Double(farr[0], farr[1]));
            }
            if (type == 2) {
                i = 0;
                while (i < 2) {
                    this.path.add(new Point2D.Double(farr[0], farr[1]));
                    ++i;
                }
            }
            if (type == 3) {
                i = 0;
                while (i < 3) {
                    this.path.add(new Point2D.Double(farr[2 * i], farr[2 * i + 1]));
                    ++i;
                }
            }
            fp.next();
        }
    }

    public double getSpace() {
        return this.space;
    }

    public void setSpacing(double space) {
        this.space = space;
    }

    public void writeObject(ZObjectOutputStream out) throws IOException {
    }

    public void writeObjectRecurse(ZObjectOutputStream out) throws IOException {
    }

    public void setState(String fieldType, String fieldName, Object fieldValue) {
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.setShape(new Line2D.Double(0.0, 0.0, 1.0, 1.0));
    }
}

