/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz;

import edu.umd.cs.jazz.ZDrawingSurface;
import edu.umd.cs.jazz.ZGroup;
import edu.umd.cs.jazz.ZNode;
import edu.umd.cs.jazz.ZSISOLerp;
import edu.umd.cs.jazz.ZTransformable;
import edu.umd.cs.jazz.event.ZNodeEvent;
import edu.umd.cs.jazz.event.ZTransformEvent;
import edu.umd.cs.jazz.event.ZTransformListener;
import edu.umd.cs.jazz.io.ZObjectOutputStream;
import edu.umd.cs.jazz.io.ZSerializable;
import edu.umd.cs.jazz.util.ZBounds;
import edu.umd.cs.jazz.util.ZDebug;
import edu.umd.cs.jazz.util.ZLerp;
import edu.umd.cs.jazz.util.ZNoninvertibleTransformException;
import edu.umd.cs.jazz.util.ZRenderContext;
import edu.umd.cs.jazz.util.ZSceneGraphPath;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class ZTransformGroup
extends ZGroup
implements ZSerializable,
ZTransformable,
Serializable {
    private AffineTransform transform;
    private transient AffineTransform inverseTransform = null;
    private boolean inverseTransformDirty = true;
    private transient AffineTransform tmpTransform = new AffineTransform();
    private transient ZBounds paintBounds;
    private transient Rectangle2D tmpRect;
    private static double[] pts = new double[8];
    static /* synthetic */ Class class$edu$umd$cs$jazz$event$ZNodeListener;
    static /* synthetic */ Class class$edu$umd$cs$jazz$event$ZTransformListener;

    public ZTransformGroup() {
        this.transform = new AffineTransform();
        this.paintBounds = new ZBounds();
        this.tmpRect = new Rectangle2D.Double();
    }

    public ZTransformGroup(ZNode child) {
        this.transform = new AffineTransform();
        this.paintBounds = new ZBounds();
        this.tmpRect = new Rectangle2D.Double();
        this.insertAbove(child);
    }

    protected Object duplicateObject() {
        ZTransformGroup newTransform = (ZTransformGroup)super.duplicateObject();
        newTransform.transform = this.getTransform();
        newTransform.tmpTransform = new AffineTransform();
        newTransform.inverseTransform = new AffineTransform();
        newTransform.inverseTransformDirty = true;
        newTransform.paintBounds = new ZBounds();
        newTransform.tmpRect = new Rectangle2D.Double();
        return newTransform;
    }

    public void render(ZRenderContext renderContext) {
        Graphics2D g2 = renderContext.getGraphics2D();
        ZBounds visibleBounds = renderContext.getVisibleBounds();
        AffineTransform saveTransform = g2.getTransform();
        this.paintBounds.reset();
        this.paintBounds.add(visibleBounds);
        this.paintBounds.transform(this.getInverseTransform());
        renderContext.pushVisibleBounds(this.paintBounds);
        g2.transform(this.transform);
        super.render(renderContext);
        g2.setTransform(saveTransform);
        renderContext.popVisibleBounds();
    }

    protected void computeBounds() {
        super.computeBounds();
        ZTransformGroup.transform(this.bounds, this.transform);
        this.fireGlobalBoundsEventForSubTree(this);
    }

    private void fireGlobalBoundsEventForSubTree(ZNode node) {
        if (node == this) {
            ZNode[] childrenRef = this.getChildrenReference();
            int i = 0;
            while (i < this.children.size()) {
                if (childrenRef[i].hasNodeListener()) {
                    this.fireGlobalBoundsEventForSubTree(childrenRef[i]);
                }
                ++i;
            }
        } else if (node instanceof ZGroup) {
            ZGroup group = (ZGroup)node;
            if (group.hasListenerOfType(class$edu$umd$cs$jazz$event$ZNodeListener == null ? (class$edu$umd$cs$jazz$event$ZNodeListener = ZTransformGroup.class$("edu.umd.cs.jazz.event.ZNodeListener")) : class$edu$umd$cs$jazz$event$ZNodeListener)) {
                group.fireEvent(ZNodeEvent.createGlobalBoundsChangedEvent(group));
            }
            ZNode[] childrenRef = group.getChildrenReference();
            int i = 0;
            while (i < group.getNumChildren()) {
                if (childrenRef[i].hasNodeListener()) {
                    this.fireGlobalBoundsEventForSubTree(childrenRef[i]);
                }
                ++i;
            }
        } else if (node.hasListenerOfType(class$edu$umd$cs$jazz$event$ZNodeListener == null ? (class$edu$umd$cs$jazz$event$ZNodeListener = ZTransformGroup.class$("edu.umd.cs.jazz.event.ZNodeListener")) : class$edu$umd$cs$jazz$event$ZNodeListener)) {
            node.fireEvent(ZNodeEvent.createGlobalBoundsChangedEvent(node));
        }
    }

    public void repaint(ZBounds repaintBounds) {
        if (ZDebug.debugRepaint) {
            System.out.println("ZNode.repaint(ZBounds): this = " + this);
            System.out.println("ZNode.repaint(ZBounds): bounds = " + repaintBounds);
        }
        if (!this.inTransaction && this.parent != null) {
            ZTransformGroup.transform(repaintBounds, this.transform);
            this.parent.repaint(repaintBounds);
        }
    }

    public void reshape() {
        if (!this.inTransaction && this.getVolatileBounds()) {
            ZBounds tBounds = (ZBounds)this.bounds.clone();
            ZTransformGroup.transform(tBounds, this.getInverseTransform());
            this.repaint(tBounds);
        } else {
            this.repaint();
        }
        this.updateBounds();
        this.repaint();
    }

    public boolean pick(Rectangle2D rect, ZSceneGraphPath path) {
        if (this.isPickable()) {
            path.pushTransformer(this);
            AffineTransform origTm = path.getTransform();
            AffineTransform tm = new AffineTransform(origTm);
            tm.concatenate(this.transform);
            path.setTransform(tm);
            this.tmpRect.setRect(rect);
            ZTransformGroup.transform(this.tmpRect, this.getInverseTransform());
            if (super.pick(this.tmpRect, path)) {
                if (!this.getChildrenPickable()) {
                    path.setTransform(tm);
                }
                return true;
            }
            if (!path.getCameraFound()) {
                path.setTransform(origTm);
                path.popTransformer(this);
            }
        }
        return false;
    }

    public void addTransformListener(ZTransformListener l) {
        this.getListenerList().add(class$edu$umd$cs$jazz$event$ZTransformListener == null ? (class$edu$umd$cs$jazz$event$ZTransformListener = ZTransformGroup.class$("edu.umd.cs.jazz.event.ZTransformListener")) : class$edu$umd$cs$jazz$event$ZTransformListener, l);
    }

    public void removeTransformListener(ZTransformListener l) {
        this.removeEventListener(class$edu$umd$cs$jazz$event$ZTransformListener == null ? (class$edu$umd$cs$jazz$event$ZTransformListener = ZTransformGroup.class$("edu.umd.cs.jazz.event.ZTransformListener")) : class$edu$umd$cs$jazz$event$ZTransformListener, l);
    }

    public AffineTransform getTransform() {
        return (AffineTransform)this.getTransformReference().clone();
    }

    public AffineTransform getTransformReference() {
        return this.transform;
    }

    public void getMatrix(double[] flatmatrix) {
        this.transform.getMatrix(flatmatrix);
    }

    public void setTransform(AffineTransform newTransform) {
        AffineTransform origTransform = this.transform;
        if (this.transform == null) {
            this.transform = new AffineTransform();
        }
        this.transform.setTransform(newTransform);
        this.inverseTransformDirty = true;
        if (this.hasListenerOfType(class$edu$umd$cs$jazz$event$ZTransformListener == null ? (class$edu$umd$cs$jazz$event$ZTransformListener = ZTransformGroup.class$("edu.umd.cs.jazz.event.ZTransformListener")) : class$edu$umd$cs$jazz$event$ZTransformListener)) {
            this.fireEvent(ZTransformEvent.createTransformChangedEvent(this, origTransform));
        }
        this.tmpTransform = origTransform;
        this.reshape();
    }

    public void setTransform(double m00, double m10, double m01, double m11, double m02, double m12) {
        this.tmpTransform.setTransform(m00, m10, m01, m11, m02, m12);
        this.setTransform(this.tmpTransform);
    }

    public void concatenate(AffineTransform at) {
        this.tmpTransform.setTransform(this.transform);
        this.tmpTransform.concatenate(at);
        this.setTransform(this.tmpTransform);
    }

    public void preConcatenate(AffineTransform at) {
        this.tmpTransform.setTransform(this.transform);
        this.tmpTransform.preConcatenate(at);
        this.setTransform(this.tmpTransform);
    }

    public AffineTransform getLocalToGlobalTransform() {
        AffineTransform result = null;
        if (this.parent != null) {
            result = this.parent.getLocalToGlobalTransform();
            result.concatenate(this.transform);
        } else {
            result = (AffineTransform)this.transform.clone();
        }
        return result;
    }

    protected void computeInverseTransform() {
        try {
            this.inverseTransform = this.transform.createInverse();
            this.inverseTransformDirty = false;
        }
        catch (NoninvertibleTransformException e) {
            throw new ZNoninvertibleTransformException(e);
        }
    }

    public AffineTransform getInverseTransform() {
        if (this.inverseTransformDirty) {
            this.computeInverseTransform();
        }
        return this.inverseTransform;
    }

    public Point2D getTranslation() {
        return new Point2D.Double(this.transform.getTranslateX(), this.transform.getTranslateY());
    }

    public double getTranslateX() {
        return this.transform.getTranslateX();
    }

    public void setTranslateX(double x) {
        this.setTranslation(x, this.getTranslateY());
    }

    public double getTranslateY() {
        return this.transform.getTranslateY();
    }

    public void setTranslateY(double y) {
        this.setTranslation(this.getTranslateX(), y);
    }

    public void translate(double dx, double dy) {
        this.tmpTransform.setTransform(this.transform);
        this.tmpTransform.translate(dx, dy);
        this.setTransform(this.tmpTransform);
    }

    public void translate(double dx, double dy, int millis, ZDrawingSurface surface) {
        this.tmpTransform.setTransform(this.transform);
        this.tmpTransform.translate(dx, dy);
        ZTransformGroup.animate(this, this.tmpTransform, millis, surface);
    }

    public void setTranslation(double x, double y) {
        double[] mat = new double[6];
        this.transform.getMatrix(mat);
        mat[4] = x;
        mat[5] = y;
        this.setTransform(mat[0], mat[1], mat[2], mat[3], mat[4], mat[5]);
    }

    public void setTranslation(double x, double y, int millis, ZDrawingSurface surface) {
        this.tmpTransform.setTransform(this.transform);
        double[] mat = new double[6];
        this.tmpTransform.translate(x, y);
        this.tmpTransform.getMatrix(mat);
        mat[4] = x;
        mat[5] = y;
        this.tmpTransform.setTransform(mat[0], mat[1], mat[2], mat[3], mat[4], mat[5]);
        ZTransformGroup.animate(this, this.tmpTransform, millis, surface);
    }

    public double getScale() {
        return ZTransformGroup.computeScale(this.transform);
    }

    public void scale(double dz) {
        this.tmpTransform.setTransform(this.transform);
        this.tmpTransform.scale(dz, dz);
        this.setTransform(this.tmpTransform);
    }

    public void scale(double dz, double x, double y) {
        this.tmpTransform.setTransform(this.transform);
        this.tmpTransform.translate(x, y);
        this.tmpTransform.scale(dz, dz);
        this.tmpTransform.translate(-x, -y);
        this.setTransform(this.tmpTransform);
    }

    public void scale(double dz, int millis, ZDrawingSurface surface) {
        this.tmpTransform.setTransform(this.transform);
        this.tmpTransform.scale(dz, dz);
        ZTransformGroup.animate(this, this.tmpTransform, millis, surface);
    }

    public void scale(double dz, double x, double y, int millis, ZDrawingSurface surface) {
        this.tmpTransform.setTransform(this.transform);
        this.tmpTransform.translate(x, y);
        this.tmpTransform.scale(dz, dz);
        this.tmpTransform.translate(-x, -y);
        ZTransformGroup.animate(this, this.tmpTransform, millis, surface);
    }

    public void setScale(double finalz) {
        double dz = finalz / this.getScale();
        this.scale(dz);
    }

    public void setScale(double finalz, double x, double y) {
        double dz = finalz / this.getScale();
        this.scale(dz, x, y);
    }

    public void setScale(double finalz, int millis, ZDrawingSurface surface) {
        double dz = finalz / this.getScale();
        this.scale(dz, millis, surface);
    }

    public void setScale(double finalz, double x, double y, int millis, ZDrawingSurface surface) {
        double dz = finalz / this.getScale();
        this.scale(dz, x, y, millis, surface);
    }

    public double getRotation() {
        Point2D.Double p1 = new Point2D.Double(0.0, 0.0);
        Point2D.Double p2 = new Point2D.Double(1.0, 0.0);
        this.transform.transform(p1, p1);
        this.transform.transform(p2, p2);
        double dy = ((Point2D)p2).getY() - ((Point2D)p1).getY();
        double l = p1.distance(p2);
        double rotation = Math.asin(dy / l);
        return rotation;
    }

    public void setRotation(double theta) {
        this.rotate(theta - this.getRotation());
    }

    public void setRotation(double theta, int millis, ZDrawingSurface surface) {
        this.tmpTransform.setTransform(this.transform);
        this.tmpTransform.rotate(theta - this.getRotation());
        ZTransformGroup.animate(this, this.tmpTransform, millis, surface);
    }

    public void setRotation(double theta, double xctr, double yctr) {
        this.rotate(theta - this.getRotation(), xctr, yctr);
    }

    public void setRotation(double theta, double xctr, double yctr, int millis, ZDrawingSurface surface) {
        this.tmpTransform.setTransform(this.transform);
        this.tmpTransform.rotate(theta - this.getRotation(), xctr, yctr);
        ZTransformGroup.animate(this, this.tmpTransform, millis, surface);
    }

    public void rotate(double theta) {
        this.tmpTransform.setTransform(this.transform);
        this.tmpTransform.rotate(theta);
        this.setTransform(this.tmpTransform);
    }

    public void rotate(double theta, double xctr, double yctr) {
        this.tmpTransform.setTransform(this.transform);
        this.tmpTransform.rotate(theta, xctr, yctr);
        this.setTransform(this.tmpTransform);
    }

    public void rotate(double theta, int millis, ZDrawingSurface surface) {
        this.tmpTransform.setTransform(this.transform);
        this.tmpTransform.rotate(theta);
        ZTransformGroup.animate(this, this.tmpTransform, millis, surface);
    }

    public void rotate(double theta, double xctr, double yctr, int millis, ZDrawingSurface surface) {
        this.tmpTransform.setTransform(this.transform);
        this.tmpTransform.rotate(theta, xctr, yctr);
        ZTransformGroup.animate(this, this.tmpTransform, millis, surface);
    }

    public void position(Point2D srcPt, Point2D destPt, ZNode refNode, int millis, ZDrawingSurface surface) {
        this.position(srcPt, destPt, refNode.getGlobalBounds(), millis, surface);
    }

    public void position(Point2D srcPt, Point2D destPt, Rectangle2D destBounds, int millis, ZDrawingSurface surface) {
        if (this.parent != null) {
            ZBounds srcBounds = this.getGlobalBounds();
            double srcx = ZTransformGroup.lerp(srcPt.getX(), ((RectangularShape)srcBounds).getX(), ((RectangularShape)srcBounds).getX() + ((RectangularShape)srcBounds).getWidth());
            double srcy = ZTransformGroup.lerp(srcPt.getY(), ((RectangularShape)srcBounds).getY(), ((RectangularShape)srcBounds).getY() + ((RectangularShape)srcBounds).getHeight());
            double destx = ZTransformGroup.lerp(destPt.getX(), destBounds.getX(), destBounds.getX() + destBounds.getWidth());
            double desty = ZTransformGroup.lerp(destPt.getY(), destBounds.getY(), destBounds.getY() + destBounds.getHeight());
            Point2D.Double pt1 = new Point2D.Double(srcx, srcy);
            this.globalToLocal(pt1);
            Point2D.Double pt2 = new Point2D.Double(destx, desty);
            this.globalToLocal(pt2);
            double dx = ((Point2D)pt2).getX() - ((Point2D)pt1).getX();
            double dy = ((Point2D)pt2).getY() - ((Point2D)pt1).getY();
            this.tmpTransform.setTransform(this.transform);
            this.tmpTransform.translate(dx, dy);
            ZTransformGroup.animate(this, this.tmpTransform, millis, surface);
        }
    }

    public static double computeScale(AffineTransform at) {
        Point2D.Double pt1 = new Point2D.Double(0.0, 0.0);
        Point2D.Double pt2 = new Point2D.Double(1.0, 1.0);
        double origDist = pt1.distance(pt2);
        at.transform(pt1, pt1);
        at.transform(pt2, pt2);
        double mag = pt1.distance(pt2) / origDist;
        return mag;
    }

    public static double lerp(double t, double a, double b) {
        return a + t * (b - a);
    }

    public static void transform(ZBounds bounds, AffineTransform at) {
        if (!bounds.isEmpty()) {
            ZTransformGroup.transform((Rectangle2D)bounds, at);
        }
    }

    public static void transform(Rectangle2D rect, AffineTransform at) {
        ZTransformGroup.pts[0] = rect.getX();
        ZTransformGroup.pts[1] = rect.getY();
        ZTransformGroup.pts[2] = rect.getX() + rect.getWidth();
        ZTransformGroup.pts[3] = rect.getY();
        ZTransformGroup.pts[4] = rect.getX() + rect.getWidth();
        ZTransformGroup.pts[5] = rect.getY() + rect.getHeight();
        ZTransformGroup.pts[6] = rect.getX();
        ZTransformGroup.pts[7] = rect.getY() + rect.getHeight();
        at.transform(pts, 0, pts, 0, 4);
        double minX = pts[0];
        double minY = pts[1];
        double maxX = pts[0];
        double maxY = pts[1];
        int i = 1;
        while (i < 4) {
            if (pts[2 * i] < minX) {
                minX = pts[2 * i];
            }
            if (pts[2 * i + 1] < minY) {
                minY = pts[2 * i + 1];
            }
            if (pts[2 * i] > maxX) {
                maxX = pts[2 * i];
            }
            if (pts[2 * i + 1] > maxY) {
                maxY = pts[2 * i + 1];
            }
            ++i;
        }
        rect.setRect(minX, minY, maxX - minX, maxY - minY);
    }

    public static void animate(ZTransformable node, AffineTransform tx, int millis, ZDrawingSurface surface) {
        ZTransformGroup.animate(node, tx, millis, surface, (ZLerp)new ZSISOLerp());
    }

    public static void animate(ZTransformable node, AffineTransform at, int millis, ZDrawingSurface surface, ZLerp lerpTimeFunction) {
        ZTransformable[] nodes = new ZTransformable[1];
        AffineTransform[] ats = new AffineTransform[1];
        nodes[0] = node;
        ats[0] = at;
        ZTransformGroup.animate(nodes, ats, millis, surface, lerpTimeFunction);
    }

    public static void animate(ZTransformable[] nodes, AffineTransform[] txs, int millis, ZDrawingSurface surface) {
        ZTransformGroup.animate(nodes, txs, millis, surface, (ZLerp)new ZSISOLerp());
    }

    public static void animate(ZTransformable[] nodes, AffineTransform[] txs, int millis, ZDrawingSurface surface, ZLerp lerpTimeFunction) {
        int len = Math.min(nodes.length, txs.length);
        double[][] srcTx = new double[len][6];
        double[][] currTx = new double[len][6];
        double[][] destTx = new double[len][6];
        surface.setAnimating(true);
        int i = 0;
        while (i < len) {
            nodes[i].getMatrix(srcTx[i]);
            txs[i].getMatrix(destTx[i]);
            ++i;
        }
        if (millis > 0) {
            long elapsedTime;
            double straightLerp = (double)millis / 30000.0;
            double lerp = lerpTimeFunction == null ? straightLerp : lerpTimeFunction.lerpTime(straightLerp);
            long startTime = System.currentTimeMillis();
            do {
                i = 0;
                while (i < len) {
                    currTx[i][0] = ZTransformGroup.lerp(lerp, srcTx[i][0], destTx[i][0]);
                    currTx[i][1] = ZTransformGroup.lerp(lerp, srcTx[i][1], destTx[i][1]);
                    currTx[i][2] = ZTransformGroup.lerp(lerp, srcTx[i][2], destTx[i][2]);
                    currTx[i][3] = ZTransformGroup.lerp(lerp, srcTx[i][3], destTx[i][3]);
                    currTx[i][4] = ZTransformGroup.lerp(lerp, srcTx[i][4], destTx[i][4]);
                    currTx[i][5] = ZTransformGroup.lerp(lerp, srcTx[i][5], destTx[i][5]);
                    nodes[i].setTransform(currTx[i][0], currTx[i][1], currTx[i][2], currTx[i][3], currTx[i][4], currTx[i][5]);
                    ++i;
                }
                surface.paintImmediately();
                elapsedTime = System.currentTimeMillis() - startTime;
                straightLerp = (double)elapsedTime / (double)millis;
                double sisoLerp = lerpTimeFunction == null ? straightLerp : lerpTimeFunction.lerpTime(straightLerp);
                double d = lerp = sisoLerp > lerp ? sisoLerp : lerp;
            } while (elapsedTime < (long)millis);
        }
        i = 0;
        while (i < len) {
            nodes[i].setTransform(destTx[i][0], destTx[i][1], destTx[i][2], destTx[i][3], destTx[i][4], destTx[i][5]);
            ++i;
        }
        if (millis > 0) {
            surface.paintImmediately();
        }
        surface.setAnimating(false);
    }

    public String dump() {
        String str = super.dump();
        str = str + "\n Transform = " + this.transform;
        return str;
    }

    public void writeObject(ZObjectOutputStream out) throws IOException {
        super.writeObject(out);
        out.writeState("java.awt.geom.AffineTransform", "transform", this.transform);
    }

    public void writeObjectRecurse(ZObjectOutputStream out) throws IOException {
        super.writeObjectRecurse(out);
    }

    public void setState(String fieldType, String fieldName, Object fieldValue) {
        super.setState(fieldType, fieldName, fieldValue);
        if (fieldName.compareTo("transform") == 0) {
            this.setTransform((AffineTransform)fieldValue);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.tmpTransform = new AffineTransform();
        this.paintBounds = new ZBounds();
        this.tmpRect = new Rectangle2D.Double();
        this.inverseTransformDirty = true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

