/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz.component;

import edu.umd.cs.jazz.component.ZShape;
import edu.umd.cs.jazz.io.ZObjectOutputStream;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;

public class ZEllipse
extends ZShape {
    protected transient Ellipse2D ellipse;

    public ZEllipse() {
        this.setEllipse(new Ellipse2D.Double());
    }

    public ZEllipse(double x, double y) {
        this.setEllipse(new Ellipse2D.Double(x, y, 0.0, 0.0));
    }

    public ZEllipse(double x, double y, double width, double height) {
        this.setEllipse(new Ellipse2D.Double(x, y, width, height));
    }

    public ZEllipse(Ellipse2D r) {
        this.setEllipse((Ellipse2D)r.clone());
    }

    protected Object duplicateObject() {
        ZEllipse newEllipse = (ZEllipse)super.duplicateObject();
        newEllipse.ellipse = (Ellipse2D)this.getEllipse().clone();
        return newEllipse;
    }

    public Ellipse2D getEllipse() {
        if (this.ellipse == null) {
            this.ellipse = new Ellipse2D.Double();
        }
        return this.ellipse;
    }

    public void setFrame(double x, double y, double width, double height) {
        this.ellipse.setFrame(x, y, width, height);
        this.reshape();
    }

    public void setFrame(Ellipse2D r) {
        this.setEllipse(r);
    }

    public Shape getShape() {
        return this.ellipse;
    }

    public void setEllipse(Ellipse2D aEllipse) {
        this.getEllipse().setFrame(aEllipse.getX(), aEllipse.getY(), aEllipse.getWidth(), aEllipse.getHeight());
        this.reshape();
    }

    public void writeObject(ZObjectOutputStream out) throws IOException {
        super.writeObject(out);
        Vector<Double> dimensions = new Vector<Double>();
        Ellipse2D ellipse = this.getEllipse();
        dimensions.add(new Double(ellipse.getX()));
        dimensions.add(new Double(ellipse.getY()));
        dimensions.add(new Double(ellipse.getWidth()));
        dimensions.add(new Double(ellipse.getHeight()));
        out.writeState("ellipse", "ellipse", dimensions);
    }

    public void setState(String fieldType, String fieldName, Object fieldValue) {
        super.setState(fieldType, fieldName, fieldValue);
        if (fieldName.compareTo("ellipse") == 0) {
            Vector dim = (Vector)fieldValue;
            double xpos = (Double)dim.get(0);
            double ypos = (Double)dim.get(1);
            double width = (Double)dim.get(2);
            double height = (Double)dim.get(3);
            this.setFrame(xpos, ypos, width, height);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        Ellipse2D ellipse = this.getEllipse();
        out.writeDouble(ellipse.getX());
        out.writeDouble(ellipse.getY());
        out.writeDouble(ellipse.getWidth());
        out.writeDouble(ellipse.getHeight());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        double x = in.readDouble();
        double y = in.readDouble();
        double w = in.readDouble();
        double h = in.readDouble();
        this.ellipse = new Ellipse2D.Double(x, y, w, h);
    }
}

