/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.filters;

import java.awt.image.BufferedImage;
import java.io.Serializable;

public class RedEyeFilter
implements Serializable {
    private static final long serialVersionUID = -4523066380283659944L;
    private int radius = 20;
    private double value1 = 1.0;
    private double value2 = 0.6;
    private double valueFactor = 0.5;
    private int maxGap = 4;
    private int centerX = 0;
    private int centerY = 0;
    private int width = 0;
    private int height = 0;

    protected RedEyeFilter() {
    }

    public BufferedImage filter(BufferedImage bi) {
        this.width = bi.getWidth();
        this.height = bi.getHeight();
        if (this.centerX > this.width - 1) {
            this.centerX = this.width - 1;
        } else if (this.centerX < 0) {
            this.centerX = 0;
        }
        if (this.centerY > this.height - 1) {
            this.centerY = this.height - 1;
        } else if (this.centerY < 0) {
            this.centerY = 0;
        }
        if (this.radius < 0) {
            this.radius = 0;
        }
        if (this.maxGap < 0) {
            this.maxGap = 0;
        }
        boolean left = this.checkEye(bi, this.centerX - 1, this.centerY, 0, 0);
        boolean up = this.checkEye(bi, this.centerX, this.centerY - 1, 1, 0);
        boolean right = this.checkEye(bi, this.centerX + 1, this.centerY, 2, 0);
        boolean down = this.checkEye(bi, this.centerX, this.centerY + 1, 3, 0);
        if (left && up && right && down) {
            this.colorEye(bi, this.centerX - 1, this.centerY, 0, 0);
            this.colorEye(bi, this.centerX, this.centerY - 1, 1, 0);
            this.colorEye(bi, this.centerX + 1, this.centerY, 2, 0);
            this.colorEye(bi, this.centerX, this.centerY + 1, 3, 0);
        }
        int rgb = bi.getRGB(this.centerX, this.centerY);
        int alpha = (rgb & 0xFF000000) >> 24;
        int r = (rgb & 0xFF0000) >> 16;
        int g = (rgb & 0xFF00) >> 8;
        int b = rgb & 0xFF;
        if ((double)r > (double)(g + b) * this.value2) {
            if ((double)r > (double)(g + b) * this.value1) {
                r = g;
            } else if ((double)r > (double)(g + b) * this.value2) {
                double factor = ((double)r - (double)(g + b) * this.value2) / ((double)(g + b) * this.value1 - (double)(g + b) * this.value2);
                r = (int)((double)r * (1.0 - factor) + (double)g * factor);
            }
            rgb = (alpha & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
            bi.setRGB(this.centerX, this.centerY, rgb);
        }
        return bi;
    }

    protected boolean checkEye(BufferedImage bi, int x, int y, int direction, int gap) {
        boolean check;
        int stepY;
        int stepX;
        int sideY;
        int sideX;
        boolean goLeft;
        int distX = this.centerX - x;
        int distY = this.centerY - y;
        int dist = distX * distX + distY * distY;
        int newGap = 0;
        Boolean checkPixel = this.checkPixel(x, y, direction, gap);
        if (checkPixel != null) {
            return checkPixel;
        }
        int irgb = bi.getRGB(x, y);
        int r = (irgb & 0xFF0000) >> 16;
        int g = (irgb & 0xFF00) >> 8;
        int b = irgb & 0xFF;
        boolean redPixel = false;
        if ((double)r > (double)(g + b) * (this.value2 * 0.5 + this.value1 * 0.5)) {
            redPixel = true;
            newGap = 0;
        } else {
            newGap = gap + 1;
        }
        if (dist > this.radius * this.radius) {
            return !redPixel;
        }
        boolean goCenter = direction % 2 == 1 && x == this.centerX || direction % 2 == 0 && y == this.centerY;
        boolean bl = goLeft = direction == 0 && this.centerY - y < 0 || direction == 1 && this.centerX - x > 0 || direction == 2 && this.centerY - y > 0 || direction == 3 && this.centerX - x < 0;
        if (direction == 0) {
            sideX = 0;
            sideY = 1;
            stepX = -1;
            stepY = 0;
        } else if (direction == 1) {
            sideX = -1;
            sideY = 0;
            stepX = 0;
            stepY = -1;
        } else if (direction == 2) {
            sideX = 0;
            sideY = -1;
            stepX = 1;
            stepY = 0;
        } else {
            sideX = 1;
            sideY = 0;
            stepX = 0;
            stepY = 1;
        }
        boolean left = true;
        boolean main = true;
        boolean right = true;
        if (goLeft || goCenter) {
            left = this.checkEye(bi, x + sideX, y + sideY, direction, newGap);
        }
        if (goCenter) {
            main = this.checkEye(bi, x + stepX, y + stepY, direction, newGap);
        }
        if (!goLeft || goCenter) {
            right = this.checkEye(bi, x - sideX, y - sideY, direction, newGap);
        }
        boolean bl2 = check = left && main && right;
        if (check) {
            return true;
        }
        return gap > 0;
    }

    protected Boolean checkPixel(int x, int y, int direction, int gap) {
        if (gap > this.maxGap) {
            return new Boolean(true);
        }
        if (x < 0 || y < 0 || x > this.width - 1 || y > this.height - 1) {
            return new Boolean(true);
        }
        if (x != this.centerX && y != this.centerY) {
            double angle = Math.toDegrees(Math.atan((double)(this.centerY - y) / (double)(x - this.centerX)));
            if ((angle += 180.0 * (0.5 - (double)((x - this.centerX) / Math.abs(x - this.centerX)) * 0.5)) < 0.0) {
                angle = 360.0 + angle;
            }
            if (!(angle < 45.0 && direction == 2 || angle >= 45.0 && angle <= 135.0 && direction == 1 || angle > 135.0 && angle < 225.0 && direction == 0 || angle >= 225.0 && angle <= 315.0 && direction == 3 || angle > 315.0 && direction == 2)) {
                return new Boolean(true);
            }
        }
        return null;
    }

    protected boolean colorEye(BufferedImage bi, int x, int y, int direction, int gap) {
        boolean check;
        int stepY;
        int stepX;
        int sideY;
        int sideX;
        boolean goLeft;
        int distX = this.centerX - x;
        int distY = this.centerY - y;
        int dist = distX * distX + distY * distY;
        int newGap = 0;
        Boolean checkPixel = this.checkPixel(x, y, direction, gap);
        if (checkPixel != null) {
            return checkPixel;
        }
        int rgb = bi.getRGB(x, y);
        int alpha = (rgb & 0xFF000000) >> 24;
        int r = (rgb & 0xFF0000) >> 16;
        int g = (rgb & 0xFF00) >> 8;
        int b = rgb & 0xFF;
        boolean redPixel = false;
        if ((double)r > (double)(g + b) * (this.value2 * this.valueFactor + this.value1 * (1.0 - this.valueFactor))) {
            redPixel = true;
            newGap = 0;
        } else {
            newGap = gap + 1;
        }
        if (dist > this.radius * this.radius) {
            return !redPixel;
        }
        boolean goCenter = direction % 2 == 1 && x == this.centerX || direction % 2 == 0 && y == this.centerY;
        boolean bl = goLeft = direction == 0 && this.centerY - y < 0 || direction == 1 && this.centerX - x > 0 || direction == 2 && this.centerY - y > 0 || direction == 3 && this.centerX - x < 0;
        if (direction == 0) {
            sideX = 0;
            sideY = 1;
            stepX = -1;
            stepY = 0;
        } else if (direction == 1) {
            sideX = -1;
            sideY = 0;
            stepX = 0;
            stepY = -1;
        } else if (direction == 2) {
            sideX = 0;
            sideY = -1;
            stepX = 1;
            stepY = 0;
        } else {
            sideX = 1;
            sideY = 0;
            stepX = 0;
            stepY = 1;
        }
        boolean left = true;
        boolean main = true;
        boolean right = true;
        if (goLeft || goCenter) {
            left = this.colorEye(bi, x + sideX, y + sideY, direction, newGap);
        }
        if (goCenter) {
            main = this.colorEye(bi, x + stepX, y + stepY, direction, newGap);
        }
        if (!goLeft || goCenter) {
            right = this.colorEye(bi, x - sideX, y - sideY, direction, newGap);
        }
        boolean bl2 = check = left && main && right;
        if (check) {
            if ((double)r > (double)(g + b) * this.value2) {
                if ((double)r > (double)(g + b) * this.value1) {
                    r = g;
                } else if ((double)r > (double)(g + b) * this.value2) {
                    double factor = ((double)r - (double)(g + b) * this.value2) / ((double)(g + b) * this.value1 - (double)(g + b) * this.value2);
                    r = (int)((double)r * (1.0 - factor) + (double)g * factor);
                }
                rgb = (alpha & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
                bi.setRGB(x, y, rgb);
            }
            return true;
        }
        return gap > 0;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public int getX() {
        return this.centerX;
    }

    public void setX(int x) {
        this.centerX = x;
    }

    public int getY() {
        return this.centerY;
    }

    public void setY(int y) {
        this.centerY = y;
    }

    public double getValue1() {
        return this.value1;
    }

    public void setValue1(double value1) {
        this.value1 = value1;
    }

    public double getValue2() {
        return this.value2;
    }

    public void setValue2(double value2) {
        this.value2 = value2;
    }

    public int getMaxGap() {
        return this.maxGap;
    }

    public void setMaxGap(int maxGap) {
        this.maxGap = maxGap;
    }

    public double getValueFactor() {
        return this.valueFactor;
    }

    public void setValueFactor(double valueFactor) {
        this.valueFactor = valueFactor;
    }

    public int getCenterX() {
        return this.centerX;
    }

    public void setCenterX(int centerX) {
        this.centerX = centerX;
    }

    public int getCenterY() {
        return this.centerY;
    }

    public void setCenterY(int centerY) {
        this.centerY = centerY;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }
}

