/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.resty.web;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URLConnection;
import net.jalbum.resty.web.Resty;

public abstract class AbstractResource
extends Resty {
    protected URLConnection urlConnection;
    protected InputStream inputStream;

    public AbstractResource(Resty.Option ... options) {
        super(options);
    }

    abstract String getAcceptedTypes();

    void fill(URLConnection anUrlConnection) throws IOException {
        this.urlConnection = anUrlConnection;
        try {
            this.inputStream = anUrlConnection.getInputStream();
        }
        catch (IOException e) {
            if (anUrlConnection instanceof HttpURLConnection) {
                int read;
                HttpURLConnection conn = (HttpURLConnection)anUrlConnection;
                BufferedInputStream es = new BufferedInputStream(conn.getErrorStream());
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                while ((read = ((InputStream)es).read()) != -1) {
                    baos.write(read);
                }
                ((InputStream)es).close();
                throw new IOException("Error while reading from " + conn.getRequestMethod() + ": [" + conn.getResponseCode() + "] " + conn.getResponseMessage() + "\n" + new String(baos.toByteArray(), "UTF-8"), e);
            }
            throw e;
        }
    }

    public URLConnection getUrlConnection() {
        return this.urlConnection;
    }

    public HttpURLConnection http() {
        return (HttpURLConnection)this.urlConnection;
    }

    public InputStream stream() {
        return this.inputStream;
    }

    public boolean status(int responseCode) {
        if (this.urlConnection instanceof HttpURLConnection) {
            HttpURLConnection http = (HttpURLConnection)this.urlConnection;
            try {
                return http.getResponseCode() == responseCode;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return false;
    }

    public URI location() {
        String loc = this.http().getHeaderField("Location");
        if (loc != null) {
            return URI.create(loc);
        }
        return null;
    }
}

