/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import se.datadosen.component.ChooserFactory;
import se.datadosen.component.PathChooser;
import se.datadosen.jalbum.Icons;

public class JFileSelector
extends JPanel {
    protected String title;
    protected File selectedFile;
    protected JTextComponent textComponent;
    protected JButton button = new JButton(Icons.getIcon("small.folder"));
    protected boolean directories;
    private DocumentListener documentListener = new DocumentListener(){

        public void insertUpdate(DocumentEvent e) {
            JFileSelector.this.textComponentChanged();
        }

        public void removeUpdate(DocumentEvent e) {
            JFileSelector.this.textComponentChanged();
        }

        public void changedUpdate(DocumentEvent e) {
            JFileSelector.this.textComponentChanged();
        }
    };
    private PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if (JFileSelector.this.textComponent != null) {
                if (evt.getPropertyName().equals("selectedFile")) {
                    JFileSelector.this.textComponent.getDocument().removeDocumentListener(JFileSelector.this.documentListener);
                    JFileSelector.this.textComponent.setText(JFileSelector.this.selectedFile.getAbsolutePath());
                    JFileSelector.this.textComponent.getDocument().addDocumentListener(JFileSelector.this.documentListener);
                } else if (evt.getPropertyName().equals("enabled")) {
                    JFileSelector.this.textComponent.setEnabled(JFileSelector.this.isEnabled());
                }
            }
        }
    };
    Vector listeners;

    public JFileSelector() {
        this("");
    }

    public JFileSelector(String title) {
        this.title = title;
        this.addPropertyChangeListener(this.propertyChangeListener);
        try {
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void textComponentChanged() {
        this.removePropertyChangeListener(this.propertyChangeListener);
        this.setSelectedFile(new File(this.textComponent.getText()));
        this.addPropertyChangeListener(this.propertyChangeListener);
    }

    public JFileSelector(JTextComponent comp) {
        this("");
        this.setTextComponent(comp);
    }

    public JFileSelector(String title, JTextField comp) {
        this(title);
        this.setTextComponent(comp);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isDirectories() {
        return this.directories;
    }

    public void setDirectories(boolean directories) {
        this.directories = directories;
    }

    public JTextComponent getTextComponent() {
        return this.textComponent;
    }

    public final void setTextComponent(JTextComponent textComponent) {
        if (textComponent != null) {
            textComponent.getDocument().removeDocumentListener(this.documentListener);
        }
        this.textComponent = textComponent;
        textComponent.setText(this.selectedFile != null ? this.selectedFile.getAbsolutePath() : "");
        textComponent.getDocument().addDocumentListener(this.documentListener);
    }

    public String toString() {
        return this.selectedFile != null ? this.selectedFile.getAbsolutePath() : "";
    }

    public File getSelectedFile() {
        return this.selectedFile;
    }

    public void setSelectedFile(File selectedFile) {
        File oldFile = this.selectedFile;
        this.selectedFile = selectedFile;
        this.firePropertyChange("selectedFile", oldFile, selectedFile);
    }

    private void init() throws Exception {
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.button.setMargin(new Insets(3, 3, 3, 3));
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int res = -1;
                PathChooser chooser = JFileSelector.this.directories ? ChooserFactory.createDirectoryChooser(SwingUtilities.getWindowAncestor(JFileSelector.this)) : ChooserFactory.createFileChooser(SwingUtilities.getWindowAncestor(JFileSelector.this));
                if (JFileSelector.this.selectedFile != null) {
                    chooser.setSelectedFile(JFileSelector.this.selectedFile);
                    chooser.setCurrentDirectory(JFileSelector.this.selectedFile.getParentFile());
                }
                chooser.setDialogTitle(JFileSelector.this.title);
                res = chooser.showOpenDialog(JFileSelector.this);
                if (res == 0) {
                    JFileSelector.this.setSelectedFile(chooser.getSelectedFile());
                    JFileSelector.this.fireActionOccured(new ActionEvent(JFileSelector.this, 0, JFileSelector.this.selectedFile.getAbsolutePath()));
                }
            }
        });
        this.add((Component)this.button, "Center");
    }

    public synchronized void removeActionListener(ActionListener l) {
        if (this.listeners != null && this.listeners.contains(l)) {
            Vector v = (Vector)this.listeners.clone();
            v.removeElement(l);
            this.listeners = v;
        }
    }

    public synchronized void addActionListener(ActionListener l) {
        Vector v;
        Vector vector = v = this.listeners == null ? new Vector(2) : (Vector)this.listeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.listeners = v;
        }
    }

    protected void fireActionOccured(ActionEvent e) {
        if (this.listeners != null) {
            int count = this.listeners.size();
            for (int i = 0; i < count; ++i) {
                ((ActionListener)this.listeners.elementAt(i)).actionPerformed(e);
            }
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.button.setEnabled(enabled);
    }

    public void setToolTipText(String text) {
        this.button.setToolTipText(text);
    }
}

